/*
 * Component description for TRAM
 *
 * Copyright (c) 2024 Microchip Technology Inc. and its subsidiaries.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* file generated from device description file (ATDF) version 2024-04-02T09:16:38Z */
#ifndef _PIC32CKSG01_TRAM_COMPONENT_H_
#define _PIC32CKSG01_TRAM_COMPONENT_H_

/* ************************************************************************** */
/*   SOFTWARE API DEFINITION FOR TRAM                                         */
/* ************************************************************************** */

/* -------- TRAM_CTRLA : (TRAM Offset: 0x00) (R/W 32) Control -------- */
#define TRAM_CTRLA_RESETVALUE                 _UINT32_(0x00)                                       /*  (TRAM_CTRLA) Control  Reset Value */

#define TRAM_CTRLA_SWRST_Pos                  _UINT32_(0)                                          /* (TRAM_CTRLA) Software Reset Position */
#define TRAM_CTRLA_SWRST_Msk                  (_UINT32_(0x1) << TRAM_CTRLA_SWRST_Pos)              /* (TRAM_CTRLA) Software Reset Mask */
#define TRAM_CTRLA_SWRST(value)               (TRAM_CTRLA_SWRST_Msk & (_UINT32_(value) << TRAM_CTRLA_SWRST_Pos)) /* Assigment of value for SWRST in the TRAM_CTRLA register */
#define TRAM_CTRLA_ENABLE_Pos                 _UINT32_(1)                                          /* (TRAM_CTRLA) Enable Position */
#define TRAM_CTRLA_ENABLE_Msk                 (_UINT32_(0x1) << TRAM_CTRLA_ENABLE_Pos)             /* (TRAM_CTRLA) Enable Mask */
#define TRAM_CTRLA_ENABLE(value)              (TRAM_CTRLA_ENABLE_Msk & (_UINT32_(value) << TRAM_CTRLA_ENABLE_Pos)) /* Assigment of value for ENABLE in the TRAM_CTRLA register */
#define TRAM_CTRLA_TAMPERS_Pos                _UINT32_(4)                                          /* (TRAM_CTRLA) Tamper Erase Position */
#define TRAM_CTRLA_TAMPERS_Msk                (_UINT32_(0x1) << TRAM_CTRLA_TAMPERS_Pos)            /* (TRAM_CTRLA) Tamper Erase Mask */
#define TRAM_CTRLA_TAMPERS(value)             (TRAM_CTRLA_TAMPERS_Msk & (_UINT32_(value) << TRAM_CTRLA_TAMPERS_Pos)) /* Assigment of value for TAMPERS in the TRAM_CTRLA register */
#define TRAM_CTRLA_DRP_Pos                    _UINT32_(6)                                          /* (TRAM_CTRLA) Data Remanence Prevention Position */
#define TRAM_CTRLA_DRP_Msk                    (_UINT32_(0x1) << TRAM_CTRLA_DRP_Pos)                /* (TRAM_CTRLA) Data Remanence Prevention Mask */
#define TRAM_CTRLA_DRP(value)                 (TRAM_CTRLA_DRP_Msk & (_UINT32_(value) << TRAM_CTRLA_DRP_Pos)) /* Assigment of value for DRP in the TRAM_CTRLA register */
#define TRAM_CTRLA_SILACC_Pos                 _UINT32_(7)                                          /* (TRAM_CTRLA) Silent Access Position */
#define TRAM_CTRLA_SILACC_Msk                 (_UINT32_(0x1) << TRAM_CTRLA_SILACC_Pos)             /* (TRAM_CTRLA) Silent Access Mask */
#define TRAM_CTRLA_SILACC(value)              (TRAM_CTRLA_SILACC_Msk & (_UINT32_(value) << TRAM_CTRLA_SILACC_Pos)) /* Assigment of value for SILACC in the TRAM_CTRLA register */
#define TRAM_CTRLA_Msk                        _UINT32_(0x000000D3)                                 /* (TRAM_CTRLA) Register Mask  */


/* -------- TRAM_INTENCLR : (TRAM Offset: 0x04) (R/W 32) Interrupt Enable Clear -------- */
#define TRAM_INTENCLR_RESETVALUE              _UINT32_(0x00)                                       /*  (TRAM_INTENCLR) Interrupt Enable Clear  Reset Value */

#define TRAM_INTENCLR_ERR_Pos                 _UINT32_(0)                                          /* (TRAM_INTENCLR) TrustRAM Readout Error Interrupt Enable Position */
#define TRAM_INTENCLR_ERR_Msk                 (_UINT32_(0x1) << TRAM_INTENCLR_ERR_Pos)             /* (TRAM_INTENCLR) TrustRAM Readout Error Interrupt Enable Mask */
#define TRAM_INTENCLR_ERR(value)              (TRAM_INTENCLR_ERR_Msk & (_UINT32_(value) << TRAM_INTENCLR_ERR_Pos)) /* Assigment of value for ERR in the TRAM_INTENCLR register */
#define TRAM_INTENCLR_DRP_Pos                 _UINT32_(1)                                          /* (TRAM_INTENCLR) Data Remanence Prevention Ended Interrupt Enable Position */
#define TRAM_INTENCLR_DRP_Msk                 (_UINT32_(0x1) << TRAM_INTENCLR_DRP_Pos)             /* (TRAM_INTENCLR) Data Remanence Prevention Ended Interrupt Enable Mask */
#define TRAM_INTENCLR_DRP(value)              (TRAM_INTENCLR_DRP_Msk & (_UINT32_(value) << TRAM_INTENCLR_DRP_Pos)) /* Assigment of value for DRP in the TRAM_INTENCLR register */
#define TRAM_INTENCLR_Msk                     _UINT32_(0x00000003)                                 /* (TRAM_INTENCLR) Register Mask  */


/* -------- TRAM_INTENSET : (TRAM Offset: 0x08) (R/W 32) Interrupt Enable Set -------- */
#define TRAM_INTENSET_RESETVALUE              _UINT32_(0x00)                                       /*  (TRAM_INTENSET) Interrupt Enable Set  Reset Value */

#define TRAM_INTENSET_ERR_Pos                 _UINT32_(0)                                          /* (TRAM_INTENSET) TrustRAM Readout Error Interrupt Enable Position */
#define TRAM_INTENSET_ERR_Msk                 (_UINT32_(0x1) << TRAM_INTENSET_ERR_Pos)             /* (TRAM_INTENSET) TrustRAM Readout Error Interrupt Enable Mask */
#define TRAM_INTENSET_ERR(value)              (TRAM_INTENSET_ERR_Msk & (_UINT32_(value) << TRAM_INTENSET_ERR_Pos)) /* Assigment of value for ERR in the TRAM_INTENSET register */
#define TRAM_INTENSET_DRP_Pos                 _UINT32_(1)                                          /* (TRAM_INTENSET) Data Remanence Prevention Ended Interrupt Enable Position */
#define TRAM_INTENSET_DRP_Msk                 (_UINT32_(0x1) << TRAM_INTENSET_DRP_Pos)             /* (TRAM_INTENSET) Data Remanence Prevention Ended Interrupt Enable Mask */
#define TRAM_INTENSET_DRP(value)              (TRAM_INTENSET_DRP_Msk & (_UINT32_(value) << TRAM_INTENSET_DRP_Pos)) /* Assigment of value for DRP in the TRAM_INTENSET register */
#define TRAM_INTENSET_Msk                     _UINT32_(0x00000003)                                 /* (TRAM_INTENSET) Register Mask  */


/* -------- TRAM_INTFLAG : (TRAM Offset: 0x0C) (R/W 32) Interrupt Flag Status and Clear -------- */
#define TRAM_INTFLAG_RESETVALUE               _UINT32_(0x00)                                       /*  (TRAM_INTFLAG) Interrupt Flag Status and Clear  Reset Value */

#define TRAM_INTFLAG_ERR_Pos                  _UINT32_(0)                                          /* (TRAM_INTFLAG) TrustRAM Readout Error Position */
#define TRAM_INTFLAG_ERR_Msk                  (_UINT32_(0x1) << TRAM_INTFLAG_ERR_Pos)              /* (TRAM_INTFLAG) TrustRAM Readout Error Mask */
#define TRAM_INTFLAG_ERR(value)               (TRAM_INTFLAG_ERR_Msk & (_UINT32_(value) << TRAM_INTFLAG_ERR_Pos)) /* Assigment of value for ERR in the TRAM_INTFLAG register */
#define TRAM_INTFLAG_DRP_Pos                  _UINT32_(1)                                          /* (TRAM_INTFLAG) Data Remanence Prevention Ended Position */
#define TRAM_INTFLAG_DRP_Msk                  (_UINT32_(0x1) << TRAM_INTFLAG_DRP_Pos)              /* (TRAM_INTFLAG) Data Remanence Prevention Ended Mask */
#define TRAM_INTFLAG_DRP(value)               (TRAM_INTFLAG_DRP_Msk & (_UINT32_(value) << TRAM_INTFLAG_DRP_Pos)) /* Assigment of value for DRP in the TRAM_INTFLAG register */
#define TRAM_INTFLAG_Msk                      _UINT32_(0x00000003)                                 /* (TRAM_INTFLAG) Register Mask  */


/* -------- TRAM_STATUS : (TRAM Offset: 0x10) ( R/ 32) Status -------- */
#define TRAM_STATUS_RESETVALUE                _UINT32_(0x00)                                       /*  (TRAM_STATUS) Status  Reset Value */

#define TRAM_STATUS_RAMINV_Pos                _UINT32_(0)                                          /* (TRAM_STATUS) RAM Inversion Bit Position */
#define TRAM_STATUS_RAMINV_Msk                (_UINT32_(0x1) << TRAM_STATUS_RAMINV_Pos)            /* (TRAM_STATUS) RAM Inversion Bit Mask */
#define TRAM_STATUS_RAMINV(value)             (TRAM_STATUS_RAMINV_Msk & (_UINT32_(value) << TRAM_STATUS_RAMINV_Pos)) /* Assigment of value for RAMINV in the TRAM_STATUS register */
#define TRAM_STATUS_DRP_Pos                   _UINT32_(1)                                          /* (TRAM_STATUS) Data Remanence Prevention Ongoing Position */
#define TRAM_STATUS_DRP_Msk                   (_UINT32_(0x1) << TRAM_STATUS_DRP_Pos)               /* (TRAM_STATUS) Data Remanence Prevention Ongoing Mask */
#define TRAM_STATUS_DRP(value)                (TRAM_STATUS_DRP_Msk & (_UINT32_(value) << TRAM_STATUS_DRP_Pos)) /* Assigment of value for DRP in the TRAM_STATUS register */
#define TRAM_STATUS_Msk                       _UINT32_(0x00000003)                                 /* (TRAM_STATUS) Register Mask  */


/* -------- TRAM_SYNCBUSY : (TRAM Offset: 0x14) ( R/ 32) Synchronization Busy Status -------- */
#define TRAM_SYNCBUSY_RESETVALUE              _UINT32_(0x00)                                       /*  (TRAM_SYNCBUSY) Synchronization Busy Status  Reset Value */

#define TRAM_SYNCBUSY_SWRST_Pos               _UINT32_(0)                                          /* (TRAM_SYNCBUSY) Software Reset Busy Position */
#define TRAM_SYNCBUSY_SWRST_Msk               (_UINT32_(0x1) << TRAM_SYNCBUSY_SWRST_Pos)           /* (TRAM_SYNCBUSY) Software Reset Busy Mask */
#define TRAM_SYNCBUSY_SWRST(value)            (TRAM_SYNCBUSY_SWRST_Msk & (_UINT32_(value) << TRAM_SYNCBUSY_SWRST_Pos)) /* Assigment of value for SWRST in the TRAM_SYNCBUSY register */
#define TRAM_SYNCBUSY_ENABLE_Pos              _UINT32_(1)                                          /* (TRAM_SYNCBUSY) Enable Busy Position */
#define TRAM_SYNCBUSY_ENABLE_Msk              (_UINT32_(0x1) << TRAM_SYNCBUSY_ENABLE_Pos)          /* (TRAM_SYNCBUSY) Enable Busy Mask */
#define TRAM_SYNCBUSY_ENABLE(value)           (TRAM_SYNCBUSY_ENABLE_Msk & (_UINT32_(value) << TRAM_SYNCBUSY_ENABLE_Pos)) /* Assigment of value for ENABLE in the TRAM_SYNCBUSY register */
#define TRAM_SYNCBUSY_Msk                     _UINT32_(0x00000003)                                 /* (TRAM_SYNCBUSY) Register Mask  */


/* -------- TRAM_DSCC : (TRAM Offset: 0x18) ( /W 32) Data Scramble Control -------- */
#define TRAM_DSCC_RESETVALUE                  _UINT32_(0x00)                                       /*  (TRAM_DSCC) Data Scramble Control  Reset Value */

#define TRAM_DSCC_DSCKEY_Pos                  _UINT32_(0)                                          /* (TRAM_DSCC) Data Scramble Key Position */
#define TRAM_DSCC_DSCKEY_Msk                  (_UINT32_(0x3FFFFFFF) << TRAM_DSCC_DSCKEY_Pos)       /* (TRAM_DSCC) Data Scramble Key Mask */
#define TRAM_DSCC_DSCKEY(value)               (TRAM_DSCC_DSCKEY_Msk & (_UINT32_(value) << TRAM_DSCC_DSCKEY_Pos)) /* Assigment of value for DSCKEY in the TRAM_DSCC register */
#define TRAM_DSCC_DSCEN_Pos                   _UINT32_(31)                                         /* (TRAM_DSCC) Data Scramble Enable Position */
#define TRAM_DSCC_DSCEN_Msk                   (_UINT32_(0x1) << TRAM_DSCC_DSCEN_Pos)               /* (TRAM_DSCC) Data Scramble Enable Mask */
#define TRAM_DSCC_DSCEN(value)                (TRAM_DSCC_DSCEN_Msk & (_UINT32_(value) << TRAM_DSCC_DSCEN_Pos)) /* Assigment of value for DSCEN in the TRAM_DSCC register */
#define TRAM_DSCC_Msk                         _UINT32_(0xBFFFFFFF)                                 /* (TRAM_DSCC) Register Mask  */


/* -------- TRAM_PERMW : (TRAM Offset: 0x1C) ( /W 32) Permutation Write -------- */
#define TRAM_PERMW_RESETVALUE                 _UINT32_(0x00)                                       /*  (TRAM_PERMW) Permutation Write  Reset Value */

#define TRAM_PERMW_DATA_Pos                   _UINT32_(0)                                          /* (TRAM_PERMW) Permutation Scrambler Data Input Position */
#define TRAM_PERMW_DATA_Msk                   (_UINT32_(0x7) << TRAM_PERMW_DATA_Pos)               /* (TRAM_PERMW) Permutation Scrambler Data Input Mask */
#define TRAM_PERMW_DATA(value)                (TRAM_PERMW_DATA_Msk & (_UINT32_(value) << TRAM_PERMW_DATA_Pos)) /* Assigment of value for DATA in the TRAM_PERMW register */
#define TRAM_PERMW_Msk                        _UINT32_(0x00000007)                                 /* (TRAM_PERMW) Register Mask  */


/* -------- TRAM_PERMR : (TRAM Offset: 0x20) ( R/ 32) Permutation Read -------- */
#define TRAM_PERMR_RESETVALUE                 _UINT32_(0x00)                                       /*  (TRAM_PERMR) Permutation Read  Reset Value */

#define TRAM_PERMR_DATA_Pos                   _UINT32_(0)                                          /* (TRAM_PERMR) Permutation Scrambler Data Output Position */
#define TRAM_PERMR_DATA_Msk                   (_UINT32_(0x7) << TRAM_PERMR_DATA_Pos)               /* (TRAM_PERMR) Permutation Scrambler Data Output Mask */
#define TRAM_PERMR_DATA(value)                (TRAM_PERMR_DATA_Msk & (_UINT32_(value) << TRAM_PERMR_DATA_Pos)) /* Assigment of value for DATA in the TRAM_PERMR register */
#define TRAM_PERMR_Msk                        _UINT32_(0x00000007)                                 /* (TRAM_PERMR) Register Mask  */


/* -------- TRAM_RAM : (TRAM Offset: 0x1000) (R/W 32) TrustRAM -------- */
#define TRAM_RAM_RESETVALUE                   _UINT32_(0x00)                                       /*  (TRAM_RAM) TrustRAM  Reset Value */

#define TRAM_RAM_DATA_Pos                     _UINT32_(0)                                          /* (TRAM_RAM) Trust RAM Data Position */
#define TRAM_RAM_DATA_Msk                     (_UINT32_(0xFFFFFFFF) << TRAM_RAM_DATA_Pos)          /* (TRAM_RAM) Trust RAM Data Mask */
#define TRAM_RAM_DATA(value)                  (TRAM_RAM_DATA_Msk & (_UINT32_(value) << TRAM_RAM_DATA_Pos)) /* Assigment of value for DATA in the TRAM_RAM register */
#define TRAM_RAM_Msk                          _UINT32_(0xFFFFFFFF)                                 /* (TRAM_RAM) Register Mask  */


/** \brief TRAM register offsets definitions */
#define TRAM_CTRLA_REG_OFST            _UINT32_(0x00)      /* (TRAM_CTRLA) Control Offset */
#define TRAM_INTENCLR_REG_OFST         _UINT32_(0x04)      /* (TRAM_INTENCLR) Interrupt Enable Clear Offset */
#define TRAM_INTENSET_REG_OFST         _UINT32_(0x08)      /* (TRAM_INTENSET) Interrupt Enable Set Offset */
#define TRAM_INTFLAG_REG_OFST          _UINT32_(0x0C)      /* (TRAM_INTFLAG) Interrupt Flag Status and Clear Offset */
#define TRAM_STATUS_REG_OFST           _UINT32_(0x10)      /* (TRAM_STATUS) Status Offset */
#define TRAM_SYNCBUSY_REG_OFST         _UINT32_(0x14)      /* (TRAM_SYNCBUSY) Synchronization Busy Status Offset */
#define TRAM_DSCC_REG_OFST             _UINT32_(0x18)      /* (TRAM_DSCC) Data Scramble Control Offset */
#define TRAM_PERMW_REG_OFST            _UINT32_(0x1C)      /* (TRAM_PERMW) Permutation Write Offset */
#define TRAM_PERMR_REG_OFST            _UINT32_(0x20)      /* (TRAM_PERMR) Permutation Read Offset */
#define TRAM_RAM_REG_OFST              _UINT32_(0x1000)    /* (TRAM_RAM) TrustRAM Offset */
#define TRAM_RAM0_REG_OFST             _UINT32_(0x1000)    /* (TRAM_RAM0) TrustRAM Offset */
#define TRAM_RAM1_REG_OFST             _UINT32_(0x1004)    /* (TRAM_RAM1) TrustRAM Offset */
#define TRAM_RAM2_REG_OFST             _UINT32_(0x1008)    /* (TRAM_RAM2) TrustRAM Offset */
#define TRAM_RAM3_REG_OFST             _UINT32_(0x100C)    /* (TRAM_RAM3) TrustRAM Offset */
#define TRAM_RAM4_REG_OFST             _UINT32_(0x1010)    /* (TRAM_RAM4) TrustRAM Offset */
#define TRAM_RAM5_REG_OFST             _UINT32_(0x1014)    /* (TRAM_RAM5) TrustRAM Offset */
#define TRAM_RAM6_REG_OFST             _UINT32_(0x1018)    /* (TRAM_RAM6) TrustRAM Offset */
#define TRAM_RAM7_REG_OFST             _UINT32_(0x101C)    /* (TRAM_RAM7) TrustRAM Offset */
#define TRAM_RAM8_REG_OFST             _UINT32_(0x1020)    /* (TRAM_RAM8) TrustRAM Offset */
#define TRAM_RAM9_REG_OFST             _UINT32_(0x1024)    /* (TRAM_RAM9) TrustRAM Offset */
#define TRAM_RAM10_REG_OFST            _UINT32_(0x1028)    /* (TRAM_RAM10) TrustRAM Offset */
#define TRAM_RAM11_REG_OFST            _UINT32_(0x102C)    /* (TRAM_RAM11) TrustRAM Offset */
#define TRAM_RAM12_REG_OFST            _UINT32_(0x1030)    /* (TRAM_RAM12) TrustRAM Offset */
#define TRAM_RAM13_REG_OFST            _UINT32_(0x1034)    /* (TRAM_RAM13) TrustRAM Offset */
#define TRAM_RAM14_REG_OFST            _UINT32_(0x1038)    /* (TRAM_RAM14) TrustRAM Offset */
#define TRAM_RAM15_REG_OFST            _UINT32_(0x103C)    /* (TRAM_RAM15) TrustRAM Offset */
#define TRAM_RAM16_REG_OFST            _UINT32_(0x1040)    /* (TRAM_RAM16) TrustRAM Offset */
#define TRAM_RAM17_REG_OFST            _UINT32_(0x1044)    /* (TRAM_RAM17) TrustRAM Offset */
#define TRAM_RAM18_REG_OFST            _UINT32_(0x1048)    /* (TRAM_RAM18) TrustRAM Offset */
#define TRAM_RAM19_REG_OFST            _UINT32_(0x104C)    /* (TRAM_RAM19) TrustRAM Offset */
#define TRAM_RAM20_REG_OFST            _UINT32_(0x1050)    /* (TRAM_RAM20) TrustRAM Offset */
#define TRAM_RAM21_REG_OFST            _UINT32_(0x1054)    /* (TRAM_RAM21) TrustRAM Offset */
#define TRAM_RAM22_REG_OFST            _UINT32_(0x1058)    /* (TRAM_RAM22) TrustRAM Offset */
#define TRAM_RAM23_REG_OFST            _UINT32_(0x105C)    /* (TRAM_RAM23) TrustRAM Offset */
#define TRAM_RAM24_REG_OFST            _UINT32_(0x1060)    /* (TRAM_RAM24) TrustRAM Offset */
#define TRAM_RAM25_REG_OFST            _UINT32_(0x1064)    /* (TRAM_RAM25) TrustRAM Offset */
#define TRAM_RAM26_REG_OFST            _UINT32_(0x1068)    /* (TRAM_RAM26) TrustRAM Offset */
#define TRAM_RAM27_REG_OFST            _UINT32_(0x106C)    /* (TRAM_RAM27) TrustRAM Offset */
#define TRAM_RAM28_REG_OFST            _UINT32_(0x1070)    /* (TRAM_RAM28) TrustRAM Offset */
#define TRAM_RAM29_REG_OFST            _UINT32_(0x1074)    /* (TRAM_RAM29) TrustRAM Offset */
#define TRAM_RAM30_REG_OFST            _UINT32_(0x1078)    /* (TRAM_RAM30) TrustRAM Offset */
#define TRAM_RAM31_REG_OFST            _UINT32_(0x107C)    /* (TRAM_RAM31) TrustRAM Offset */
#define TRAM_RAM32_REG_OFST            _UINT32_(0x1080)    /* (TRAM_RAM32) TrustRAM Offset */
#define TRAM_RAM33_REG_OFST            _UINT32_(0x1084)    /* (TRAM_RAM33) TrustRAM Offset */
#define TRAM_RAM34_REG_OFST            _UINT32_(0x1088)    /* (TRAM_RAM34) TrustRAM Offset */
#define TRAM_RAM35_REG_OFST            _UINT32_(0x108C)    /* (TRAM_RAM35) TrustRAM Offset */
#define TRAM_RAM36_REG_OFST            _UINT32_(0x1090)    /* (TRAM_RAM36) TrustRAM Offset */
#define TRAM_RAM37_REG_OFST            _UINT32_(0x1094)    /* (TRAM_RAM37) TrustRAM Offset */
#define TRAM_RAM38_REG_OFST            _UINT32_(0x1098)    /* (TRAM_RAM38) TrustRAM Offset */
#define TRAM_RAM39_REG_OFST            _UINT32_(0x109C)    /* (TRAM_RAM39) TrustRAM Offset */
#define TRAM_RAM40_REG_OFST            _UINT32_(0x10A0)    /* (TRAM_RAM40) TrustRAM Offset */
#define TRAM_RAM41_REG_OFST            _UINT32_(0x10A4)    /* (TRAM_RAM41) TrustRAM Offset */
#define TRAM_RAM42_REG_OFST            _UINT32_(0x10A8)    /* (TRAM_RAM42) TrustRAM Offset */
#define TRAM_RAM43_REG_OFST            _UINT32_(0x10AC)    /* (TRAM_RAM43) TrustRAM Offset */
#define TRAM_RAM44_REG_OFST            _UINT32_(0x10B0)    /* (TRAM_RAM44) TrustRAM Offset */
#define TRAM_RAM45_REG_OFST            _UINT32_(0x10B4)    /* (TRAM_RAM45) TrustRAM Offset */
#define TRAM_RAM46_REG_OFST            _UINT32_(0x10B8)    /* (TRAM_RAM46) TrustRAM Offset */
#define TRAM_RAM47_REG_OFST            _UINT32_(0x10BC)    /* (TRAM_RAM47) TrustRAM Offset */
#define TRAM_RAM48_REG_OFST            _UINT32_(0x10C0)    /* (TRAM_RAM48) TrustRAM Offset */
#define TRAM_RAM49_REG_OFST            _UINT32_(0x10C4)    /* (TRAM_RAM49) TrustRAM Offset */
#define TRAM_RAM50_REG_OFST            _UINT32_(0x10C8)    /* (TRAM_RAM50) TrustRAM Offset */
#define TRAM_RAM51_REG_OFST            _UINT32_(0x10CC)    /* (TRAM_RAM51) TrustRAM Offset */
#define TRAM_RAM52_REG_OFST            _UINT32_(0x10D0)    /* (TRAM_RAM52) TrustRAM Offset */
#define TRAM_RAM53_REG_OFST            _UINT32_(0x10D4)    /* (TRAM_RAM53) TrustRAM Offset */
#define TRAM_RAM54_REG_OFST            _UINT32_(0x10D8)    /* (TRAM_RAM54) TrustRAM Offset */
#define TRAM_RAM55_REG_OFST            _UINT32_(0x10DC)    /* (TRAM_RAM55) TrustRAM Offset */
#define TRAM_RAM56_REG_OFST            _UINT32_(0x10E0)    /* (TRAM_RAM56) TrustRAM Offset */
#define TRAM_RAM57_REG_OFST            _UINT32_(0x10E4)    /* (TRAM_RAM57) TrustRAM Offset */
#define TRAM_RAM58_REG_OFST            _UINT32_(0x10E8)    /* (TRAM_RAM58) TrustRAM Offset */
#define TRAM_RAM59_REG_OFST            _UINT32_(0x10EC)    /* (TRAM_RAM59) TrustRAM Offset */
#define TRAM_RAM60_REG_OFST            _UINT32_(0x10F0)    /* (TRAM_RAM60) TrustRAM Offset */
#define TRAM_RAM61_REG_OFST            _UINT32_(0x10F4)    /* (TRAM_RAM61) TrustRAM Offset */
#define TRAM_RAM62_REG_OFST            _UINT32_(0x10F8)    /* (TRAM_RAM62) TrustRAM Offset */
#define TRAM_RAM63_REG_OFST            _UINT32_(0x10FC)    /* (TRAM_RAM63) TrustRAM Offset */
#define TRAM_RAM64_REG_OFST            _UINT32_(0x1100)    /* (TRAM_RAM64) TrustRAM Offset */
#define TRAM_RAM65_REG_OFST            _UINT32_(0x1104)    /* (TRAM_RAM65) TrustRAM Offset */
#define TRAM_RAM66_REG_OFST            _UINT32_(0x1108)    /* (TRAM_RAM66) TrustRAM Offset */
#define TRAM_RAM67_REG_OFST            _UINT32_(0x110C)    /* (TRAM_RAM67) TrustRAM Offset */
#define TRAM_RAM68_REG_OFST            _UINT32_(0x1110)    /* (TRAM_RAM68) TrustRAM Offset */
#define TRAM_RAM69_REG_OFST            _UINT32_(0x1114)    /* (TRAM_RAM69) TrustRAM Offset */
#define TRAM_RAM70_REG_OFST            _UINT32_(0x1118)    /* (TRAM_RAM70) TrustRAM Offset */
#define TRAM_RAM71_REG_OFST            _UINT32_(0x111C)    /* (TRAM_RAM71) TrustRAM Offset */
#define TRAM_RAM72_REG_OFST            _UINT32_(0x1120)    /* (TRAM_RAM72) TrustRAM Offset */
#define TRAM_RAM73_REG_OFST            _UINT32_(0x1124)    /* (TRAM_RAM73) TrustRAM Offset */
#define TRAM_RAM74_REG_OFST            _UINT32_(0x1128)    /* (TRAM_RAM74) TrustRAM Offset */
#define TRAM_RAM75_REG_OFST            _UINT32_(0x112C)    /* (TRAM_RAM75) TrustRAM Offset */
#define TRAM_RAM76_REG_OFST            _UINT32_(0x1130)    /* (TRAM_RAM76) TrustRAM Offset */
#define TRAM_RAM77_REG_OFST            _UINT32_(0x1134)    /* (TRAM_RAM77) TrustRAM Offset */
#define TRAM_RAM78_REG_OFST            _UINT32_(0x1138)    /* (TRAM_RAM78) TrustRAM Offset */
#define TRAM_RAM79_REG_OFST            _UINT32_(0x113C)    /* (TRAM_RAM79) TrustRAM Offset */
#define TRAM_RAM80_REG_OFST            _UINT32_(0x1140)    /* (TRAM_RAM80) TrustRAM Offset */
#define TRAM_RAM81_REG_OFST            _UINT32_(0x1144)    /* (TRAM_RAM81) TrustRAM Offset */
#define TRAM_RAM82_REG_OFST            _UINT32_(0x1148)    /* (TRAM_RAM82) TrustRAM Offset */
#define TRAM_RAM83_REG_OFST            _UINT32_(0x114C)    /* (TRAM_RAM83) TrustRAM Offset */
#define TRAM_RAM84_REG_OFST            _UINT32_(0x1150)    /* (TRAM_RAM84) TrustRAM Offset */
#define TRAM_RAM85_REG_OFST            _UINT32_(0x1154)    /* (TRAM_RAM85) TrustRAM Offset */
#define TRAM_RAM86_REG_OFST            _UINT32_(0x1158)    /* (TRAM_RAM86) TrustRAM Offset */
#define TRAM_RAM87_REG_OFST            _UINT32_(0x115C)    /* (TRAM_RAM87) TrustRAM Offset */
#define TRAM_RAM88_REG_OFST            _UINT32_(0x1160)    /* (TRAM_RAM88) TrustRAM Offset */
#define TRAM_RAM89_REG_OFST            _UINT32_(0x1164)    /* (TRAM_RAM89) TrustRAM Offset */
#define TRAM_RAM90_REG_OFST            _UINT32_(0x1168)    /* (TRAM_RAM90) TrustRAM Offset */
#define TRAM_RAM91_REG_OFST            _UINT32_(0x116C)    /* (TRAM_RAM91) TrustRAM Offset */
#define TRAM_RAM92_REG_OFST            _UINT32_(0x1170)    /* (TRAM_RAM92) TrustRAM Offset */
#define TRAM_RAM93_REG_OFST            _UINT32_(0x1174)    /* (TRAM_RAM93) TrustRAM Offset */
#define TRAM_RAM94_REG_OFST            _UINT32_(0x1178)    /* (TRAM_RAM94) TrustRAM Offset */
#define TRAM_RAM95_REG_OFST            _UINT32_(0x117C)    /* (TRAM_RAM95) TrustRAM Offset */
#define TRAM_RAM96_REG_OFST            _UINT32_(0x1180)    /* (TRAM_RAM96) TrustRAM Offset */
#define TRAM_RAM97_REG_OFST            _UINT32_(0x1184)    /* (TRAM_RAM97) TrustRAM Offset */
#define TRAM_RAM98_REG_OFST            _UINT32_(0x1188)    /* (TRAM_RAM98) TrustRAM Offset */
#define TRAM_RAM99_REG_OFST            _UINT32_(0x118C)    /* (TRAM_RAM99) TrustRAM Offset */
#define TRAM_RAM100_REG_OFST           _UINT32_(0x1190)    /* (TRAM_RAM100) TrustRAM Offset */
#define TRAM_RAM101_REG_OFST           _UINT32_(0x1194)    /* (TRAM_RAM101) TrustRAM Offset */
#define TRAM_RAM102_REG_OFST           _UINT32_(0x1198)    /* (TRAM_RAM102) TrustRAM Offset */
#define TRAM_RAM103_REG_OFST           _UINT32_(0x119C)    /* (TRAM_RAM103) TrustRAM Offset */
#define TRAM_RAM104_REG_OFST           _UINT32_(0x11A0)    /* (TRAM_RAM104) TrustRAM Offset */
#define TRAM_RAM105_REG_OFST           _UINT32_(0x11A4)    /* (TRAM_RAM105) TrustRAM Offset */
#define TRAM_RAM106_REG_OFST           _UINT32_(0x11A8)    /* (TRAM_RAM106) TrustRAM Offset */
#define TRAM_RAM107_REG_OFST           _UINT32_(0x11AC)    /* (TRAM_RAM107) TrustRAM Offset */
#define TRAM_RAM108_REG_OFST           _UINT32_(0x11B0)    /* (TRAM_RAM108) TrustRAM Offset */
#define TRAM_RAM109_REG_OFST           _UINT32_(0x11B4)    /* (TRAM_RAM109) TrustRAM Offset */
#define TRAM_RAM110_REG_OFST           _UINT32_(0x11B8)    /* (TRAM_RAM110) TrustRAM Offset */
#define TRAM_RAM111_REG_OFST           _UINT32_(0x11BC)    /* (TRAM_RAM111) TrustRAM Offset */
#define TRAM_RAM112_REG_OFST           _UINT32_(0x11C0)    /* (TRAM_RAM112) TrustRAM Offset */
#define TRAM_RAM113_REG_OFST           _UINT32_(0x11C4)    /* (TRAM_RAM113) TrustRAM Offset */
#define TRAM_RAM114_REG_OFST           _UINT32_(0x11C8)    /* (TRAM_RAM114) TrustRAM Offset */
#define TRAM_RAM115_REG_OFST           _UINT32_(0x11CC)    /* (TRAM_RAM115) TrustRAM Offset */
#define TRAM_RAM116_REG_OFST           _UINT32_(0x11D0)    /* (TRAM_RAM116) TrustRAM Offset */
#define TRAM_RAM117_REG_OFST           _UINT32_(0x11D4)    /* (TRAM_RAM117) TrustRAM Offset */
#define TRAM_RAM118_REG_OFST           _UINT32_(0x11D8)    /* (TRAM_RAM118) TrustRAM Offset */
#define TRAM_RAM119_REG_OFST           _UINT32_(0x11DC)    /* (TRAM_RAM119) TrustRAM Offset */
#define TRAM_RAM120_REG_OFST           _UINT32_(0x11E0)    /* (TRAM_RAM120) TrustRAM Offset */
#define TRAM_RAM121_REG_OFST           _UINT32_(0x11E4)    /* (TRAM_RAM121) TrustRAM Offset */
#define TRAM_RAM122_REG_OFST           _UINT32_(0x11E8)    /* (TRAM_RAM122) TrustRAM Offset */
#define TRAM_RAM123_REG_OFST           _UINT32_(0x11EC)    /* (TRAM_RAM123) TrustRAM Offset */
#define TRAM_RAM124_REG_OFST           _UINT32_(0x11F0)    /* (TRAM_RAM124) TrustRAM Offset */
#define TRAM_RAM125_REG_OFST           _UINT32_(0x11F4)    /* (TRAM_RAM125) TrustRAM Offset */
#define TRAM_RAM126_REG_OFST           _UINT32_(0x11F8)    /* (TRAM_RAM126) TrustRAM Offset */
#define TRAM_RAM127_REG_OFST           _UINT32_(0x11FC)    /* (TRAM_RAM127) TrustRAM Offset */
#define TRAM_RAM128_REG_OFST           _UINT32_(0x1200)    /* (TRAM_RAM128) TrustRAM Offset */
#define TRAM_RAM129_REG_OFST           _UINT32_(0x1204)    /* (TRAM_RAM129) TrustRAM Offset */
#define TRAM_RAM130_REG_OFST           _UINT32_(0x1208)    /* (TRAM_RAM130) TrustRAM Offset */
#define TRAM_RAM131_REG_OFST           _UINT32_(0x120C)    /* (TRAM_RAM131) TrustRAM Offset */
#define TRAM_RAM132_REG_OFST           _UINT32_(0x1210)    /* (TRAM_RAM132) TrustRAM Offset */
#define TRAM_RAM133_REG_OFST           _UINT32_(0x1214)    /* (TRAM_RAM133) TrustRAM Offset */
#define TRAM_RAM134_REG_OFST           _UINT32_(0x1218)    /* (TRAM_RAM134) TrustRAM Offset */
#define TRAM_RAM135_REG_OFST           _UINT32_(0x121C)    /* (TRAM_RAM135) TrustRAM Offset */
#define TRAM_RAM136_REG_OFST           _UINT32_(0x1220)    /* (TRAM_RAM136) TrustRAM Offset */
#define TRAM_RAM137_REG_OFST           _UINT32_(0x1224)    /* (TRAM_RAM137) TrustRAM Offset */
#define TRAM_RAM138_REG_OFST           _UINT32_(0x1228)    /* (TRAM_RAM138) TrustRAM Offset */
#define TRAM_RAM139_REG_OFST           _UINT32_(0x122C)    /* (TRAM_RAM139) TrustRAM Offset */
#define TRAM_RAM140_REG_OFST           _UINT32_(0x1230)    /* (TRAM_RAM140) TrustRAM Offset */
#define TRAM_RAM141_REG_OFST           _UINT32_(0x1234)    /* (TRAM_RAM141) TrustRAM Offset */
#define TRAM_RAM142_REG_OFST           _UINT32_(0x1238)    /* (TRAM_RAM142) TrustRAM Offset */
#define TRAM_RAM143_REG_OFST           _UINT32_(0x123C)    /* (TRAM_RAM143) TrustRAM Offset */
#define TRAM_RAM144_REG_OFST           _UINT32_(0x1240)    /* (TRAM_RAM144) TrustRAM Offset */
#define TRAM_RAM145_REG_OFST           _UINT32_(0x1244)    /* (TRAM_RAM145) TrustRAM Offset */
#define TRAM_RAM146_REG_OFST           _UINT32_(0x1248)    /* (TRAM_RAM146) TrustRAM Offset */
#define TRAM_RAM147_REG_OFST           _UINT32_(0x124C)    /* (TRAM_RAM147) TrustRAM Offset */
#define TRAM_RAM148_REG_OFST           _UINT32_(0x1250)    /* (TRAM_RAM148) TrustRAM Offset */
#define TRAM_RAM149_REG_OFST           _UINT32_(0x1254)    /* (TRAM_RAM149) TrustRAM Offset */
#define TRAM_RAM150_REG_OFST           _UINT32_(0x1258)    /* (TRAM_RAM150) TrustRAM Offset */
#define TRAM_RAM151_REG_OFST           _UINT32_(0x125C)    /* (TRAM_RAM151) TrustRAM Offset */
#define TRAM_RAM152_REG_OFST           _UINT32_(0x1260)    /* (TRAM_RAM152) TrustRAM Offset */
#define TRAM_RAM153_REG_OFST           _UINT32_(0x1264)    /* (TRAM_RAM153) TrustRAM Offset */
#define TRAM_RAM154_REG_OFST           _UINT32_(0x1268)    /* (TRAM_RAM154) TrustRAM Offset */
#define TRAM_RAM155_REG_OFST           _UINT32_(0x126C)    /* (TRAM_RAM155) TrustRAM Offset */
#define TRAM_RAM156_REG_OFST           _UINT32_(0x1270)    /* (TRAM_RAM156) TrustRAM Offset */
#define TRAM_RAM157_REG_OFST           _UINT32_(0x1274)    /* (TRAM_RAM157) TrustRAM Offset */
#define TRAM_RAM158_REG_OFST           _UINT32_(0x1278)    /* (TRAM_RAM158) TrustRAM Offset */
#define TRAM_RAM159_REG_OFST           _UINT32_(0x127C)    /* (TRAM_RAM159) TrustRAM Offset */
#define TRAM_RAM160_REG_OFST           _UINT32_(0x1280)    /* (TRAM_RAM160) TrustRAM Offset */
#define TRAM_RAM161_REG_OFST           _UINT32_(0x1284)    /* (TRAM_RAM161) TrustRAM Offset */
#define TRAM_RAM162_REG_OFST           _UINT32_(0x1288)    /* (TRAM_RAM162) TrustRAM Offset */
#define TRAM_RAM163_REG_OFST           _UINT32_(0x128C)    /* (TRAM_RAM163) TrustRAM Offset */
#define TRAM_RAM164_REG_OFST           _UINT32_(0x1290)    /* (TRAM_RAM164) TrustRAM Offset */
#define TRAM_RAM165_REG_OFST           _UINT32_(0x1294)    /* (TRAM_RAM165) TrustRAM Offset */
#define TRAM_RAM166_REG_OFST           _UINT32_(0x1298)    /* (TRAM_RAM166) TrustRAM Offset */
#define TRAM_RAM167_REG_OFST           _UINT32_(0x129C)    /* (TRAM_RAM167) TrustRAM Offset */
#define TRAM_RAM168_REG_OFST           _UINT32_(0x12A0)    /* (TRAM_RAM168) TrustRAM Offset */
#define TRAM_RAM169_REG_OFST           _UINT32_(0x12A4)    /* (TRAM_RAM169) TrustRAM Offset */
#define TRAM_RAM170_REG_OFST           _UINT32_(0x12A8)    /* (TRAM_RAM170) TrustRAM Offset */
#define TRAM_RAM171_REG_OFST           _UINT32_(0x12AC)    /* (TRAM_RAM171) TrustRAM Offset */
#define TRAM_RAM172_REG_OFST           _UINT32_(0x12B0)    /* (TRAM_RAM172) TrustRAM Offset */
#define TRAM_RAM173_REG_OFST           _UINT32_(0x12B4)    /* (TRAM_RAM173) TrustRAM Offset */
#define TRAM_RAM174_REG_OFST           _UINT32_(0x12B8)    /* (TRAM_RAM174) TrustRAM Offset */
#define TRAM_RAM175_REG_OFST           _UINT32_(0x12BC)    /* (TRAM_RAM175) TrustRAM Offset */
#define TRAM_RAM176_REG_OFST           _UINT32_(0x12C0)    /* (TRAM_RAM176) TrustRAM Offset */
#define TRAM_RAM177_REG_OFST           _UINT32_(0x12C4)    /* (TRAM_RAM177) TrustRAM Offset */
#define TRAM_RAM178_REG_OFST           _UINT32_(0x12C8)    /* (TRAM_RAM178) TrustRAM Offset */
#define TRAM_RAM179_REG_OFST           _UINT32_(0x12CC)    /* (TRAM_RAM179) TrustRAM Offset */
#define TRAM_RAM180_REG_OFST           _UINT32_(0x12D0)    /* (TRAM_RAM180) TrustRAM Offset */
#define TRAM_RAM181_REG_OFST           _UINT32_(0x12D4)    /* (TRAM_RAM181) TrustRAM Offset */
#define TRAM_RAM182_REG_OFST           _UINT32_(0x12D8)    /* (TRAM_RAM182) TrustRAM Offset */
#define TRAM_RAM183_REG_OFST           _UINT32_(0x12DC)    /* (TRAM_RAM183) TrustRAM Offset */
#define TRAM_RAM184_REG_OFST           _UINT32_(0x12E0)    /* (TRAM_RAM184) TrustRAM Offset */
#define TRAM_RAM185_REG_OFST           _UINT32_(0x12E4)    /* (TRAM_RAM185) TrustRAM Offset */
#define TRAM_RAM186_REG_OFST           _UINT32_(0x12E8)    /* (TRAM_RAM186) TrustRAM Offset */
#define TRAM_RAM187_REG_OFST           _UINT32_(0x12EC)    /* (TRAM_RAM187) TrustRAM Offset */
#define TRAM_RAM188_REG_OFST           _UINT32_(0x12F0)    /* (TRAM_RAM188) TrustRAM Offset */
#define TRAM_RAM189_REG_OFST           _UINT32_(0x12F4)    /* (TRAM_RAM189) TrustRAM Offset */
#define TRAM_RAM190_REG_OFST           _UINT32_(0x12F8)    /* (TRAM_RAM190) TrustRAM Offset */
#define TRAM_RAM191_REG_OFST           _UINT32_(0x12FC)    /* (TRAM_RAM191) TrustRAM Offset */
#define TRAM_RAM192_REG_OFST           _UINT32_(0x1300)    /* (TRAM_RAM192) TrustRAM Offset */
#define TRAM_RAM193_REG_OFST           _UINT32_(0x1304)    /* (TRAM_RAM193) TrustRAM Offset */
#define TRAM_RAM194_REG_OFST           _UINT32_(0x1308)    /* (TRAM_RAM194) TrustRAM Offset */
#define TRAM_RAM195_REG_OFST           _UINT32_(0x130C)    /* (TRAM_RAM195) TrustRAM Offset */
#define TRAM_RAM196_REG_OFST           _UINT32_(0x1310)    /* (TRAM_RAM196) TrustRAM Offset */
#define TRAM_RAM197_REG_OFST           _UINT32_(0x1314)    /* (TRAM_RAM197) TrustRAM Offset */
#define TRAM_RAM198_REG_OFST           _UINT32_(0x1318)    /* (TRAM_RAM198) TrustRAM Offset */
#define TRAM_RAM199_REG_OFST           _UINT32_(0x131C)    /* (TRAM_RAM199) TrustRAM Offset */
#define TRAM_RAM200_REG_OFST           _UINT32_(0x1320)    /* (TRAM_RAM200) TrustRAM Offset */
#define TRAM_RAM201_REG_OFST           _UINT32_(0x1324)    /* (TRAM_RAM201) TrustRAM Offset */
#define TRAM_RAM202_REG_OFST           _UINT32_(0x1328)    /* (TRAM_RAM202) TrustRAM Offset */
#define TRAM_RAM203_REG_OFST           _UINT32_(0x132C)    /* (TRAM_RAM203) TrustRAM Offset */
#define TRAM_RAM204_REG_OFST           _UINT32_(0x1330)    /* (TRAM_RAM204) TrustRAM Offset */
#define TRAM_RAM205_REG_OFST           _UINT32_(0x1334)    /* (TRAM_RAM205) TrustRAM Offset */
#define TRAM_RAM206_REG_OFST           _UINT32_(0x1338)    /* (TRAM_RAM206) TrustRAM Offset */
#define TRAM_RAM207_REG_OFST           _UINT32_(0x133C)    /* (TRAM_RAM207) TrustRAM Offset */
#define TRAM_RAM208_REG_OFST           _UINT32_(0x1340)    /* (TRAM_RAM208) TrustRAM Offset */
#define TRAM_RAM209_REG_OFST           _UINT32_(0x1344)    /* (TRAM_RAM209) TrustRAM Offset */
#define TRAM_RAM210_REG_OFST           _UINT32_(0x1348)    /* (TRAM_RAM210) TrustRAM Offset */
#define TRAM_RAM211_REG_OFST           _UINT32_(0x134C)    /* (TRAM_RAM211) TrustRAM Offset */
#define TRAM_RAM212_REG_OFST           _UINT32_(0x1350)    /* (TRAM_RAM212) TrustRAM Offset */
#define TRAM_RAM213_REG_OFST           _UINT32_(0x1354)    /* (TRAM_RAM213) TrustRAM Offset */
#define TRAM_RAM214_REG_OFST           _UINT32_(0x1358)    /* (TRAM_RAM214) TrustRAM Offset */
#define TRAM_RAM215_REG_OFST           _UINT32_(0x135C)    /* (TRAM_RAM215) TrustRAM Offset */
#define TRAM_RAM216_REG_OFST           _UINT32_(0x1360)    /* (TRAM_RAM216) TrustRAM Offset */
#define TRAM_RAM217_REG_OFST           _UINT32_(0x1364)    /* (TRAM_RAM217) TrustRAM Offset */
#define TRAM_RAM218_REG_OFST           _UINT32_(0x1368)    /* (TRAM_RAM218) TrustRAM Offset */
#define TRAM_RAM219_REG_OFST           _UINT32_(0x136C)    /* (TRAM_RAM219) TrustRAM Offset */
#define TRAM_RAM220_REG_OFST           _UINT32_(0x1370)    /* (TRAM_RAM220) TrustRAM Offset */
#define TRAM_RAM221_REG_OFST           _UINT32_(0x1374)    /* (TRAM_RAM221) TrustRAM Offset */
#define TRAM_RAM222_REG_OFST           _UINT32_(0x1378)    /* (TRAM_RAM222) TrustRAM Offset */
#define TRAM_RAM223_REG_OFST           _UINT32_(0x137C)    /* (TRAM_RAM223) TrustRAM Offset */
#define TRAM_RAM224_REG_OFST           _UINT32_(0x1380)    /* (TRAM_RAM224) TrustRAM Offset */
#define TRAM_RAM225_REG_OFST           _UINT32_(0x1384)    /* (TRAM_RAM225) TrustRAM Offset */
#define TRAM_RAM226_REG_OFST           _UINT32_(0x1388)    /* (TRAM_RAM226) TrustRAM Offset */
#define TRAM_RAM227_REG_OFST           _UINT32_(0x138C)    /* (TRAM_RAM227) TrustRAM Offset */
#define TRAM_RAM228_REG_OFST           _UINT32_(0x1390)    /* (TRAM_RAM228) TrustRAM Offset */
#define TRAM_RAM229_REG_OFST           _UINT32_(0x1394)    /* (TRAM_RAM229) TrustRAM Offset */
#define TRAM_RAM230_REG_OFST           _UINT32_(0x1398)    /* (TRAM_RAM230) TrustRAM Offset */
#define TRAM_RAM231_REG_OFST           _UINT32_(0x139C)    /* (TRAM_RAM231) TrustRAM Offset */
#define TRAM_RAM232_REG_OFST           _UINT32_(0x13A0)    /* (TRAM_RAM232) TrustRAM Offset */
#define TRAM_RAM233_REG_OFST           _UINT32_(0x13A4)    /* (TRAM_RAM233) TrustRAM Offset */
#define TRAM_RAM234_REG_OFST           _UINT32_(0x13A8)    /* (TRAM_RAM234) TrustRAM Offset */
#define TRAM_RAM235_REG_OFST           _UINT32_(0x13AC)    /* (TRAM_RAM235) TrustRAM Offset */
#define TRAM_RAM236_REG_OFST           _UINT32_(0x13B0)    /* (TRAM_RAM236) TrustRAM Offset */
#define TRAM_RAM237_REG_OFST           _UINT32_(0x13B4)    /* (TRAM_RAM237) TrustRAM Offset */
#define TRAM_RAM238_REG_OFST           _UINT32_(0x13B8)    /* (TRAM_RAM238) TrustRAM Offset */
#define TRAM_RAM239_REG_OFST           _UINT32_(0x13BC)    /* (TRAM_RAM239) TrustRAM Offset */
#define TRAM_RAM240_REG_OFST           _UINT32_(0x13C0)    /* (TRAM_RAM240) TrustRAM Offset */
#define TRAM_RAM241_REG_OFST           _UINT32_(0x13C4)    /* (TRAM_RAM241) TrustRAM Offset */
#define TRAM_RAM242_REG_OFST           _UINT32_(0x13C8)    /* (TRAM_RAM242) TrustRAM Offset */
#define TRAM_RAM243_REG_OFST           _UINT32_(0x13CC)    /* (TRAM_RAM243) TrustRAM Offset */
#define TRAM_RAM244_REG_OFST           _UINT32_(0x13D0)    /* (TRAM_RAM244) TrustRAM Offset */
#define TRAM_RAM245_REG_OFST           _UINT32_(0x13D4)    /* (TRAM_RAM245) TrustRAM Offset */
#define TRAM_RAM246_REG_OFST           _UINT32_(0x13D8)    /* (TRAM_RAM246) TrustRAM Offset */
#define TRAM_RAM247_REG_OFST           _UINT32_(0x13DC)    /* (TRAM_RAM247) TrustRAM Offset */
#define TRAM_RAM248_REG_OFST           _UINT32_(0x13E0)    /* (TRAM_RAM248) TrustRAM Offset */
#define TRAM_RAM249_REG_OFST           _UINT32_(0x13E4)    /* (TRAM_RAM249) TrustRAM Offset */
#define TRAM_RAM250_REG_OFST           _UINT32_(0x13E8)    /* (TRAM_RAM250) TrustRAM Offset */
#define TRAM_RAM251_REG_OFST           _UINT32_(0x13EC)    /* (TRAM_RAM251) TrustRAM Offset */
#define TRAM_RAM252_REG_OFST           _UINT32_(0x13F0)    /* (TRAM_RAM252) TrustRAM Offset */
#define TRAM_RAM253_REG_OFST           _UINT32_(0x13F4)    /* (TRAM_RAM253) TrustRAM Offset */
#define TRAM_RAM254_REG_OFST           _UINT32_(0x13F8)    /* (TRAM_RAM254) TrustRAM Offset */
#define TRAM_RAM255_REG_OFST           _UINT32_(0x13FC)    /* (TRAM_RAM255) TrustRAM Offset */
#define TRAM_RAM256_REG_OFST           _UINT32_(0x1400)    /* (TRAM_RAM256) TrustRAM Offset */
#define TRAM_RAM257_REG_OFST           _UINT32_(0x1404)    /* (TRAM_RAM257) TrustRAM Offset */
#define TRAM_RAM258_REG_OFST           _UINT32_(0x1408)    /* (TRAM_RAM258) TrustRAM Offset */
#define TRAM_RAM259_REG_OFST           _UINT32_(0x140C)    /* (TRAM_RAM259) TrustRAM Offset */
#define TRAM_RAM260_REG_OFST           _UINT32_(0x1410)    /* (TRAM_RAM260) TrustRAM Offset */
#define TRAM_RAM261_REG_OFST           _UINT32_(0x1414)    /* (TRAM_RAM261) TrustRAM Offset */
#define TRAM_RAM262_REG_OFST           _UINT32_(0x1418)    /* (TRAM_RAM262) TrustRAM Offset */
#define TRAM_RAM263_REG_OFST           _UINT32_(0x141C)    /* (TRAM_RAM263) TrustRAM Offset */
#define TRAM_RAM264_REG_OFST           _UINT32_(0x1420)    /* (TRAM_RAM264) TrustRAM Offset */
#define TRAM_RAM265_REG_OFST           _UINT32_(0x1424)    /* (TRAM_RAM265) TrustRAM Offset */
#define TRAM_RAM266_REG_OFST           _UINT32_(0x1428)    /* (TRAM_RAM266) TrustRAM Offset */
#define TRAM_RAM267_REG_OFST           _UINT32_(0x142C)    /* (TRAM_RAM267) TrustRAM Offset */
#define TRAM_RAM268_REG_OFST           _UINT32_(0x1430)    /* (TRAM_RAM268) TrustRAM Offset */
#define TRAM_RAM269_REG_OFST           _UINT32_(0x1434)    /* (TRAM_RAM269) TrustRAM Offset */
#define TRAM_RAM270_REG_OFST           _UINT32_(0x1438)    /* (TRAM_RAM270) TrustRAM Offset */
#define TRAM_RAM271_REG_OFST           _UINT32_(0x143C)    /* (TRAM_RAM271) TrustRAM Offset */
#define TRAM_RAM272_REG_OFST           _UINT32_(0x1440)    /* (TRAM_RAM272) TrustRAM Offset */
#define TRAM_RAM273_REG_OFST           _UINT32_(0x1444)    /* (TRAM_RAM273) TrustRAM Offset */
#define TRAM_RAM274_REG_OFST           _UINT32_(0x1448)    /* (TRAM_RAM274) TrustRAM Offset */
#define TRAM_RAM275_REG_OFST           _UINT32_(0x144C)    /* (TRAM_RAM275) TrustRAM Offset */
#define TRAM_RAM276_REG_OFST           _UINT32_(0x1450)    /* (TRAM_RAM276) TrustRAM Offset */
#define TRAM_RAM277_REG_OFST           _UINT32_(0x1454)    /* (TRAM_RAM277) TrustRAM Offset */
#define TRAM_RAM278_REG_OFST           _UINT32_(0x1458)    /* (TRAM_RAM278) TrustRAM Offset */
#define TRAM_RAM279_REG_OFST           _UINT32_(0x145C)    /* (TRAM_RAM279) TrustRAM Offset */
#define TRAM_RAM280_REG_OFST           _UINT32_(0x1460)    /* (TRAM_RAM280) TrustRAM Offset */
#define TRAM_RAM281_REG_OFST           _UINT32_(0x1464)    /* (TRAM_RAM281) TrustRAM Offset */
#define TRAM_RAM282_REG_OFST           _UINT32_(0x1468)    /* (TRAM_RAM282) TrustRAM Offset */
#define TRAM_RAM283_REG_OFST           _UINT32_(0x146C)    /* (TRAM_RAM283) TrustRAM Offset */
#define TRAM_RAM284_REG_OFST           _UINT32_(0x1470)    /* (TRAM_RAM284) TrustRAM Offset */
#define TRAM_RAM285_REG_OFST           _UINT32_(0x1474)    /* (TRAM_RAM285) TrustRAM Offset */
#define TRAM_RAM286_REG_OFST           _UINT32_(0x1478)    /* (TRAM_RAM286) TrustRAM Offset */
#define TRAM_RAM287_REG_OFST           _UINT32_(0x147C)    /* (TRAM_RAM287) TrustRAM Offset */
#define TRAM_RAM288_REG_OFST           _UINT32_(0x1480)    /* (TRAM_RAM288) TrustRAM Offset */
#define TRAM_RAM289_REG_OFST           _UINT32_(0x1484)    /* (TRAM_RAM289) TrustRAM Offset */
#define TRAM_RAM290_REG_OFST           _UINT32_(0x1488)    /* (TRAM_RAM290) TrustRAM Offset */
#define TRAM_RAM291_REG_OFST           _UINT32_(0x148C)    /* (TRAM_RAM291) TrustRAM Offset */
#define TRAM_RAM292_REG_OFST           _UINT32_(0x1490)    /* (TRAM_RAM292) TrustRAM Offset */
#define TRAM_RAM293_REG_OFST           _UINT32_(0x1494)    /* (TRAM_RAM293) TrustRAM Offset */
#define TRAM_RAM294_REG_OFST           _UINT32_(0x1498)    /* (TRAM_RAM294) TrustRAM Offset */
#define TRAM_RAM295_REG_OFST           _UINT32_(0x149C)    /* (TRAM_RAM295) TrustRAM Offset */
#define TRAM_RAM296_REG_OFST           _UINT32_(0x14A0)    /* (TRAM_RAM296) TrustRAM Offset */
#define TRAM_RAM297_REG_OFST           _UINT32_(0x14A4)    /* (TRAM_RAM297) TrustRAM Offset */
#define TRAM_RAM298_REG_OFST           _UINT32_(0x14A8)    /* (TRAM_RAM298) TrustRAM Offset */
#define TRAM_RAM299_REG_OFST           _UINT32_(0x14AC)    /* (TRAM_RAM299) TrustRAM Offset */
#define TRAM_RAM300_REG_OFST           _UINT32_(0x14B0)    /* (TRAM_RAM300) TrustRAM Offset */
#define TRAM_RAM301_REG_OFST           _UINT32_(0x14B4)    /* (TRAM_RAM301) TrustRAM Offset */
#define TRAM_RAM302_REG_OFST           _UINT32_(0x14B8)    /* (TRAM_RAM302) TrustRAM Offset */
#define TRAM_RAM303_REG_OFST           _UINT32_(0x14BC)    /* (TRAM_RAM303) TrustRAM Offset */
#define TRAM_RAM304_REG_OFST           _UINT32_(0x14C0)    /* (TRAM_RAM304) TrustRAM Offset */
#define TRAM_RAM305_REG_OFST           _UINT32_(0x14C4)    /* (TRAM_RAM305) TrustRAM Offset */
#define TRAM_RAM306_REG_OFST           _UINT32_(0x14C8)    /* (TRAM_RAM306) TrustRAM Offset */
#define TRAM_RAM307_REG_OFST           _UINT32_(0x14CC)    /* (TRAM_RAM307) TrustRAM Offset */
#define TRAM_RAM308_REG_OFST           _UINT32_(0x14D0)    /* (TRAM_RAM308) TrustRAM Offset */
#define TRAM_RAM309_REG_OFST           _UINT32_(0x14D4)    /* (TRAM_RAM309) TrustRAM Offset */
#define TRAM_RAM310_REG_OFST           _UINT32_(0x14D8)    /* (TRAM_RAM310) TrustRAM Offset */
#define TRAM_RAM311_REG_OFST           _UINT32_(0x14DC)    /* (TRAM_RAM311) TrustRAM Offset */
#define TRAM_RAM312_REG_OFST           _UINT32_(0x14E0)    /* (TRAM_RAM312) TrustRAM Offset */
#define TRAM_RAM313_REG_OFST           _UINT32_(0x14E4)    /* (TRAM_RAM313) TrustRAM Offset */
#define TRAM_RAM314_REG_OFST           _UINT32_(0x14E8)    /* (TRAM_RAM314) TrustRAM Offset */
#define TRAM_RAM315_REG_OFST           _UINT32_(0x14EC)    /* (TRAM_RAM315) TrustRAM Offset */
#define TRAM_RAM316_REG_OFST           _UINT32_(0x14F0)    /* (TRAM_RAM316) TrustRAM Offset */
#define TRAM_RAM317_REG_OFST           _UINT32_(0x14F4)    /* (TRAM_RAM317) TrustRAM Offset */
#define TRAM_RAM318_REG_OFST           _UINT32_(0x14F8)    /* (TRAM_RAM318) TrustRAM Offset */
#define TRAM_RAM319_REG_OFST           _UINT32_(0x14FC)    /* (TRAM_RAM319) TrustRAM Offset */
#define TRAM_RAM320_REG_OFST           _UINT32_(0x1500)    /* (TRAM_RAM320) TrustRAM Offset */
#define TRAM_RAM321_REG_OFST           _UINT32_(0x1504)    /* (TRAM_RAM321) TrustRAM Offset */
#define TRAM_RAM322_REG_OFST           _UINT32_(0x1508)    /* (TRAM_RAM322) TrustRAM Offset */
#define TRAM_RAM323_REG_OFST           _UINT32_(0x150C)    /* (TRAM_RAM323) TrustRAM Offset */
#define TRAM_RAM324_REG_OFST           _UINT32_(0x1510)    /* (TRAM_RAM324) TrustRAM Offset */
#define TRAM_RAM325_REG_OFST           _UINT32_(0x1514)    /* (TRAM_RAM325) TrustRAM Offset */
#define TRAM_RAM326_REG_OFST           _UINT32_(0x1518)    /* (TRAM_RAM326) TrustRAM Offset */
#define TRAM_RAM327_REG_OFST           _UINT32_(0x151C)    /* (TRAM_RAM327) TrustRAM Offset */
#define TRAM_RAM328_REG_OFST           _UINT32_(0x1520)    /* (TRAM_RAM328) TrustRAM Offset */
#define TRAM_RAM329_REG_OFST           _UINT32_(0x1524)    /* (TRAM_RAM329) TrustRAM Offset */
#define TRAM_RAM330_REG_OFST           _UINT32_(0x1528)    /* (TRAM_RAM330) TrustRAM Offset */
#define TRAM_RAM331_REG_OFST           _UINT32_(0x152C)    /* (TRAM_RAM331) TrustRAM Offset */
#define TRAM_RAM332_REG_OFST           _UINT32_(0x1530)    /* (TRAM_RAM332) TrustRAM Offset */
#define TRAM_RAM333_REG_OFST           _UINT32_(0x1534)    /* (TRAM_RAM333) TrustRAM Offset */
#define TRAM_RAM334_REG_OFST           _UINT32_(0x1538)    /* (TRAM_RAM334) TrustRAM Offset */
#define TRAM_RAM335_REG_OFST           _UINT32_(0x153C)    /* (TRAM_RAM335) TrustRAM Offset */
#define TRAM_RAM336_REG_OFST           _UINT32_(0x1540)    /* (TRAM_RAM336) TrustRAM Offset */
#define TRAM_RAM337_REG_OFST           _UINT32_(0x1544)    /* (TRAM_RAM337) TrustRAM Offset */
#define TRAM_RAM338_REG_OFST           _UINT32_(0x1548)    /* (TRAM_RAM338) TrustRAM Offset */
#define TRAM_RAM339_REG_OFST           _UINT32_(0x154C)    /* (TRAM_RAM339) TrustRAM Offset */
#define TRAM_RAM340_REG_OFST           _UINT32_(0x1550)    /* (TRAM_RAM340) TrustRAM Offset */
#define TRAM_RAM341_REG_OFST           _UINT32_(0x1554)    /* (TRAM_RAM341) TrustRAM Offset */
#define TRAM_RAM342_REG_OFST           _UINT32_(0x1558)    /* (TRAM_RAM342) TrustRAM Offset */
#define TRAM_RAM343_REG_OFST           _UINT32_(0x155C)    /* (TRAM_RAM343) TrustRAM Offset */
#define TRAM_RAM344_REG_OFST           _UINT32_(0x1560)    /* (TRAM_RAM344) TrustRAM Offset */
#define TRAM_RAM345_REG_OFST           _UINT32_(0x1564)    /* (TRAM_RAM345) TrustRAM Offset */
#define TRAM_RAM346_REG_OFST           _UINT32_(0x1568)    /* (TRAM_RAM346) TrustRAM Offset */
#define TRAM_RAM347_REG_OFST           _UINT32_(0x156C)    /* (TRAM_RAM347) TrustRAM Offset */
#define TRAM_RAM348_REG_OFST           _UINT32_(0x1570)    /* (TRAM_RAM348) TrustRAM Offset */
#define TRAM_RAM349_REG_OFST           _UINT32_(0x1574)    /* (TRAM_RAM349) TrustRAM Offset */
#define TRAM_RAM350_REG_OFST           _UINT32_(0x1578)    /* (TRAM_RAM350) TrustRAM Offset */
#define TRAM_RAM351_REG_OFST           _UINT32_(0x157C)    /* (TRAM_RAM351) TrustRAM Offset */
#define TRAM_RAM352_REG_OFST           _UINT32_(0x1580)    /* (TRAM_RAM352) TrustRAM Offset */
#define TRAM_RAM353_REG_OFST           _UINT32_(0x1584)    /* (TRAM_RAM353) TrustRAM Offset */
#define TRAM_RAM354_REG_OFST           _UINT32_(0x1588)    /* (TRAM_RAM354) TrustRAM Offset */
#define TRAM_RAM355_REG_OFST           _UINT32_(0x158C)    /* (TRAM_RAM355) TrustRAM Offset */
#define TRAM_RAM356_REG_OFST           _UINT32_(0x1590)    /* (TRAM_RAM356) TrustRAM Offset */
#define TRAM_RAM357_REG_OFST           _UINT32_(0x1594)    /* (TRAM_RAM357) TrustRAM Offset */
#define TRAM_RAM358_REG_OFST           _UINT32_(0x1598)    /* (TRAM_RAM358) TrustRAM Offset */
#define TRAM_RAM359_REG_OFST           _UINT32_(0x159C)    /* (TRAM_RAM359) TrustRAM Offset */
#define TRAM_RAM360_REG_OFST           _UINT32_(0x15A0)    /* (TRAM_RAM360) TrustRAM Offset */
#define TRAM_RAM361_REG_OFST           _UINT32_(0x15A4)    /* (TRAM_RAM361) TrustRAM Offset */
#define TRAM_RAM362_REG_OFST           _UINT32_(0x15A8)    /* (TRAM_RAM362) TrustRAM Offset */
#define TRAM_RAM363_REG_OFST           _UINT32_(0x15AC)    /* (TRAM_RAM363) TrustRAM Offset */
#define TRAM_RAM364_REG_OFST           _UINT32_(0x15B0)    /* (TRAM_RAM364) TrustRAM Offset */
#define TRAM_RAM365_REG_OFST           _UINT32_(0x15B4)    /* (TRAM_RAM365) TrustRAM Offset */
#define TRAM_RAM366_REG_OFST           _UINT32_(0x15B8)    /* (TRAM_RAM366) TrustRAM Offset */
#define TRAM_RAM367_REG_OFST           _UINT32_(0x15BC)    /* (TRAM_RAM367) TrustRAM Offset */
#define TRAM_RAM368_REG_OFST           _UINT32_(0x15C0)    /* (TRAM_RAM368) TrustRAM Offset */
#define TRAM_RAM369_REG_OFST           _UINT32_(0x15C4)    /* (TRAM_RAM369) TrustRAM Offset */
#define TRAM_RAM370_REG_OFST           _UINT32_(0x15C8)    /* (TRAM_RAM370) TrustRAM Offset */
#define TRAM_RAM371_REG_OFST           _UINT32_(0x15CC)    /* (TRAM_RAM371) TrustRAM Offset */
#define TRAM_RAM372_REG_OFST           _UINT32_(0x15D0)    /* (TRAM_RAM372) TrustRAM Offset */
#define TRAM_RAM373_REG_OFST           _UINT32_(0x15D4)    /* (TRAM_RAM373) TrustRAM Offset */
#define TRAM_RAM374_REG_OFST           _UINT32_(0x15D8)    /* (TRAM_RAM374) TrustRAM Offset */
#define TRAM_RAM375_REG_OFST           _UINT32_(0x15DC)    /* (TRAM_RAM375) TrustRAM Offset */
#define TRAM_RAM376_REG_OFST           _UINT32_(0x15E0)    /* (TRAM_RAM376) TrustRAM Offset */
#define TRAM_RAM377_REG_OFST           _UINT32_(0x15E4)    /* (TRAM_RAM377) TrustRAM Offset */
#define TRAM_RAM378_REG_OFST           _UINT32_(0x15E8)    /* (TRAM_RAM378) TrustRAM Offset */
#define TRAM_RAM379_REG_OFST           _UINT32_(0x15EC)    /* (TRAM_RAM379) TrustRAM Offset */
#define TRAM_RAM380_REG_OFST           _UINT32_(0x15F0)    /* (TRAM_RAM380) TrustRAM Offset */
#define TRAM_RAM381_REG_OFST           _UINT32_(0x15F4)    /* (TRAM_RAM381) TrustRAM Offset */
#define TRAM_RAM382_REG_OFST           _UINT32_(0x15F8)    /* (TRAM_RAM382) TrustRAM Offset */
#define TRAM_RAM383_REG_OFST           _UINT32_(0x15FC)    /* (TRAM_RAM383) TrustRAM Offset */
#define TRAM_RAM384_REG_OFST           _UINT32_(0x1600)    /* (TRAM_RAM384) TrustRAM Offset */
#define TRAM_RAM385_REG_OFST           _UINT32_(0x1604)    /* (TRAM_RAM385) TrustRAM Offset */
#define TRAM_RAM386_REG_OFST           _UINT32_(0x1608)    /* (TRAM_RAM386) TrustRAM Offset */
#define TRAM_RAM387_REG_OFST           _UINT32_(0x160C)    /* (TRAM_RAM387) TrustRAM Offset */
#define TRAM_RAM388_REG_OFST           _UINT32_(0x1610)    /* (TRAM_RAM388) TrustRAM Offset */
#define TRAM_RAM389_REG_OFST           _UINT32_(0x1614)    /* (TRAM_RAM389) TrustRAM Offset */
#define TRAM_RAM390_REG_OFST           _UINT32_(0x1618)    /* (TRAM_RAM390) TrustRAM Offset */
#define TRAM_RAM391_REG_OFST           _UINT32_(0x161C)    /* (TRAM_RAM391) TrustRAM Offset */
#define TRAM_RAM392_REG_OFST           _UINT32_(0x1620)    /* (TRAM_RAM392) TrustRAM Offset */
#define TRAM_RAM393_REG_OFST           _UINT32_(0x1624)    /* (TRAM_RAM393) TrustRAM Offset */
#define TRAM_RAM394_REG_OFST           _UINT32_(0x1628)    /* (TRAM_RAM394) TrustRAM Offset */
#define TRAM_RAM395_REG_OFST           _UINT32_(0x162C)    /* (TRAM_RAM395) TrustRAM Offset */
#define TRAM_RAM396_REG_OFST           _UINT32_(0x1630)    /* (TRAM_RAM396) TrustRAM Offset */
#define TRAM_RAM397_REG_OFST           _UINT32_(0x1634)    /* (TRAM_RAM397) TrustRAM Offset */
#define TRAM_RAM398_REG_OFST           _UINT32_(0x1638)    /* (TRAM_RAM398) TrustRAM Offset */
#define TRAM_RAM399_REG_OFST           _UINT32_(0x163C)    /* (TRAM_RAM399) TrustRAM Offset */
#define TRAM_RAM400_REG_OFST           _UINT32_(0x1640)    /* (TRAM_RAM400) TrustRAM Offset */
#define TRAM_RAM401_REG_OFST           _UINT32_(0x1644)    /* (TRAM_RAM401) TrustRAM Offset */
#define TRAM_RAM402_REG_OFST           _UINT32_(0x1648)    /* (TRAM_RAM402) TrustRAM Offset */
#define TRAM_RAM403_REG_OFST           _UINT32_(0x164C)    /* (TRAM_RAM403) TrustRAM Offset */
#define TRAM_RAM404_REG_OFST           _UINT32_(0x1650)    /* (TRAM_RAM404) TrustRAM Offset */
#define TRAM_RAM405_REG_OFST           _UINT32_(0x1654)    /* (TRAM_RAM405) TrustRAM Offset */
#define TRAM_RAM406_REG_OFST           _UINT32_(0x1658)    /* (TRAM_RAM406) TrustRAM Offset */
#define TRAM_RAM407_REG_OFST           _UINT32_(0x165C)    /* (TRAM_RAM407) TrustRAM Offset */
#define TRAM_RAM408_REG_OFST           _UINT32_(0x1660)    /* (TRAM_RAM408) TrustRAM Offset */
#define TRAM_RAM409_REG_OFST           _UINT32_(0x1664)    /* (TRAM_RAM409) TrustRAM Offset */
#define TRAM_RAM410_REG_OFST           _UINT32_(0x1668)    /* (TRAM_RAM410) TrustRAM Offset */
#define TRAM_RAM411_REG_OFST           _UINT32_(0x166C)    /* (TRAM_RAM411) TrustRAM Offset */
#define TRAM_RAM412_REG_OFST           _UINT32_(0x1670)    /* (TRAM_RAM412) TrustRAM Offset */
#define TRAM_RAM413_REG_OFST           _UINT32_(0x1674)    /* (TRAM_RAM413) TrustRAM Offset */
#define TRAM_RAM414_REG_OFST           _UINT32_(0x1678)    /* (TRAM_RAM414) TrustRAM Offset */
#define TRAM_RAM415_REG_OFST           _UINT32_(0x167C)    /* (TRAM_RAM415) TrustRAM Offset */
#define TRAM_RAM416_REG_OFST           _UINT32_(0x1680)    /* (TRAM_RAM416) TrustRAM Offset */
#define TRAM_RAM417_REG_OFST           _UINT32_(0x1684)    /* (TRAM_RAM417) TrustRAM Offset */
#define TRAM_RAM418_REG_OFST           _UINT32_(0x1688)    /* (TRAM_RAM418) TrustRAM Offset */
#define TRAM_RAM419_REG_OFST           _UINT32_(0x168C)    /* (TRAM_RAM419) TrustRAM Offset */
#define TRAM_RAM420_REG_OFST           _UINT32_(0x1690)    /* (TRAM_RAM420) TrustRAM Offset */
#define TRAM_RAM421_REG_OFST           _UINT32_(0x1694)    /* (TRAM_RAM421) TrustRAM Offset */
#define TRAM_RAM422_REG_OFST           _UINT32_(0x1698)    /* (TRAM_RAM422) TrustRAM Offset */
#define TRAM_RAM423_REG_OFST           _UINT32_(0x169C)    /* (TRAM_RAM423) TrustRAM Offset */
#define TRAM_RAM424_REG_OFST           _UINT32_(0x16A0)    /* (TRAM_RAM424) TrustRAM Offset */
#define TRAM_RAM425_REG_OFST           _UINT32_(0x16A4)    /* (TRAM_RAM425) TrustRAM Offset */
#define TRAM_RAM426_REG_OFST           _UINT32_(0x16A8)    /* (TRAM_RAM426) TrustRAM Offset */
#define TRAM_RAM427_REG_OFST           _UINT32_(0x16AC)    /* (TRAM_RAM427) TrustRAM Offset */
#define TRAM_RAM428_REG_OFST           _UINT32_(0x16B0)    /* (TRAM_RAM428) TrustRAM Offset */
#define TRAM_RAM429_REG_OFST           _UINT32_(0x16B4)    /* (TRAM_RAM429) TrustRAM Offset */
#define TRAM_RAM430_REG_OFST           _UINT32_(0x16B8)    /* (TRAM_RAM430) TrustRAM Offset */
#define TRAM_RAM431_REG_OFST           _UINT32_(0x16BC)    /* (TRAM_RAM431) TrustRAM Offset */
#define TRAM_RAM432_REG_OFST           _UINT32_(0x16C0)    /* (TRAM_RAM432) TrustRAM Offset */
#define TRAM_RAM433_REG_OFST           _UINT32_(0x16C4)    /* (TRAM_RAM433) TrustRAM Offset */
#define TRAM_RAM434_REG_OFST           _UINT32_(0x16C8)    /* (TRAM_RAM434) TrustRAM Offset */
#define TRAM_RAM435_REG_OFST           _UINT32_(0x16CC)    /* (TRAM_RAM435) TrustRAM Offset */
#define TRAM_RAM436_REG_OFST           _UINT32_(0x16D0)    /* (TRAM_RAM436) TrustRAM Offset */
#define TRAM_RAM437_REG_OFST           _UINT32_(0x16D4)    /* (TRAM_RAM437) TrustRAM Offset */
#define TRAM_RAM438_REG_OFST           _UINT32_(0x16D8)    /* (TRAM_RAM438) TrustRAM Offset */
#define TRAM_RAM439_REG_OFST           _UINT32_(0x16DC)    /* (TRAM_RAM439) TrustRAM Offset */
#define TRAM_RAM440_REG_OFST           _UINT32_(0x16E0)    /* (TRAM_RAM440) TrustRAM Offset */
#define TRAM_RAM441_REG_OFST           _UINT32_(0x16E4)    /* (TRAM_RAM441) TrustRAM Offset */
#define TRAM_RAM442_REG_OFST           _UINT32_(0x16E8)    /* (TRAM_RAM442) TrustRAM Offset */
#define TRAM_RAM443_REG_OFST           _UINT32_(0x16EC)    /* (TRAM_RAM443) TrustRAM Offset */
#define TRAM_RAM444_REG_OFST           _UINT32_(0x16F0)    /* (TRAM_RAM444) TrustRAM Offset */
#define TRAM_RAM445_REG_OFST           _UINT32_(0x16F4)    /* (TRAM_RAM445) TrustRAM Offset */
#define TRAM_RAM446_REG_OFST           _UINT32_(0x16F8)    /* (TRAM_RAM446) TrustRAM Offset */
#define TRAM_RAM447_REG_OFST           _UINT32_(0x16FC)    /* (TRAM_RAM447) TrustRAM Offset */
#define TRAM_RAM448_REG_OFST           _UINT32_(0x1700)    /* (TRAM_RAM448) TrustRAM Offset */
#define TRAM_RAM449_REG_OFST           _UINT32_(0x1704)    /* (TRAM_RAM449) TrustRAM Offset */
#define TRAM_RAM450_REG_OFST           _UINT32_(0x1708)    /* (TRAM_RAM450) TrustRAM Offset */
#define TRAM_RAM451_REG_OFST           _UINT32_(0x170C)    /* (TRAM_RAM451) TrustRAM Offset */
#define TRAM_RAM452_REG_OFST           _UINT32_(0x1710)    /* (TRAM_RAM452) TrustRAM Offset */
#define TRAM_RAM453_REG_OFST           _UINT32_(0x1714)    /* (TRAM_RAM453) TrustRAM Offset */
#define TRAM_RAM454_REG_OFST           _UINT32_(0x1718)    /* (TRAM_RAM454) TrustRAM Offset */
#define TRAM_RAM455_REG_OFST           _UINT32_(0x171C)    /* (TRAM_RAM455) TrustRAM Offset */
#define TRAM_RAM456_REG_OFST           _UINT32_(0x1720)    /* (TRAM_RAM456) TrustRAM Offset */
#define TRAM_RAM457_REG_OFST           _UINT32_(0x1724)    /* (TRAM_RAM457) TrustRAM Offset */
#define TRAM_RAM458_REG_OFST           _UINT32_(0x1728)    /* (TRAM_RAM458) TrustRAM Offset */
#define TRAM_RAM459_REG_OFST           _UINT32_(0x172C)    /* (TRAM_RAM459) TrustRAM Offset */
#define TRAM_RAM460_REG_OFST           _UINT32_(0x1730)    /* (TRAM_RAM460) TrustRAM Offset */
#define TRAM_RAM461_REG_OFST           _UINT32_(0x1734)    /* (TRAM_RAM461) TrustRAM Offset */
#define TRAM_RAM462_REG_OFST           _UINT32_(0x1738)    /* (TRAM_RAM462) TrustRAM Offset */
#define TRAM_RAM463_REG_OFST           _UINT32_(0x173C)    /* (TRAM_RAM463) TrustRAM Offset */
#define TRAM_RAM464_REG_OFST           _UINT32_(0x1740)    /* (TRAM_RAM464) TrustRAM Offset */
#define TRAM_RAM465_REG_OFST           _UINT32_(0x1744)    /* (TRAM_RAM465) TrustRAM Offset */
#define TRAM_RAM466_REG_OFST           _UINT32_(0x1748)    /* (TRAM_RAM466) TrustRAM Offset */
#define TRAM_RAM467_REG_OFST           _UINT32_(0x174C)    /* (TRAM_RAM467) TrustRAM Offset */
#define TRAM_RAM468_REG_OFST           _UINT32_(0x1750)    /* (TRAM_RAM468) TrustRAM Offset */
#define TRAM_RAM469_REG_OFST           _UINT32_(0x1754)    /* (TRAM_RAM469) TrustRAM Offset */
#define TRAM_RAM470_REG_OFST           _UINT32_(0x1758)    /* (TRAM_RAM470) TrustRAM Offset */
#define TRAM_RAM471_REG_OFST           _UINT32_(0x175C)    /* (TRAM_RAM471) TrustRAM Offset */
#define TRAM_RAM472_REG_OFST           _UINT32_(0x1760)    /* (TRAM_RAM472) TrustRAM Offset */
#define TRAM_RAM473_REG_OFST           _UINT32_(0x1764)    /* (TRAM_RAM473) TrustRAM Offset */
#define TRAM_RAM474_REG_OFST           _UINT32_(0x1768)    /* (TRAM_RAM474) TrustRAM Offset */
#define TRAM_RAM475_REG_OFST           _UINT32_(0x176C)    /* (TRAM_RAM475) TrustRAM Offset */
#define TRAM_RAM476_REG_OFST           _UINT32_(0x1770)    /* (TRAM_RAM476) TrustRAM Offset */
#define TRAM_RAM477_REG_OFST           _UINT32_(0x1774)    /* (TRAM_RAM477) TrustRAM Offset */
#define TRAM_RAM478_REG_OFST           _UINT32_(0x1778)    /* (TRAM_RAM478) TrustRAM Offset */
#define TRAM_RAM479_REG_OFST           _UINT32_(0x177C)    /* (TRAM_RAM479) TrustRAM Offset */
#define TRAM_RAM480_REG_OFST           _UINT32_(0x1780)    /* (TRAM_RAM480) TrustRAM Offset */
#define TRAM_RAM481_REG_OFST           _UINT32_(0x1784)    /* (TRAM_RAM481) TrustRAM Offset */
#define TRAM_RAM482_REG_OFST           _UINT32_(0x1788)    /* (TRAM_RAM482) TrustRAM Offset */
#define TRAM_RAM483_REG_OFST           _UINT32_(0x178C)    /* (TRAM_RAM483) TrustRAM Offset */
#define TRAM_RAM484_REG_OFST           _UINT32_(0x1790)    /* (TRAM_RAM484) TrustRAM Offset */
#define TRAM_RAM485_REG_OFST           _UINT32_(0x1794)    /* (TRAM_RAM485) TrustRAM Offset */
#define TRAM_RAM486_REG_OFST           _UINT32_(0x1798)    /* (TRAM_RAM486) TrustRAM Offset */
#define TRAM_RAM487_REG_OFST           _UINT32_(0x179C)    /* (TRAM_RAM487) TrustRAM Offset */
#define TRAM_RAM488_REG_OFST           _UINT32_(0x17A0)    /* (TRAM_RAM488) TrustRAM Offset */
#define TRAM_RAM489_REG_OFST           _UINT32_(0x17A4)    /* (TRAM_RAM489) TrustRAM Offset */
#define TRAM_RAM490_REG_OFST           _UINT32_(0x17A8)    /* (TRAM_RAM490) TrustRAM Offset */
#define TRAM_RAM491_REG_OFST           _UINT32_(0x17AC)    /* (TRAM_RAM491) TrustRAM Offset */
#define TRAM_RAM492_REG_OFST           _UINT32_(0x17B0)    /* (TRAM_RAM492) TrustRAM Offset */
#define TRAM_RAM493_REG_OFST           _UINT32_(0x17B4)    /* (TRAM_RAM493) TrustRAM Offset */
#define TRAM_RAM494_REG_OFST           _UINT32_(0x17B8)    /* (TRAM_RAM494) TrustRAM Offset */
#define TRAM_RAM495_REG_OFST           _UINT32_(0x17BC)    /* (TRAM_RAM495) TrustRAM Offset */
#define TRAM_RAM496_REG_OFST           _UINT32_(0x17C0)    /* (TRAM_RAM496) TrustRAM Offset */
#define TRAM_RAM497_REG_OFST           _UINT32_(0x17C4)    /* (TRAM_RAM497) TrustRAM Offset */
#define TRAM_RAM498_REG_OFST           _UINT32_(0x17C8)    /* (TRAM_RAM498) TrustRAM Offset */
#define TRAM_RAM499_REG_OFST           _UINT32_(0x17CC)    /* (TRAM_RAM499) TrustRAM Offset */
#define TRAM_RAM500_REG_OFST           _UINT32_(0x17D0)    /* (TRAM_RAM500) TrustRAM Offset */
#define TRAM_RAM501_REG_OFST           _UINT32_(0x17D4)    /* (TRAM_RAM501) TrustRAM Offset */
#define TRAM_RAM502_REG_OFST           _UINT32_(0x17D8)    /* (TRAM_RAM502) TrustRAM Offset */
#define TRAM_RAM503_REG_OFST           _UINT32_(0x17DC)    /* (TRAM_RAM503) TrustRAM Offset */
#define TRAM_RAM504_REG_OFST           _UINT32_(0x17E0)    /* (TRAM_RAM504) TrustRAM Offset */
#define TRAM_RAM505_REG_OFST           _UINT32_(0x17E4)    /* (TRAM_RAM505) TrustRAM Offset */
#define TRAM_RAM506_REG_OFST           _UINT32_(0x17E8)    /* (TRAM_RAM506) TrustRAM Offset */
#define TRAM_RAM507_REG_OFST           _UINT32_(0x17EC)    /* (TRAM_RAM507) TrustRAM Offset */
#define TRAM_RAM508_REG_OFST           _UINT32_(0x17F0)    /* (TRAM_RAM508) TrustRAM Offset */
#define TRAM_RAM509_REG_OFST           _UINT32_(0x17F4)    /* (TRAM_RAM509) TrustRAM Offset */
#define TRAM_RAM510_REG_OFST           _UINT32_(0x17F8)    /* (TRAM_RAM510) TrustRAM Offset */
#define TRAM_RAM511_REG_OFST           _UINT32_(0x17FC)    /* (TRAM_RAM511) TrustRAM Offset */
#define TRAM_RAM512_REG_OFST           _UINT32_(0x1800)    /* (TRAM_RAM512) TrustRAM Offset */
#define TRAM_RAM513_REG_OFST           _UINT32_(0x1804)    /* (TRAM_RAM513) TrustRAM Offset */
#define TRAM_RAM514_REG_OFST           _UINT32_(0x1808)    /* (TRAM_RAM514) TrustRAM Offset */
#define TRAM_RAM515_REG_OFST           _UINT32_(0x180C)    /* (TRAM_RAM515) TrustRAM Offset */
#define TRAM_RAM516_REG_OFST           _UINT32_(0x1810)    /* (TRAM_RAM516) TrustRAM Offset */
#define TRAM_RAM517_REG_OFST           _UINT32_(0x1814)    /* (TRAM_RAM517) TrustRAM Offset */
#define TRAM_RAM518_REG_OFST           _UINT32_(0x1818)    /* (TRAM_RAM518) TrustRAM Offset */
#define TRAM_RAM519_REG_OFST           _UINT32_(0x181C)    /* (TRAM_RAM519) TrustRAM Offset */
#define TRAM_RAM520_REG_OFST           _UINT32_(0x1820)    /* (TRAM_RAM520) TrustRAM Offset */
#define TRAM_RAM521_REG_OFST           _UINT32_(0x1824)    /* (TRAM_RAM521) TrustRAM Offset */
#define TRAM_RAM522_REG_OFST           _UINT32_(0x1828)    /* (TRAM_RAM522) TrustRAM Offset */
#define TRAM_RAM523_REG_OFST           _UINT32_(0x182C)    /* (TRAM_RAM523) TrustRAM Offset */
#define TRAM_RAM524_REG_OFST           _UINT32_(0x1830)    /* (TRAM_RAM524) TrustRAM Offset */
#define TRAM_RAM525_REG_OFST           _UINT32_(0x1834)    /* (TRAM_RAM525) TrustRAM Offset */
#define TRAM_RAM526_REG_OFST           _UINT32_(0x1838)    /* (TRAM_RAM526) TrustRAM Offset */
#define TRAM_RAM527_REG_OFST           _UINT32_(0x183C)    /* (TRAM_RAM527) TrustRAM Offset */
#define TRAM_RAM528_REG_OFST           _UINT32_(0x1840)    /* (TRAM_RAM528) TrustRAM Offset */
#define TRAM_RAM529_REG_OFST           _UINT32_(0x1844)    /* (TRAM_RAM529) TrustRAM Offset */
#define TRAM_RAM530_REG_OFST           _UINT32_(0x1848)    /* (TRAM_RAM530) TrustRAM Offset */
#define TRAM_RAM531_REG_OFST           _UINT32_(0x184C)    /* (TRAM_RAM531) TrustRAM Offset */
#define TRAM_RAM532_REG_OFST           _UINT32_(0x1850)    /* (TRAM_RAM532) TrustRAM Offset */
#define TRAM_RAM533_REG_OFST           _UINT32_(0x1854)    /* (TRAM_RAM533) TrustRAM Offset */
#define TRAM_RAM534_REG_OFST           _UINT32_(0x1858)    /* (TRAM_RAM534) TrustRAM Offset */
#define TRAM_RAM535_REG_OFST           _UINT32_(0x185C)    /* (TRAM_RAM535) TrustRAM Offset */
#define TRAM_RAM536_REG_OFST           _UINT32_(0x1860)    /* (TRAM_RAM536) TrustRAM Offset */
#define TRAM_RAM537_REG_OFST           _UINT32_(0x1864)    /* (TRAM_RAM537) TrustRAM Offset */
#define TRAM_RAM538_REG_OFST           _UINT32_(0x1868)    /* (TRAM_RAM538) TrustRAM Offset */
#define TRAM_RAM539_REG_OFST           _UINT32_(0x186C)    /* (TRAM_RAM539) TrustRAM Offset */
#define TRAM_RAM540_REG_OFST           _UINT32_(0x1870)    /* (TRAM_RAM540) TrustRAM Offset */
#define TRAM_RAM541_REG_OFST           _UINT32_(0x1874)    /* (TRAM_RAM541) TrustRAM Offset */
#define TRAM_RAM542_REG_OFST           _UINT32_(0x1878)    /* (TRAM_RAM542) TrustRAM Offset */
#define TRAM_RAM543_REG_OFST           _UINT32_(0x187C)    /* (TRAM_RAM543) TrustRAM Offset */
#define TRAM_RAM544_REG_OFST           _UINT32_(0x1880)    /* (TRAM_RAM544) TrustRAM Offset */
#define TRAM_RAM545_REG_OFST           _UINT32_(0x1884)    /* (TRAM_RAM545) TrustRAM Offset */
#define TRAM_RAM546_REG_OFST           _UINT32_(0x1888)    /* (TRAM_RAM546) TrustRAM Offset */
#define TRAM_RAM547_REG_OFST           _UINT32_(0x188C)    /* (TRAM_RAM547) TrustRAM Offset */
#define TRAM_RAM548_REG_OFST           _UINT32_(0x1890)    /* (TRAM_RAM548) TrustRAM Offset */
#define TRAM_RAM549_REG_OFST           _UINT32_(0x1894)    /* (TRAM_RAM549) TrustRAM Offset */
#define TRAM_RAM550_REG_OFST           _UINT32_(0x1898)    /* (TRAM_RAM550) TrustRAM Offset */
#define TRAM_RAM551_REG_OFST           _UINT32_(0x189C)    /* (TRAM_RAM551) TrustRAM Offset */
#define TRAM_RAM552_REG_OFST           _UINT32_(0x18A0)    /* (TRAM_RAM552) TrustRAM Offset */
#define TRAM_RAM553_REG_OFST           _UINT32_(0x18A4)    /* (TRAM_RAM553) TrustRAM Offset */
#define TRAM_RAM554_REG_OFST           _UINT32_(0x18A8)    /* (TRAM_RAM554) TrustRAM Offset */
#define TRAM_RAM555_REG_OFST           _UINT32_(0x18AC)    /* (TRAM_RAM555) TrustRAM Offset */
#define TRAM_RAM556_REG_OFST           _UINT32_(0x18B0)    /* (TRAM_RAM556) TrustRAM Offset */
#define TRAM_RAM557_REG_OFST           _UINT32_(0x18B4)    /* (TRAM_RAM557) TrustRAM Offset */
#define TRAM_RAM558_REG_OFST           _UINT32_(0x18B8)    /* (TRAM_RAM558) TrustRAM Offset */
#define TRAM_RAM559_REG_OFST           _UINT32_(0x18BC)    /* (TRAM_RAM559) TrustRAM Offset */
#define TRAM_RAM560_REG_OFST           _UINT32_(0x18C0)    /* (TRAM_RAM560) TrustRAM Offset */
#define TRAM_RAM561_REG_OFST           _UINT32_(0x18C4)    /* (TRAM_RAM561) TrustRAM Offset */
#define TRAM_RAM562_REG_OFST           _UINT32_(0x18C8)    /* (TRAM_RAM562) TrustRAM Offset */
#define TRAM_RAM563_REG_OFST           _UINT32_(0x18CC)    /* (TRAM_RAM563) TrustRAM Offset */
#define TRAM_RAM564_REG_OFST           _UINT32_(0x18D0)    /* (TRAM_RAM564) TrustRAM Offset */
#define TRAM_RAM565_REG_OFST           _UINT32_(0x18D4)    /* (TRAM_RAM565) TrustRAM Offset */
#define TRAM_RAM566_REG_OFST           _UINT32_(0x18D8)    /* (TRAM_RAM566) TrustRAM Offset */
#define TRAM_RAM567_REG_OFST           _UINT32_(0x18DC)    /* (TRAM_RAM567) TrustRAM Offset */
#define TRAM_RAM568_REG_OFST           _UINT32_(0x18E0)    /* (TRAM_RAM568) TrustRAM Offset */
#define TRAM_RAM569_REG_OFST           _UINT32_(0x18E4)    /* (TRAM_RAM569) TrustRAM Offset */
#define TRAM_RAM570_REG_OFST           _UINT32_(0x18E8)    /* (TRAM_RAM570) TrustRAM Offset */
#define TRAM_RAM571_REG_OFST           _UINT32_(0x18EC)    /* (TRAM_RAM571) TrustRAM Offset */
#define TRAM_RAM572_REG_OFST           _UINT32_(0x18F0)    /* (TRAM_RAM572) TrustRAM Offset */
#define TRAM_RAM573_REG_OFST           _UINT32_(0x18F4)    /* (TRAM_RAM573) TrustRAM Offset */
#define TRAM_RAM574_REG_OFST           _UINT32_(0x18F8)    /* (TRAM_RAM574) TrustRAM Offset */
#define TRAM_RAM575_REG_OFST           _UINT32_(0x18FC)    /* (TRAM_RAM575) TrustRAM Offset */
#define TRAM_RAM576_REG_OFST           _UINT32_(0x1900)    /* (TRAM_RAM576) TrustRAM Offset */
#define TRAM_RAM577_REG_OFST           _UINT32_(0x1904)    /* (TRAM_RAM577) TrustRAM Offset */
#define TRAM_RAM578_REG_OFST           _UINT32_(0x1908)    /* (TRAM_RAM578) TrustRAM Offset */
#define TRAM_RAM579_REG_OFST           _UINT32_(0x190C)    /* (TRAM_RAM579) TrustRAM Offset */
#define TRAM_RAM580_REG_OFST           _UINT32_(0x1910)    /* (TRAM_RAM580) TrustRAM Offset */
#define TRAM_RAM581_REG_OFST           _UINT32_(0x1914)    /* (TRAM_RAM581) TrustRAM Offset */
#define TRAM_RAM582_REG_OFST           _UINT32_(0x1918)    /* (TRAM_RAM582) TrustRAM Offset */
#define TRAM_RAM583_REG_OFST           _UINT32_(0x191C)    /* (TRAM_RAM583) TrustRAM Offset */
#define TRAM_RAM584_REG_OFST           _UINT32_(0x1920)    /* (TRAM_RAM584) TrustRAM Offset */
#define TRAM_RAM585_REG_OFST           _UINT32_(0x1924)    /* (TRAM_RAM585) TrustRAM Offset */
#define TRAM_RAM586_REG_OFST           _UINT32_(0x1928)    /* (TRAM_RAM586) TrustRAM Offset */
#define TRAM_RAM587_REG_OFST           _UINT32_(0x192C)    /* (TRAM_RAM587) TrustRAM Offset */
#define TRAM_RAM588_REG_OFST           _UINT32_(0x1930)    /* (TRAM_RAM588) TrustRAM Offset */
#define TRAM_RAM589_REG_OFST           _UINT32_(0x1934)    /* (TRAM_RAM589) TrustRAM Offset */
#define TRAM_RAM590_REG_OFST           _UINT32_(0x1938)    /* (TRAM_RAM590) TrustRAM Offset */
#define TRAM_RAM591_REG_OFST           _UINT32_(0x193C)    /* (TRAM_RAM591) TrustRAM Offset */
#define TRAM_RAM592_REG_OFST           _UINT32_(0x1940)    /* (TRAM_RAM592) TrustRAM Offset */
#define TRAM_RAM593_REG_OFST           _UINT32_(0x1944)    /* (TRAM_RAM593) TrustRAM Offset */
#define TRAM_RAM594_REG_OFST           _UINT32_(0x1948)    /* (TRAM_RAM594) TrustRAM Offset */
#define TRAM_RAM595_REG_OFST           _UINT32_(0x194C)    /* (TRAM_RAM595) TrustRAM Offset */
#define TRAM_RAM596_REG_OFST           _UINT32_(0x1950)    /* (TRAM_RAM596) TrustRAM Offset */
#define TRAM_RAM597_REG_OFST           _UINT32_(0x1954)    /* (TRAM_RAM597) TrustRAM Offset */
#define TRAM_RAM598_REG_OFST           _UINT32_(0x1958)    /* (TRAM_RAM598) TrustRAM Offset */
#define TRAM_RAM599_REG_OFST           _UINT32_(0x195C)    /* (TRAM_RAM599) TrustRAM Offset */
#define TRAM_RAM600_REG_OFST           _UINT32_(0x1960)    /* (TRAM_RAM600) TrustRAM Offset */
#define TRAM_RAM601_REG_OFST           _UINT32_(0x1964)    /* (TRAM_RAM601) TrustRAM Offset */
#define TRAM_RAM602_REG_OFST           _UINT32_(0x1968)    /* (TRAM_RAM602) TrustRAM Offset */
#define TRAM_RAM603_REG_OFST           _UINT32_(0x196C)    /* (TRAM_RAM603) TrustRAM Offset */
#define TRAM_RAM604_REG_OFST           _UINT32_(0x1970)    /* (TRAM_RAM604) TrustRAM Offset */
#define TRAM_RAM605_REG_OFST           _UINT32_(0x1974)    /* (TRAM_RAM605) TrustRAM Offset */
#define TRAM_RAM606_REG_OFST           _UINT32_(0x1978)    /* (TRAM_RAM606) TrustRAM Offset */
#define TRAM_RAM607_REG_OFST           _UINT32_(0x197C)    /* (TRAM_RAM607) TrustRAM Offset */
#define TRAM_RAM608_REG_OFST           _UINT32_(0x1980)    /* (TRAM_RAM608) TrustRAM Offset */
#define TRAM_RAM609_REG_OFST           _UINT32_(0x1984)    /* (TRAM_RAM609) TrustRAM Offset */
#define TRAM_RAM610_REG_OFST           _UINT32_(0x1988)    /* (TRAM_RAM610) TrustRAM Offset */
#define TRAM_RAM611_REG_OFST           _UINT32_(0x198C)    /* (TRAM_RAM611) TrustRAM Offset */
#define TRAM_RAM612_REG_OFST           _UINT32_(0x1990)    /* (TRAM_RAM612) TrustRAM Offset */
#define TRAM_RAM613_REG_OFST           _UINT32_(0x1994)    /* (TRAM_RAM613) TrustRAM Offset */
#define TRAM_RAM614_REG_OFST           _UINT32_(0x1998)    /* (TRAM_RAM614) TrustRAM Offset */
#define TRAM_RAM615_REG_OFST           _UINT32_(0x199C)    /* (TRAM_RAM615) TrustRAM Offset */
#define TRAM_RAM616_REG_OFST           _UINT32_(0x19A0)    /* (TRAM_RAM616) TrustRAM Offset */
#define TRAM_RAM617_REG_OFST           _UINT32_(0x19A4)    /* (TRAM_RAM617) TrustRAM Offset */
#define TRAM_RAM618_REG_OFST           _UINT32_(0x19A8)    /* (TRAM_RAM618) TrustRAM Offset */
#define TRAM_RAM619_REG_OFST           _UINT32_(0x19AC)    /* (TRAM_RAM619) TrustRAM Offset */
#define TRAM_RAM620_REG_OFST           _UINT32_(0x19B0)    /* (TRAM_RAM620) TrustRAM Offset */
#define TRAM_RAM621_REG_OFST           _UINT32_(0x19B4)    /* (TRAM_RAM621) TrustRAM Offset */
#define TRAM_RAM622_REG_OFST           _UINT32_(0x19B8)    /* (TRAM_RAM622) TrustRAM Offset */
#define TRAM_RAM623_REG_OFST           _UINT32_(0x19BC)    /* (TRAM_RAM623) TrustRAM Offset */
#define TRAM_RAM624_REG_OFST           _UINT32_(0x19C0)    /* (TRAM_RAM624) TrustRAM Offset */
#define TRAM_RAM625_REG_OFST           _UINT32_(0x19C4)    /* (TRAM_RAM625) TrustRAM Offset */
#define TRAM_RAM626_REG_OFST           _UINT32_(0x19C8)    /* (TRAM_RAM626) TrustRAM Offset */
#define TRAM_RAM627_REG_OFST           _UINT32_(0x19CC)    /* (TRAM_RAM627) TrustRAM Offset */
#define TRAM_RAM628_REG_OFST           _UINT32_(0x19D0)    /* (TRAM_RAM628) TrustRAM Offset */
#define TRAM_RAM629_REG_OFST           _UINT32_(0x19D4)    /* (TRAM_RAM629) TrustRAM Offset */
#define TRAM_RAM630_REG_OFST           _UINT32_(0x19D8)    /* (TRAM_RAM630) TrustRAM Offset */
#define TRAM_RAM631_REG_OFST           _UINT32_(0x19DC)    /* (TRAM_RAM631) TrustRAM Offset */
#define TRAM_RAM632_REG_OFST           _UINT32_(0x19E0)    /* (TRAM_RAM632) TrustRAM Offset */
#define TRAM_RAM633_REG_OFST           _UINT32_(0x19E4)    /* (TRAM_RAM633) TrustRAM Offset */
#define TRAM_RAM634_REG_OFST           _UINT32_(0x19E8)    /* (TRAM_RAM634) TrustRAM Offset */
#define TRAM_RAM635_REG_OFST           _UINT32_(0x19EC)    /* (TRAM_RAM635) TrustRAM Offset */
#define TRAM_RAM636_REG_OFST           _UINT32_(0x19F0)    /* (TRAM_RAM636) TrustRAM Offset */
#define TRAM_RAM637_REG_OFST           _UINT32_(0x19F4)    /* (TRAM_RAM637) TrustRAM Offset */
#define TRAM_RAM638_REG_OFST           _UINT32_(0x19F8)    /* (TRAM_RAM638) TrustRAM Offset */
#define TRAM_RAM639_REG_OFST           _UINT32_(0x19FC)    /* (TRAM_RAM639) TrustRAM Offset */
#define TRAM_RAM640_REG_OFST           _UINT32_(0x1A00)    /* (TRAM_RAM640) TrustRAM Offset */
#define TRAM_RAM641_REG_OFST           _UINT32_(0x1A04)    /* (TRAM_RAM641) TrustRAM Offset */
#define TRAM_RAM642_REG_OFST           _UINT32_(0x1A08)    /* (TRAM_RAM642) TrustRAM Offset */
#define TRAM_RAM643_REG_OFST           _UINT32_(0x1A0C)    /* (TRAM_RAM643) TrustRAM Offset */
#define TRAM_RAM644_REG_OFST           _UINT32_(0x1A10)    /* (TRAM_RAM644) TrustRAM Offset */
#define TRAM_RAM645_REG_OFST           _UINT32_(0x1A14)    /* (TRAM_RAM645) TrustRAM Offset */
#define TRAM_RAM646_REG_OFST           _UINT32_(0x1A18)    /* (TRAM_RAM646) TrustRAM Offset */
#define TRAM_RAM647_REG_OFST           _UINT32_(0x1A1C)    /* (TRAM_RAM647) TrustRAM Offset */
#define TRAM_RAM648_REG_OFST           _UINT32_(0x1A20)    /* (TRAM_RAM648) TrustRAM Offset */
#define TRAM_RAM649_REG_OFST           _UINT32_(0x1A24)    /* (TRAM_RAM649) TrustRAM Offset */
#define TRAM_RAM650_REG_OFST           _UINT32_(0x1A28)    /* (TRAM_RAM650) TrustRAM Offset */
#define TRAM_RAM651_REG_OFST           _UINT32_(0x1A2C)    /* (TRAM_RAM651) TrustRAM Offset */
#define TRAM_RAM652_REG_OFST           _UINT32_(0x1A30)    /* (TRAM_RAM652) TrustRAM Offset */
#define TRAM_RAM653_REG_OFST           _UINT32_(0x1A34)    /* (TRAM_RAM653) TrustRAM Offset */
#define TRAM_RAM654_REG_OFST           _UINT32_(0x1A38)    /* (TRAM_RAM654) TrustRAM Offset */
#define TRAM_RAM655_REG_OFST           _UINT32_(0x1A3C)    /* (TRAM_RAM655) TrustRAM Offset */
#define TRAM_RAM656_REG_OFST           _UINT32_(0x1A40)    /* (TRAM_RAM656) TrustRAM Offset */
#define TRAM_RAM657_REG_OFST           _UINT32_(0x1A44)    /* (TRAM_RAM657) TrustRAM Offset */
#define TRAM_RAM658_REG_OFST           _UINT32_(0x1A48)    /* (TRAM_RAM658) TrustRAM Offset */
#define TRAM_RAM659_REG_OFST           _UINT32_(0x1A4C)    /* (TRAM_RAM659) TrustRAM Offset */
#define TRAM_RAM660_REG_OFST           _UINT32_(0x1A50)    /* (TRAM_RAM660) TrustRAM Offset */
#define TRAM_RAM661_REG_OFST           _UINT32_(0x1A54)    /* (TRAM_RAM661) TrustRAM Offset */
#define TRAM_RAM662_REG_OFST           _UINT32_(0x1A58)    /* (TRAM_RAM662) TrustRAM Offset */
#define TRAM_RAM663_REG_OFST           _UINT32_(0x1A5C)    /* (TRAM_RAM663) TrustRAM Offset */
#define TRAM_RAM664_REG_OFST           _UINT32_(0x1A60)    /* (TRAM_RAM664) TrustRAM Offset */
#define TRAM_RAM665_REG_OFST           _UINT32_(0x1A64)    /* (TRAM_RAM665) TrustRAM Offset */
#define TRAM_RAM666_REG_OFST           _UINT32_(0x1A68)    /* (TRAM_RAM666) TrustRAM Offset */
#define TRAM_RAM667_REG_OFST           _UINT32_(0x1A6C)    /* (TRAM_RAM667) TrustRAM Offset */
#define TRAM_RAM668_REG_OFST           _UINT32_(0x1A70)    /* (TRAM_RAM668) TrustRAM Offset */
#define TRAM_RAM669_REG_OFST           _UINT32_(0x1A74)    /* (TRAM_RAM669) TrustRAM Offset */
#define TRAM_RAM670_REG_OFST           _UINT32_(0x1A78)    /* (TRAM_RAM670) TrustRAM Offset */
#define TRAM_RAM671_REG_OFST           _UINT32_(0x1A7C)    /* (TRAM_RAM671) TrustRAM Offset */
#define TRAM_RAM672_REG_OFST           _UINT32_(0x1A80)    /* (TRAM_RAM672) TrustRAM Offset */
#define TRAM_RAM673_REG_OFST           _UINT32_(0x1A84)    /* (TRAM_RAM673) TrustRAM Offset */
#define TRAM_RAM674_REG_OFST           _UINT32_(0x1A88)    /* (TRAM_RAM674) TrustRAM Offset */
#define TRAM_RAM675_REG_OFST           _UINT32_(0x1A8C)    /* (TRAM_RAM675) TrustRAM Offset */
#define TRAM_RAM676_REG_OFST           _UINT32_(0x1A90)    /* (TRAM_RAM676) TrustRAM Offset */
#define TRAM_RAM677_REG_OFST           _UINT32_(0x1A94)    /* (TRAM_RAM677) TrustRAM Offset */
#define TRAM_RAM678_REG_OFST           _UINT32_(0x1A98)    /* (TRAM_RAM678) TrustRAM Offset */
#define TRAM_RAM679_REG_OFST           _UINT32_(0x1A9C)    /* (TRAM_RAM679) TrustRAM Offset */
#define TRAM_RAM680_REG_OFST           _UINT32_(0x1AA0)    /* (TRAM_RAM680) TrustRAM Offset */
#define TRAM_RAM681_REG_OFST           _UINT32_(0x1AA4)    /* (TRAM_RAM681) TrustRAM Offset */
#define TRAM_RAM682_REG_OFST           _UINT32_(0x1AA8)    /* (TRAM_RAM682) TrustRAM Offset */
#define TRAM_RAM683_REG_OFST           _UINT32_(0x1AAC)    /* (TRAM_RAM683) TrustRAM Offset */
#define TRAM_RAM684_REG_OFST           _UINT32_(0x1AB0)    /* (TRAM_RAM684) TrustRAM Offset */
#define TRAM_RAM685_REG_OFST           _UINT32_(0x1AB4)    /* (TRAM_RAM685) TrustRAM Offset */
#define TRAM_RAM686_REG_OFST           _UINT32_(0x1AB8)    /* (TRAM_RAM686) TrustRAM Offset */
#define TRAM_RAM687_REG_OFST           _UINT32_(0x1ABC)    /* (TRAM_RAM687) TrustRAM Offset */
#define TRAM_RAM688_REG_OFST           _UINT32_(0x1AC0)    /* (TRAM_RAM688) TrustRAM Offset */
#define TRAM_RAM689_REG_OFST           _UINT32_(0x1AC4)    /* (TRAM_RAM689) TrustRAM Offset */
#define TRAM_RAM690_REG_OFST           _UINT32_(0x1AC8)    /* (TRAM_RAM690) TrustRAM Offset */
#define TRAM_RAM691_REG_OFST           _UINT32_(0x1ACC)    /* (TRAM_RAM691) TrustRAM Offset */
#define TRAM_RAM692_REG_OFST           _UINT32_(0x1AD0)    /* (TRAM_RAM692) TrustRAM Offset */
#define TRAM_RAM693_REG_OFST           _UINT32_(0x1AD4)    /* (TRAM_RAM693) TrustRAM Offset */
#define TRAM_RAM694_REG_OFST           _UINT32_(0x1AD8)    /* (TRAM_RAM694) TrustRAM Offset */
#define TRAM_RAM695_REG_OFST           _UINT32_(0x1ADC)    /* (TRAM_RAM695) TrustRAM Offset */
#define TRAM_RAM696_REG_OFST           _UINT32_(0x1AE0)    /* (TRAM_RAM696) TrustRAM Offset */
#define TRAM_RAM697_REG_OFST           _UINT32_(0x1AE4)    /* (TRAM_RAM697) TrustRAM Offset */
#define TRAM_RAM698_REG_OFST           _UINT32_(0x1AE8)    /* (TRAM_RAM698) TrustRAM Offset */
#define TRAM_RAM699_REG_OFST           _UINT32_(0x1AEC)    /* (TRAM_RAM699) TrustRAM Offset */
#define TRAM_RAM700_REG_OFST           _UINT32_(0x1AF0)    /* (TRAM_RAM700) TrustRAM Offset */
#define TRAM_RAM701_REG_OFST           _UINT32_(0x1AF4)    /* (TRAM_RAM701) TrustRAM Offset */
#define TRAM_RAM702_REG_OFST           _UINT32_(0x1AF8)    /* (TRAM_RAM702) TrustRAM Offset */
#define TRAM_RAM703_REG_OFST           _UINT32_(0x1AFC)    /* (TRAM_RAM703) TrustRAM Offset */
#define TRAM_RAM704_REG_OFST           _UINT32_(0x1B00)    /* (TRAM_RAM704) TrustRAM Offset */
#define TRAM_RAM705_REG_OFST           _UINT32_(0x1B04)    /* (TRAM_RAM705) TrustRAM Offset */
#define TRAM_RAM706_REG_OFST           _UINT32_(0x1B08)    /* (TRAM_RAM706) TrustRAM Offset */
#define TRAM_RAM707_REG_OFST           _UINT32_(0x1B0C)    /* (TRAM_RAM707) TrustRAM Offset */
#define TRAM_RAM708_REG_OFST           _UINT32_(0x1B10)    /* (TRAM_RAM708) TrustRAM Offset */
#define TRAM_RAM709_REG_OFST           _UINT32_(0x1B14)    /* (TRAM_RAM709) TrustRAM Offset */
#define TRAM_RAM710_REG_OFST           _UINT32_(0x1B18)    /* (TRAM_RAM710) TrustRAM Offset */
#define TRAM_RAM711_REG_OFST           _UINT32_(0x1B1C)    /* (TRAM_RAM711) TrustRAM Offset */
#define TRAM_RAM712_REG_OFST           _UINT32_(0x1B20)    /* (TRAM_RAM712) TrustRAM Offset */
#define TRAM_RAM713_REG_OFST           _UINT32_(0x1B24)    /* (TRAM_RAM713) TrustRAM Offset */
#define TRAM_RAM714_REG_OFST           _UINT32_(0x1B28)    /* (TRAM_RAM714) TrustRAM Offset */
#define TRAM_RAM715_REG_OFST           _UINT32_(0x1B2C)    /* (TRAM_RAM715) TrustRAM Offset */
#define TRAM_RAM716_REG_OFST           _UINT32_(0x1B30)    /* (TRAM_RAM716) TrustRAM Offset */
#define TRAM_RAM717_REG_OFST           _UINT32_(0x1B34)    /* (TRAM_RAM717) TrustRAM Offset */
#define TRAM_RAM718_REG_OFST           _UINT32_(0x1B38)    /* (TRAM_RAM718) TrustRAM Offset */
#define TRAM_RAM719_REG_OFST           _UINT32_(0x1B3C)    /* (TRAM_RAM719) TrustRAM Offset */
#define TRAM_RAM720_REG_OFST           _UINT32_(0x1B40)    /* (TRAM_RAM720) TrustRAM Offset */
#define TRAM_RAM721_REG_OFST           _UINT32_(0x1B44)    /* (TRAM_RAM721) TrustRAM Offset */
#define TRAM_RAM722_REG_OFST           _UINT32_(0x1B48)    /* (TRAM_RAM722) TrustRAM Offset */
#define TRAM_RAM723_REG_OFST           _UINT32_(0x1B4C)    /* (TRAM_RAM723) TrustRAM Offset */
#define TRAM_RAM724_REG_OFST           _UINT32_(0x1B50)    /* (TRAM_RAM724) TrustRAM Offset */
#define TRAM_RAM725_REG_OFST           _UINT32_(0x1B54)    /* (TRAM_RAM725) TrustRAM Offset */
#define TRAM_RAM726_REG_OFST           _UINT32_(0x1B58)    /* (TRAM_RAM726) TrustRAM Offset */
#define TRAM_RAM727_REG_OFST           _UINT32_(0x1B5C)    /* (TRAM_RAM727) TrustRAM Offset */
#define TRAM_RAM728_REG_OFST           _UINT32_(0x1B60)    /* (TRAM_RAM728) TrustRAM Offset */
#define TRAM_RAM729_REG_OFST           _UINT32_(0x1B64)    /* (TRAM_RAM729) TrustRAM Offset */
#define TRAM_RAM730_REG_OFST           _UINT32_(0x1B68)    /* (TRAM_RAM730) TrustRAM Offset */
#define TRAM_RAM731_REG_OFST           _UINT32_(0x1B6C)    /* (TRAM_RAM731) TrustRAM Offset */
#define TRAM_RAM732_REG_OFST           _UINT32_(0x1B70)    /* (TRAM_RAM732) TrustRAM Offset */
#define TRAM_RAM733_REG_OFST           _UINT32_(0x1B74)    /* (TRAM_RAM733) TrustRAM Offset */
#define TRAM_RAM734_REG_OFST           _UINT32_(0x1B78)    /* (TRAM_RAM734) TrustRAM Offset */
#define TRAM_RAM735_REG_OFST           _UINT32_(0x1B7C)    /* (TRAM_RAM735) TrustRAM Offset */
#define TRAM_RAM736_REG_OFST           _UINT32_(0x1B80)    /* (TRAM_RAM736) TrustRAM Offset */
#define TRAM_RAM737_REG_OFST           _UINT32_(0x1B84)    /* (TRAM_RAM737) TrustRAM Offset */
#define TRAM_RAM738_REG_OFST           _UINT32_(0x1B88)    /* (TRAM_RAM738) TrustRAM Offset */
#define TRAM_RAM739_REG_OFST           _UINT32_(0x1B8C)    /* (TRAM_RAM739) TrustRAM Offset */
#define TRAM_RAM740_REG_OFST           _UINT32_(0x1B90)    /* (TRAM_RAM740) TrustRAM Offset */
#define TRAM_RAM741_REG_OFST           _UINT32_(0x1B94)    /* (TRAM_RAM741) TrustRAM Offset */
#define TRAM_RAM742_REG_OFST           _UINT32_(0x1B98)    /* (TRAM_RAM742) TrustRAM Offset */
#define TRAM_RAM743_REG_OFST           _UINT32_(0x1B9C)    /* (TRAM_RAM743) TrustRAM Offset */
#define TRAM_RAM744_REG_OFST           _UINT32_(0x1BA0)    /* (TRAM_RAM744) TrustRAM Offset */
#define TRAM_RAM745_REG_OFST           _UINT32_(0x1BA4)    /* (TRAM_RAM745) TrustRAM Offset */
#define TRAM_RAM746_REG_OFST           _UINT32_(0x1BA8)    /* (TRAM_RAM746) TrustRAM Offset */
#define TRAM_RAM747_REG_OFST           _UINT32_(0x1BAC)    /* (TRAM_RAM747) TrustRAM Offset */
#define TRAM_RAM748_REG_OFST           _UINT32_(0x1BB0)    /* (TRAM_RAM748) TrustRAM Offset */
#define TRAM_RAM749_REG_OFST           _UINT32_(0x1BB4)    /* (TRAM_RAM749) TrustRAM Offset */
#define TRAM_RAM750_REG_OFST           _UINT32_(0x1BB8)    /* (TRAM_RAM750) TrustRAM Offset */
#define TRAM_RAM751_REG_OFST           _UINT32_(0x1BBC)    /* (TRAM_RAM751) TrustRAM Offset */
#define TRAM_RAM752_REG_OFST           _UINT32_(0x1BC0)    /* (TRAM_RAM752) TrustRAM Offset */
#define TRAM_RAM753_REG_OFST           _UINT32_(0x1BC4)    /* (TRAM_RAM753) TrustRAM Offset */
#define TRAM_RAM754_REG_OFST           _UINT32_(0x1BC8)    /* (TRAM_RAM754) TrustRAM Offset */
#define TRAM_RAM755_REG_OFST           _UINT32_(0x1BCC)    /* (TRAM_RAM755) TrustRAM Offset */
#define TRAM_RAM756_REG_OFST           _UINT32_(0x1BD0)    /* (TRAM_RAM756) TrustRAM Offset */
#define TRAM_RAM757_REG_OFST           _UINT32_(0x1BD4)    /* (TRAM_RAM757) TrustRAM Offset */
#define TRAM_RAM758_REG_OFST           _UINT32_(0x1BD8)    /* (TRAM_RAM758) TrustRAM Offset */
#define TRAM_RAM759_REG_OFST           _UINT32_(0x1BDC)    /* (TRAM_RAM759) TrustRAM Offset */
#define TRAM_RAM760_REG_OFST           _UINT32_(0x1BE0)    /* (TRAM_RAM760) TrustRAM Offset */
#define TRAM_RAM761_REG_OFST           _UINT32_(0x1BE4)    /* (TRAM_RAM761) TrustRAM Offset */
#define TRAM_RAM762_REG_OFST           _UINT32_(0x1BE8)    /* (TRAM_RAM762) TrustRAM Offset */
#define TRAM_RAM763_REG_OFST           _UINT32_(0x1BEC)    /* (TRAM_RAM763) TrustRAM Offset */
#define TRAM_RAM764_REG_OFST           _UINT32_(0x1BF0)    /* (TRAM_RAM764) TrustRAM Offset */
#define TRAM_RAM765_REG_OFST           _UINT32_(0x1BF4)    /* (TRAM_RAM765) TrustRAM Offset */
#define TRAM_RAM766_REG_OFST           _UINT32_(0x1BF8)    /* (TRAM_RAM766) TrustRAM Offset */
#define TRAM_RAM767_REG_OFST           _UINT32_(0x1BFC)    /* (TRAM_RAM767) TrustRAM Offset */
#define TRAM_RAM768_REG_OFST           _UINT32_(0x1C00)    /* (TRAM_RAM768) TrustRAM Offset */
#define TRAM_RAM769_REG_OFST           _UINT32_(0x1C04)    /* (TRAM_RAM769) TrustRAM Offset */
#define TRAM_RAM770_REG_OFST           _UINT32_(0x1C08)    /* (TRAM_RAM770) TrustRAM Offset */
#define TRAM_RAM771_REG_OFST           _UINT32_(0x1C0C)    /* (TRAM_RAM771) TrustRAM Offset */
#define TRAM_RAM772_REG_OFST           _UINT32_(0x1C10)    /* (TRAM_RAM772) TrustRAM Offset */
#define TRAM_RAM773_REG_OFST           _UINT32_(0x1C14)    /* (TRAM_RAM773) TrustRAM Offset */
#define TRAM_RAM774_REG_OFST           _UINT32_(0x1C18)    /* (TRAM_RAM774) TrustRAM Offset */
#define TRAM_RAM775_REG_OFST           _UINT32_(0x1C1C)    /* (TRAM_RAM775) TrustRAM Offset */
#define TRAM_RAM776_REG_OFST           _UINT32_(0x1C20)    /* (TRAM_RAM776) TrustRAM Offset */
#define TRAM_RAM777_REG_OFST           _UINT32_(0x1C24)    /* (TRAM_RAM777) TrustRAM Offset */
#define TRAM_RAM778_REG_OFST           _UINT32_(0x1C28)    /* (TRAM_RAM778) TrustRAM Offset */
#define TRAM_RAM779_REG_OFST           _UINT32_(0x1C2C)    /* (TRAM_RAM779) TrustRAM Offset */
#define TRAM_RAM780_REG_OFST           _UINT32_(0x1C30)    /* (TRAM_RAM780) TrustRAM Offset */
#define TRAM_RAM781_REG_OFST           _UINT32_(0x1C34)    /* (TRAM_RAM781) TrustRAM Offset */
#define TRAM_RAM782_REG_OFST           _UINT32_(0x1C38)    /* (TRAM_RAM782) TrustRAM Offset */
#define TRAM_RAM783_REG_OFST           _UINT32_(0x1C3C)    /* (TRAM_RAM783) TrustRAM Offset */
#define TRAM_RAM784_REG_OFST           _UINT32_(0x1C40)    /* (TRAM_RAM784) TrustRAM Offset */
#define TRAM_RAM785_REG_OFST           _UINT32_(0x1C44)    /* (TRAM_RAM785) TrustRAM Offset */
#define TRAM_RAM786_REG_OFST           _UINT32_(0x1C48)    /* (TRAM_RAM786) TrustRAM Offset */
#define TRAM_RAM787_REG_OFST           _UINT32_(0x1C4C)    /* (TRAM_RAM787) TrustRAM Offset */
#define TRAM_RAM788_REG_OFST           _UINT32_(0x1C50)    /* (TRAM_RAM788) TrustRAM Offset */
#define TRAM_RAM789_REG_OFST           _UINT32_(0x1C54)    /* (TRAM_RAM789) TrustRAM Offset */
#define TRAM_RAM790_REG_OFST           _UINT32_(0x1C58)    /* (TRAM_RAM790) TrustRAM Offset */
#define TRAM_RAM791_REG_OFST           _UINT32_(0x1C5C)    /* (TRAM_RAM791) TrustRAM Offset */
#define TRAM_RAM792_REG_OFST           _UINT32_(0x1C60)    /* (TRAM_RAM792) TrustRAM Offset */
#define TRAM_RAM793_REG_OFST           _UINT32_(0x1C64)    /* (TRAM_RAM793) TrustRAM Offset */
#define TRAM_RAM794_REG_OFST           _UINT32_(0x1C68)    /* (TRAM_RAM794) TrustRAM Offset */
#define TRAM_RAM795_REG_OFST           _UINT32_(0x1C6C)    /* (TRAM_RAM795) TrustRAM Offset */
#define TRAM_RAM796_REG_OFST           _UINT32_(0x1C70)    /* (TRAM_RAM796) TrustRAM Offset */
#define TRAM_RAM797_REG_OFST           _UINT32_(0x1C74)    /* (TRAM_RAM797) TrustRAM Offset */
#define TRAM_RAM798_REG_OFST           _UINT32_(0x1C78)    /* (TRAM_RAM798) TrustRAM Offset */
#define TRAM_RAM799_REG_OFST           _UINT32_(0x1C7C)    /* (TRAM_RAM799) TrustRAM Offset */
#define TRAM_RAM800_REG_OFST           _UINT32_(0x1C80)    /* (TRAM_RAM800) TrustRAM Offset */
#define TRAM_RAM801_REG_OFST           _UINT32_(0x1C84)    /* (TRAM_RAM801) TrustRAM Offset */
#define TRAM_RAM802_REG_OFST           _UINT32_(0x1C88)    /* (TRAM_RAM802) TrustRAM Offset */
#define TRAM_RAM803_REG_OFST           _UINT32_(0x1C8C)    /* (TRAM_RAM803) TrustRAM Offset */
#define TRAM_RAM804_REG_OFST           _UINT32_(0x1C90)    /* (TRAM_RAM804) TrustRAM Offset */
#define TRAM_RAM805_REG_OFST           _UINT32_(0x1C94)    /* (TRAM_RAM805) TrustRAM Offset */
#define TRAM_RAM806_REG_OFST           _UINT32_(0x1C98)    /* (TRAM_RAM806) TrustRAM Offset */
#define TRAM_RAM807_REG_OFST           _UINT32_(0x1C9C)    /* (TRAM_RAM807) TrustRAM Offset */
#define TRAM_RAM808_REG_OFST           _UINT32_(0x1CA0)    /* (TRAM_RAM808) TrustRAM Offset */
#define TRAM_RAM809_REG_OFST           _UINT32_(0x1CA4)    /* (TRAM_RAM809) TrustRAM Offset */
#define TRAM_RAM810_REG_OFST           _UINT32_(0x1CA8)    /* (TRAM_RAM810) TrustRAM Offset */
#define TRAM_RAM811_REG_OFST           _UINT32_(0x1CAC)    /* (TRAM_RAM811) TrustRAM Offset */
#define TRAM_RAM812_REG_OFST           _UINT32_(0x1CB0)    /* (TRAM_RAM812) TrustRAM Offset */
#define TRAM_RAM813_REG_OFST           _UINT32_(0x1CB4)    /* (TRAM_RAM813) TrustRAM Offset */
#define TRAM_RAM814_REG_OFST           _UINT32_(0x1CB8)    /* (TRAM_RAM814) TrustRAM Offset */
#define TRAM_RAM815_REG_OFST           _UINT32_(0x1CBC)    /* (TRAM_RAM815) TrustRAM Offset */
#define TRAM_RAM816_REG_OFST           _UINT32_(0x1CC0)    /* (TRAM_RAM816) TrustRAM Offset */
#define TRAM_RAM817_REG_OFST           _UINT32_(0x1CC4)    /* (TRAM_RAM817) TrustRAM Offset */
#define TRAM_RAM818_REG_OFST           _UINT32_(0x1CC8)    /* (TRAM_RAM818) TrustRAM Offset */
#define TRAM_RAM819_REG_OFST           _UINT32_(0x1CCC)    /* (TRAM_RAM819) TrustRAM Offset */
#define TRAM_RAM820_REG_OFST           _UINT32_(0x1CD0)    /* (TRAM_RAM820) TrustRAM Offset */
#define TRAM_RAM821_REG_OFST           _UINT32_(0x1CD4)    /* (TRAM_RAM821) TrustRAM Offset */
#define TRAM_RAM822_REG_OFST           _UINT32_(0x1CD8)    /* (TRAM_RAM822) TrustRAM Offset */
#define TRAM_RAM823_REG_OFST           _UINT32_(0x1CDC)    /* (TRAM_RAM823) TrustRAM Offset */
#define TRAM_RAM824_REG_OFST           _UINT32_(0x1CE0)    /* (TRAM_RAM824) TrustRAM Offset */
#define TRAM_RAM825_REG_OFST           _UINT32_(0x1CE4)    /* (TRAM_RAM825) TrustRAM Offset */
#define TRAM_RAM826_REG_OFST           _UINT32_(0x1CE8)    /* (TRAM_RAM826) TrustRAM Offset */
#define TRAM_RAM827_REG_OFST           _UINT32_(0x1CEC)    /* (TRAM_RAM827) TrustRAM Offset */
#define TRAM_RAM828_REG_OFST           _UINT32_(0x1CF0)    /* (TRAM_RAM828) TrustRAM Offset */
#define TRAM_RAM829_REG_OFST           _UINT32_(0x1CF4)    /* (TRAM_RAM829) TrustRAM Offset */
#define TRAM_RAM830_REG_OFST           _UINT32_(0x1CF8)    /* (TRAM_RAM830) TrustRAM Offset */
#define TRAM_RAM831_REG_OFST           _UINT32_(0x1CFC)    /* (TRAM_RAM831) TrustRAM Offset */
#define TRAM_RAM832_REG_OFST           _UINT32_(0x1D00)    /* (TRAM_RAM832) TrustRAM Offset */
#define TRAM_RAM833_REG_OFST           _UINT32_(0x1D04)    /* (TRAM_RAM833) TrustRAM Offset */
#define TRAM_RAM834_REG_OFST           _UINT32_(0x1D08)    /* (TRAM_RAM834) TrustRAM Offset */
#define TRAM_RAM835_REG_OFST           _UINT32_(0x1D0C)    /* (TRAM_RAM835) TrustRAM Offset */
#define TRAM_RAM836_REG_OFST           _UINT32_(0x1D10)    /* (TRAM_RAM836) TrustRAM Offset */
#define TRAM_RAM837_REG_OFST           _UINT32_(0x1D14)    /* (TRAM_RAM837) TrustRAM Offset */
#define TRAM_RAM838_REG_OFST           _UINT32_(0x1D18)    /* (TRAM_RAM838) TrustRAM Offset */
#define TRAM_RAM839_REG_OFST           _UINT32_(0x1D1C)    /* (TRAM_RAM839) TrustRAM Offset */
#define TRAM_RAM840_REG_OFST           _UINT32_(0x1D20)    /* (TRAM_RAM840) TrustRAM Offset */
#define TRAM_RAM841_REG_OFST           _UINT32_(0x1D24)    /* (TRAM_RAM841) TrustRAM Offset */
#define TRAM_RAM842_REG_OFST           _UINT32_(0x1D28)    /* (TRAM_RAM842) TrustRAM Offset */
#define TRAM_RAM843_REG_OFST           _UINT32_(0x1D2C)    /* (TRAM_RAM843) TrustRAM Offset */
#define TRAM_RAM844_REG_OFST           _UINT32_(0x1D30)    /* (TRAM_RAM844) TrustRAM Offset */
#define TRAM_RAM845_REG_OFST           _UINT32_(0x1D34)    /* (TRAM_RAM845) TrustRAM Offset */
#define TRAM_RAM846_REG_OFST           _UINT32_(0x1D38)    /* (TRAM_RAM846) TrustRAM Offset */
#define TRAM_RAM847_REG_OFST           _UINT32_(0x1D3C)    /* (TRAM_RAM847) TrustRAM Offset */
#define TRAM_RAM848_REG_OFST           _UINT32_(0x1D40)    /* (TRAM_RAM848) TrustRAM Offset */
#define TRAM_RAM849_REG_OFST           _UINT32_(0x1D44)    /* (TRAM_RAM849) TrustRAM Offset */
#define TRAM_RAM850_REG_OFST           _UINT32_(0x1D48)    /* (TRAM_RAM850) TrustRAM Offset */
#define TRAM_RAM851_REG_OFST           _UINT32_(0x1D4C)    /* (TRAM_RAM851) TrustRAM Offset */
#define TRAM_RAM852_REG_OFST           _UINT32_(0x1D50)    /* (TRAM_RAM852) TrustRAM Offset */
#define TRAM_RAM853_REG_OFST           _UINT32_(0x1D54)    /* (TRAM_RAM853) TrustRAM Offset */
#define TRAM_RAM854_REG_OFST           _UINT32_(0x1D58)    /* (TRAM_RAM854) TrustRAM Offset */
#define TRAM_RAM855_REG_OFST           _UINT32_(0x1D5C)    /* (TRAM_RAM855) TrustRAM Offset */
#define TRAM_RAM856_REG_OFST           _UINT32_(0x1D60)    /* (TRAM_RAM856) TrustRAM Offset */
#define TRAM_RAM857_REG_OFST           _UINT32_(0x1D64)    /* (TRAM_RAM857) TrustRAM Offset */
#define TRAM_RAM858_REG_OFST           _UINT32_(0x1D68)    /* (TRAM_RAM858) TrustRAM Offset */
#define TRAM_RAM859_REG_OFST           _UINT32_(0x1D6C)    /* (TRAM_RAM859) TrustRAM Offset */
#define TRAM_RAM860_REG_OFST           _UINT32_(0x1D70)    /* (TRAM_RAM860) TrustRAM Offset */
#define TRAM_RAM861_REG_OFST           _UINT32_(0x1D74)    /* (TRAM_RAM861) TrustRAM Offset */
#define TRAM_RAM862_REG_OFST           _UINT32_(0x1D78)    /* (TRAM_RAM862) TrustRAM Offset */
#define TRAM_RAM863_REG_OFST           _UINT32_(0x1D7C)    /* (TRAM_RAM863) TrustRAM Offset */
#define TRAM_RAM864_REG_OFST           _UINT32_(0x1D80)    /* (TRAM_RAM864) TrustRAM Offset */
#define TRAM_RAM865_REG_OFST           _UINT32_(0x1D84)    /* (TRAM_RAM865) TrustRAM Offset */
#define TRAM_RAM866_REG_OFST           _UINT32_(0x1D88)    /* (TRAM_RAM866) TrustRAM Offset */
#define TRAM_RAM867_REG_OFST           _UINT32_(0x1D8C)    /* (TRAM_RAM867) TrustRAM Offset */
#define TRAM_RAM868_REG_OFST           _UINT32_(0x1D90)    /* (TRAM_RAM868) TrustRAM Offset */
#define TRAM_RAM869_REG_OFST           _UINT32_(0x1D94)    /* (TRAM_RAM869) TrustRAM Offset */
#define TRAM_RAM870_REG_OFST           _UINT32_(0x1D98)    /* (TRAM_RAM870) TrustRAM Offset */
#define TRAM_RAM871_REG_OFST           _UINT32_(0x1D9C)    /* (TRAM_RAM871) TrustRAM Offset */
#define TRAM_RAM872_REG_OFST           _UINT32_(0x1DA0)    /* (TRAM_RAM872) TrustRAM Offset */
#define TRAM_RAM873_REG_OFST           _UINT32_(0x1DA4)    /* (TRAM_RAM873) TrustRAM Offset */
#define TRAM_RAM874_REG_OFST           _UINT32_(0x1DA8)    /* (TRAM_RAM874) TrustRAM Offset */
#define TRAM_RAM875_REG_OFST           _UINT32_(0x1DAC)    /* (TRAM_RAM875) TrustRAM Offset */
#define TRAM_RAM876_REG_OFST           _UINT32_(0x1DB0)    /* (TRAM_RAM876) TrustRAM Offset */
#define TRAM_RAM877_REG_OFST           _UINT32_(0x1DB4)    /* (TRAM_RAM877) TrustRAM Offset */
#define TRAM_RAM878_REG_OFST           _UINT32_(0x1DB8)    /* (TRAM_RAM878) TrustRAM Offset */
#define TRAM_RAM879_REG_OFST           _UINT32_(0x1DBC)    /* (TRAM_RAM879) TrustRAM Offset */
#define TRAM_RAM880_REG_OFST           _UINT32_(0x1DC0)    /* (TRAM_RAM880) TrustRAM Offset */
#define TRAM_RAM881_REG_OFST           _UINT32_(0x1DC4)    /* (TRAM_RAM881) TrustRAM Offset */
#define TRAM_RAM882_REG_OFST           _UINT32_(0x1DC8)    /* (TRAM_RAM882) TrustRAM Offset */
#define TRAM_RAM883_REG_OFST           _UINT32_(0x1DCC)    /* (TRAM_RAM883) TrustRAM Offset */
#define TRAM_RAM884_REG_OFST           _UINT32_(0x1DD0)    /* (TRAM_RAM884) TrustRAM Offset */
#define TRAM_RAM885_REG_OFST           _UINT32_(0x1DD4)    /* (TRAM_RAM885) TrustRAM Offset */
#define TRAM_RAM886_REG_OFST           _UINT32_(0x1DD8)    /* (TRAM_RAM886) TrustRAM Offset */
#define TRAM_RAM887_REG_OFST           _UINT32_(0x1DDC)    /* (TRAM_RAM887) TrustRAM Offset */
#define TRAM_RAM888_REG_OFST           _UINT32_(0x1DE0)    /* (TRAM_RAM888) TrustRAM Offset */
#define TRAM_RAM889_REG_OFST           _UINT32_(0x1DE4)    /* (TRAM_RAM889) TrustRAM Offset */
#define TRAM_RAM890_REG_OFST           _UINT32_(0x1DE8)    /* (TRAM_RAM890) TrustRAM Offset */
#define TRAM_RAM891_REG_OFST           _UINT32_(0x1DEC)    /* (TRAM_RAM891) TrustRAM Offset */
#define TRAM_RAM892_REG_OFST           _UINT32_(0x1DF0)    /* (TRAM_RAM892) TrustRAM Offset */
#define TRAM_RAM893_REG_OFST           _UINT32_(0x1DF4)    /* (TRAM_RAM893) TrustRAM Offset */
#define TRAM_RAM894_REG_OFST           _UINT32_(0x1DF8)    /* (TRAM_RAM894) TrustRAM Offset */
#define TRAM_RAM895_REG_OFST           _UINT32_(0x1DFC)    /* (TRAM_RAM895) TrustRAM Offset */
#define TRAM_RAM896_REG_OFST           _UINT32_(0x1E00)    /* (TRAM_RAM896) TrustRAM Offset */
#define TRAM_RAM897_REG_OFST           _UINT32_(0x1E04)    /* (TRAM_RAM897) TrustRAM Offset */
#define TRAM_RAM898_REG_OFST           _UINT32_(0x1E08)    /* (TRAM_RAM898) TrustRAM Offset */
#define TRAM_RAM899_REG_OFST           _UINT32_(0x1E0C)    /* (TRAM_RAM899) TrustRAM Offset */
#define TRAM_RAM900_REG_OFST           _UINT32_(0x1E10)    /* (TRAM_RAM900) TrustRAM Offset */
#define TRAM_RAM901_REG_OFST           _UINT32_(0x1E14)    /* (TRAM_RAM901) TrustRAM Offset */
#define TRAM_RAM902_REG_OFST           _UINT32_(0x1E18)    /* (TRAM_RAM902) TrustRAM Offset */
#define TRAM_RAM903_REG_OFST           _UINT32_(0x1E1C)    /* (TRAM_RAM903) TrustRAM Offset */
#define TRAM_RAM904_REG_OFST           _UINT32_(0x1E20)    /* (TRAM_RAM904) TrustRAM Offset */
#define TRAM_RAM905_REG_OFST           _UINT32_(0x1E24)    /* (TRAM_RAM905) TrustRAM Offset */
#define TRAM_RAM906_REG_OFST           _UINT32_(0x1E28)    /* (TRAM_RAM906) TrustRAM Offset */
#define TRAM_RAM907_REG_OFST           _UINT32_(0x1E2C)    /* (TRAM_RAM907) TrustRAM Offset */
#define TRAM_RAM908_REG_OFST           _UINT32_(0x1E30)    /* (TRAM_RAM908) TrustRAM Offset */
#define TRAM_RAM909_REG_OFST           _UINT32_(0x1E34)    /* (TRAM_RAM909) TrustRAM Offset */
#define TRAM_RAM910_REG_OFST           _UINT32_(0x1E38)    /* (TRAM_RAM910) TrustRAM Offset */
#define TRAM_RAM911_REG_OFST           _UINT32_(0x1E3C)    /* (TRAM_RAM911) TrustRAM Offset */
#define TRAM_RAM912_REG_OFST           _UINT32_(0x1E40)    /* (TRAM_RAM912) TrustRAM Offset */
#define TRAM_RAM913_REG_OFST           _UINT32_(0x1E44)    /* (TRAM_RAM913) TrustRAM Offset */
#define TRAM_RAM914_REG_OFST           _UINT32_(0x1E48)    /* (TRAM_RAM914) TrustRAM Offset */
#define TRAM_RAM915_REG_OFST           _UINT32_(0x1E4C)    /* (TRAM_RAM915) TrustRAM Offset */
#define TRAM_RAM916_REG_OFST           _UINT32_(0x1E50)    /* (TRAM_RAM916) TrustRAM Offset */
#define TRAM_RAM917_REG_OFST           _UINT32_(0x1E54)    /* (TRAM_RAM917) TrustRAM Offset */
#define TRAM_RAM918_REG_OFST           _UINT32_(0x1E58)    /* (TRAM_RAM918) TrustRAM Offset */
#define TRAM_RAM919_REG_OFST           _UINT32_(0x1E5C)    /* (TRAM_RAM919) TrustRAM Offset */
#define TRAM_RAM920_REG_OFST           _UINT32_(0x1E60)    /* (TRAM_RAM920) TrustRAM Offset */
#define TRAM_RAM921_REG_OFST           _UINT32_(0x1E64)    /* (TRAM_RAM921) TrustRAM Offset */
#define TRAM_RAM922_REG_OFST           _UINT32_(0x1E68)    /* (TRAM_RAM922) TrustRAM Offset */
#define TRAM_RAM923_REG_OFST           _UINT32_(0x1E6C)    /* (TRAM_RAM923) TrustRAM Offset */
#define TRAM_RAM924_REG_OFST           _UINT32_(0x1E70)    /* (TRAM_RAM924) TrustRAM Offset */
#define TRAM_RAM925_REG_OFST           _UINT32_(0x1E74)    /* (TRAM_RAM925) TrustRAM Offset */
#define TRAM_RAM926_REG_OFST           _UINT32_(0x1E78)    /* (TRAM_RAM926) TrustRAM Offset */
#define TRAM_RAM927_REG_OFST           _UINT32_(0x1E7C)    /* (TRAM_RAM927) TrustRAM Offset */
#define TRAM_RAM928_REG_OFST           _UINT32_(0x1E80)    /* (TRAM_RAM928) TrustRAM Offset */
#define TRAM_RAM929_REG_OFST           _UINT32_(0x1E84)    /* (TRAM_RAM929) TrustRAM Offset */
#define TRAM_RAM930_REG_OFST           _UINT32_(0x1E88)    /* (TRAM_RAM930) TrustRAM Offset */
#define TRAM_RAM931_REG_OFST           _UINT32_(0x1E8C)    /* (TRAM_RAM931) TrustRAM Offset */
#define TRAM_RAM932_REG_OFST           _UINT32_(0x1E90)    /* (TRAM_RAM932) TrustRAM Offset */
#define TRAM_RAM933_REG_OFST           _UINT32_(0x1E94)    /* (TRAM_RAM933) TrustRAM Offset */
#define TRAM_RAM934_REG_OFST           _UINT32_(0x1E98)    /* (TRAM_RAM934) TrustRAM Offset */
#define TRAM_RAM935_REG_OFST           _UINT32_(0x1E9C)    /* (TRAM_RAM935) TrustRAM Offset */
#define TRAM_RAM936_REG_OFST           _UINT32_(0x1EA0)    /* (TRAM_RAM936) TrustRAM Offset */
#define TRAM_RAM937_REG_OFST           _UINT32_(0x1EA4)    /* (TRAM_RAM937) TrustRAM Offset */
#define TRAM_RAM938_REG_OFST           _UINT32_(0x1EA8)    /* (TRAM_RAM938) TrustRAM Offset */
#define TRAM_RAM939_REG_OFST           _UINT32_(0x1EAC)    /* (TRAM_RAM939) TrustRAM Offset */
#define TRAM_RAM940_REG_OFST           _UINT32_(0x1EB0)    /* (TRAM_RAM940) TrustRAM Offset */
#define TRAM_RAM941_REG_OFST           _UINT32_(0x1EB4)    /* (TRAM_RAM941) TrustRAM Offset */
#define TRAM_RAM942_REG_OFST           _UINT32_(0x1EB8)    /* (TRAM_RAM942) TrustRAM Offset */
#define TRAM_RAM943_REG_OFST           _UINT32_(0x1EBC)    /* (TRAM_RAM943) TrustRAM Offset */
#define TRAM_RAM944_REG_OFST           _UINT32_(0x1EC0)    /* (TRAM_RAM944) TrustRAM Offset */
#define TRAM_RAM945_REG_OFST           _UINT32_(0x1EC4)    /* (TRAM_RAM945) TrustRAM Offset */
#define TRAM_RAM946_REG_OFST           _UINT32_(0x1EC8)    /* (TRAM_RAM946) TrustRAM Offset */
#define TRAM_RAM947_REG_OFST           _UINT32_(0x1ECC)    /* (TRAM_RAM947) TrustRAM Offset */
#define TRAM_RAM948_REG_OFST           _UINT32_(0x1ED0)    /* (TRAM_RAM948) TrustRAM Offset */
#define TRAM_RAM949_REG_OFST           _UINT32_(0x1ED4)    /* (TRAM_RAM949) TrustRAM Offset */
#define TRAM_RAM950_REG_OFST           _UINT32_(0x1ED8)    /* (TRAM_RAM950) TrustRAM Offset */
#define TRAM_RAM951_REG_OFST           _UINT32_(0x1EDC)    /* (TRAM_RAM951) TrustRAM Offset */
#define TRAM_RAM952_REG_OFST           _UINT32_(0x1EE0)    /* (TRAM_RAM952) TrustRAM Offset */
#define TRAM_RAM953_REG_OFST           _UINT32_(0x1EE4)    /* (TRAM_RAM953) TrustRAM Offset */
#define TRAM_RAM954_REG_OFST           _UINT32_(0x1EE8)    /* (TRAM_RAM954) TrustRAM Offset */
#define TRAM_RAM955_REG_OFST           _UINT32_(0x1EEC)    /* (TRAM_RAM955) TrustRAM Offset */
#define TRAM_RAM956_REG_OFST           _UINT32_(0x1EF0)    /* (TRAM_RAM956) TrustRAM Offset */
#define TRAM_RAM957_REG_OFST           _UINT32_(0x1EF4)    /* (TRAM_RAM957) TrustRAM Offset */
#define TRAM_RAM958_REG_OFST           _UINT32_(0x1EF8)    /* (TRAM_RAM958) TrustRAM Offset */
#define TRAM_RAM959_REG_OFST           _UINT32_(0x1EFC)    /* (TRAM_RAM959) TrustRAM Offset */
#define TRAM_RAM960_REG_OFST           _UINT32_(0x1F00)    /* (TRAM_RAM960) TrustRAM Offset */
#define TRAM_RAM961_REG_OFST           _UINT32_(0x1F04)    /* (TRAM_RAM961) TrustRAM Offset */
#define TRAM_RAM962_REG_OFST           _UINT32_(0x1F08)    /* (TRAM_RAM962) TrustRAM Offset */
#define TRAM_RAM963_REG_OFST           _UINT32_(0x1F0C)    /* (TRAM_RAM963) TrustRAM Offset */
#define TRAM_RAM964_REG_OFST           _UINT32_(0x1F10)    /* (TRAM_RAM964) TrustRAM Offset */
#define TRAM_RAM965_REG_OFST           _UINT32_(0x1F14)    /* (TRAM_RAM965) TrustRAM Offset */
#define TRAM_RAM966_REG_OFST           _UINT32_(0x1F18)    /* (TRAM_RAM966) TrustRAM Offset */
#define TRAM_RAM967_REG_OFST           _UINT32_(0x1F1C)    /* (TRAM_RAM967) TrustRAM Offset */
#define TRAM_RAM968_REG_OFST           _UINT32_(0x1F20)    /* (TRAM_RAM968) TrustRAM Offset */
#define TRAM_RAM969_REG_OFST           _UINT32_(0x1F24)    /* (TRAM_RAM969) TrustRAM Offset */
#define TRAM_RAM970_REG_OFST           _UINT32_(0x1F28)    /* (TRAM_RAM970) TrustRAM Offset */
#define TRAM_RAM971_REG_OFST           _UINT32_(0x1F2C)    /* (TRAM_RAM971) TrustRAM Offset */
#define TRAM_RAM972_REG_OFST           _UINT32_(0x1F30)    /* (TRAM_RAM972) TrustRAM Offset */
#define TRAM_RAM973_REG_OFST           _UINT32_(0x1F34)    /* (TRAM_RAM973) TrustRAM Offset */
#define TRAM_RAM974_REG_OFST           _UINT32_(0x1F38)    /* (TRAM_RAM974) TrustRAM Offset */
#define TRAM_RAM975_REG_OFST           _UINT32_(0x1F3C)    /* (TRAM_RAM975) TrustRAM Offset */
#define TRAM_RAM976_REG_OFST           _UINT32_(0x1F40)    /* (TRAM_RAM976) TrustRAM Offset */
#define TRAM_RAM977_REG_OFST           _UINT32_(0x1F44)    /* (TRAM_RAM977) TrustRAM Offset */
#define TRAM_RAM978_REG_OFST           _UINT32_(0x1F48)    /* (TRAM_RAM978) TrustRAM Offset */
#define TRAM_RAM979_REG_OFST           _UINT32_(0x1F4C)    /* (TRAM_RAM979) TrustRAM Offset */
#define TRAM_RAM980_REG_OFST           _UINT32_(0x1F50)    /* (TRAM_RAM980) TrustRAM Offset */
#define TRAM_RAM981_REG_OFST           _UINT32_(0x1F54)    /* (TRAM_RAM981) TrustRAM Offset */
#define TRAM_RAM982_REG_OFST           _UINT32_(0x1F58)    /* (TRAM_RAM982) TrustRAM Offset */
#define TRAM_RAM983_REG_OFST           _UINT32_(0x1F5C)    /* (TRAM_RAM983) TrustRAM Offset */
#define TRAM_RAM984_REG_OFST           _UINT32_(0x1F60)    /* (TRAM_RAM984) TrustRAM Offset */
#define TRAM_RAM985_REG_OFST           _UINT32_(0x1F64)    /* (TRAM_RAM985) TrustRAM Offset */
#define TRAM_RAM986_REG_OFST           _UINT32_(0x1F68)    /* (TRAM_RAM986) TrustRAM Offset */
#define TRAM_RAM987_REG_OFST           _UINT32_(0x1F6C)    /* (TRAM_RAM987) TrustRAM Offset */
#define TRAM_RAM988_REG_OFST           _UINT32_(0x1F70)    /* (TRAM_RAM988) TrustRAM Offset */
#define TRAM_RAM989_REG_OFST           _UINT32_(0x1F74)    /* (TRAM_RAM989) TrustRAM Offset */
#define TRAM_RAM990_REG_OFST           _UINT32_(0x1F78)    /* (TRAM_RAM990) TrustRAM Offset */
#define TRAM_RAM991_REG_OFST           _UINT32_(0x1F7C)    /* (TRAM_RAM991) TrustRAM Offset */
#define TRAM_RAM992_REG_OFST           _UINT32_(0x1F80)    /* (TRAM_RAM992) TrustRAM Offset */
#define TRAM_RAM993_REG_OFST           _UINT32_(0x1F84)    /* (TRAM_RAM993) TrustRAM Offset */
#define TRAM_RAM994_REG_OFST           _UINT32_(0x1F88)    /* (TRAM_RAM994) TrustRAM Offset */
#define TRAM_RAM995_REG_OFST           _UINT32_(0x1F8C)    /* (TRAM_RAM995) TrustRAM Offset */
#define TRAM_RAM996_REG_OFST           _UINT32_(0x1F90)    /* (TRAM_RAM996) TrustRAM Offset */
#define TRAM_RAM997_REG_OFST           _UINT32_(0x1F94)    /* (TRAM_RAM997) TrustRAM Offset */
#define TRAM_RAM998_REG_OFST           _UINT32_(0x1F98)    /* (TRAM_RAM998) TrustRAM Offset */
#define TRAM_RAM999_REG_OFST           _UINT32_(0x1F9C)    /* (TRAM_RAM999) TrustRAM Offset */
#define TRAM_RAM1000_REG_OFST          _UINT32_(0x1FA0)    /* (TRAM_RAM1000) TrustRAM Offset */
#define TRAM_RAM1001_REG_OFST          _UINT32_(0x1FA4)    /* (TRAM_RAM1001) TrustRAM Offset */
#define TRAM_RAM1002_REG_OFST          _UINT32_(0x1FA8)    /* (TRAM_RAM1002) TrustRAM Offset */
#define TRAM_RAM1003_REG_OFST          _UINT32_(0x1FAC)    /* (TRAM_RAM1003) TrustRAM Offset */
#define TRAM_RAM1004_REG_OFST          _UINT32_(0x1FB0)    /* (TRAM_RAM1004) TrustRAM Offset */
#define TRAM_RAM1005_REG_OFST          _UINT32_(0x1FB4)    /* (TRAM_RAM1005) TrustRAM Offset */
#define TRAM_RAM1006_REG_OFST          _UINT32_(0x1FB8)    /* (TRAM_RAM1006) TrustRAM Offset */
#define TRAM_RAM1007_REG_OFST          _UINT32_(0x1FBC)    /* (TRAM_RAM1007) TrustRAM Offset */
#define TRAM_RAM1008_REG_OFST          _UINT32_(0x1FC0)    /* (TRAM_RAM1008) TrustRAM Offset */
#define TRAM_RAM1009_REG_OFST          _UINT32_(0x1FC4)    /* (TRAM_RAM1009) TrustRAM Offset */
#define TRAM_RAM1010_REG_OFST          _UINT32_(0x1FC8)    /* (TRAM_RAM1010) TrustRAM Offset */
#define TRAM_RAM1011_REG_OFST          _UINT32_(0x1FCC)    /* (TRAM_RAM1011) TrustRAM Offset */
#define TRAM_RAM1012_REG_OFST          _UINT32_(0x1FD0)    /* (TRAM_RAM1012) TrustRAM Offset */
#define TRAM_RAM1013_REG_OFST          _UINT32_(0x1FD4)    /* (TRAM_RAM1013) TrustRAM Offset */
#define TRAM_RAM1014_REG_OFST          _UINT32_(0x1FD8)    /* (TRAM_RAM1014) TrustRAM Offset */
#define TRAM_RAM1015_REG_OFST          _UINT32_(0x1FDC)    /* (TRAM_RAM1015) TrustRAM Offset */
#define TRAM_RAM1016_REG_OFST          _UINT32_(0x1FE0)    /* (TRAM_RAM1016) TrustRAM Offset */
#define TRAM_RAM1017_REG_OFST          _UINT32_(0x1FE4)    /* (TRAM_RAM1017) TrustRAM Offset */
#define TRAM_RAM1018_REG_OFST          _UINT32_(0x1FE8)    /* (TRAM_RAM1018) TrustRAM Offset */
#define TRAM_RAM1019_REG_OFST          _UINT32_(0x1FEC)    /* (TRAM_RAM1019) TrustRAM Offset */
#define TRAM_RAM1020_REG_OFST          _UINT32_(0x1FF0)    /* (TRAM_RAM1020) TrustRAM Offset */
#define TRAM_RAM1021_REG_OFST          _UINT32_(0x1FF4)    /* (TRAM_RAM1021) TrustRAM Offset */
#define TRAM_RAM1022_REG_OFST          _UINT32_(0x1FF8)    /* (TRAM_RAM1022) TrustRAM Offset */
#define TRAM_RAM1023_REG_OFST          _UINT32_(0x1FFC)    /* (TRAM_RAM1023) TrustRAM Offset */
#define TRAM_RAM1024_REG_OFST          _UINT32_(0x2000)    /* (TRAM_RAM1024) TrustRAM Offset */
#define TRAM_RAM1025_REG_OFST          _UINT32_(0x2004)    /* (TRAM_RAM1025) TrustRAM Offset */
#define TRAM_RAM1026_REG_OFST          _UINT32_(0x2008)    /* (TRAM_RAM1026) TrustRAM Offset */
#define TRAM_RAM1027_REG_OFST          _UINT32_(0x200C)    /* (TRAM_RAM1027) TrustRAM Offset */
#define TRAM_RAM1028_REG_OFST          _UINT32_(0x2010)    /* (TRAM_RAM1028) TrustRAM Offset */
#define TRAM_RAM1029_REG_OFST          _UINT32_(0x2014)    /* (TRAM_RAM1029) TrustRAM Offset */
#define TRAM_RAM1030_REG_OFST          _UINT32_(0x2018)    /* (TRAM_RAM1030) TrustRAM Offset */
#define TRAM_RAM1031_REG_OFST          _UINT32_(0x201C)    /* (TRAM_RAM1031) TrustRAM Offset */
#define TRAM_RAM1032_REG_OFST          _UINT32_(0x2020)    /* (TRAM_RAM1032) TrustRAM Offset */
#define TRAM_RAM1033_REG_OFST          _UINT32_(0x2024)    /* (TRAM_RAM1033) TrustRAM Offset */
#define TRAM_RAM1034_REG_OFST          _UINT32_(0x2028)    /* (TRAM_RAM1034) TrustRAM Offset */
#define TRAM_RAM1035_REG_OFST          _UINT32_(0x202C)    /* (TRAM_RAM1035) TrustRAM Offset */
#define TRAM_RAM1036_REG_OFST          _UINT32_(0x2030)    /* (TRAM_RAM1036) TrustRAM Offset */
#define TRAM_RAM1037_REG_OFST          _UINT32_(0x2034)    /* (TRAM_RAM1037) TrustRAM Offset */
#define TRAM_RAM1038_REG_OFST          _UINT32_(0x2038)    /* (TRAM_RAM1038) TrustRAM Offset */
#define TRAM_RAM1039_REG_OFST          _UINT32_(0x203C)    /* (TRAM_RAM1039) TrustRAM Offset */
#define TRAM_RAM1040_REG_OFST          _UINT32_(0x2040)    /* (TRAM_RAM1040) TrustRAM Offset */
#define TRAM_RAM1041_REG_OFST          _UINT32_(0x2044)    /* (TRAM_RAM1041) TrustRAM Offset */
#define TRAM_RAM1042_REG_OFST          _UINT32_(0x2048)    /* (TRAM_RAM1042) TrustRAM Offset */
#define TRAM_RAM1043_REG_OFST          _UINT32_(0x204C)    /* (TRAM_RAM1043) TrustRAM Offset */
#define TRAM_RAM1044_REG_OFST          _UINT32_(0x2050)    /* (TRAM_RAM1044) TrustRAM Offset */
#define TRAM_RAM1045_REG_OFST          _UINT32_(0x2054)    /* (TRAM_RAM1045) TrustRAM Offset */
#define TRAM_RAM1046_REG_OFST          _UINT32_(0x2058)    /* (TRAM_RAM1046) TrustRAM Offset */
#define TRAM_RAM1047_REG_OFST          _UINT32_(0x205C)    /* (TRAM_RAM1047) TrustRAM Offset */
#define TRAM_RAM1048_REG_OFST          _UINT32_(0x2060)    /* (TRAM_RAM1048) TrustRAM Offset */
#define TRAM_RAM1049_REG_OFST          _UINT32_(0x2064)    /* (TRAM_RAM1049) TrustRAM Offset */
#define TRAM_RAM1050_REG_OFST          _UINT32_(0x2068)    /* (TRAM_RAM1050) TrustRAM Offset */
#define TRAM_RAM1051_REG_OFST          _UINT32_(0x206C)    /* (TRAM_RAM1051) TrustRAM Offset */
#define TRAM_RAM1052_REG_OFST          _UINT32_(0x2070)    /* (TRAM_RAM1052) TrustRAM Offset */
#define TRAM_RAM1053_REG_OFST          _UINT32_(0x2074)    /* (TRAM_RAM1053) TrustRAM Offset */
#define TRAM_RAM1054_REG_OFST          _UINT32_(0x2078)    /* (TRAM_RAM1054) TrustRAM Offset */
#define TRAM_RAM1055_REG_OFST          _UINT32_(0x207C)    /* (TRAM_RAM1055) TrustRAM Offset */
#define TRAM_RAM1056_REG_OFST          _UINT32_(0x2080)    /* (TRAM_RAM1056) TrustRAM Offset */
#define TRAM_RAM1057_REG_OFST          _UINT32_(0x2084)    /* (TRAM_RAM1057) TrustRAM Offset */
#define TRAM_RAM1058_REG_OFST          _UINT32_(0x2088)    /* (TRAM_RAM1058) TrustRAM Offset */
#define TRAM_RAM1059_REG_OFST          _UINT32_(0x208C)    /* (TRAM_RAM1059) TrustRAM Offset */
#define TRAM_RAM1060_REG_OFST          _UINT32_(0x2090)    /* (TRAM_RAM1060) TrustRAM Offset */
#define TRAM_RAM1061_REG_OFST          _UINT32_(0x2094)    /* (TRAM_RAM1061) TrustRAM Offset */
#define TRAM_RAM1062_REG_OFST          _UINT32_(0x2098)    /* (TRAM_RAM1062) TrustRAM Offset */
#define TRAM_RAM1063_REG_OFST          _UINT32_(0x209C)    /* (TRAM_RAM1063) TrustRAM Offset */
#define TRAM_RAM1064_REG_OFST          _UINT32_(0x20A0)    /* (TRAM_RAM1064) TrustRAM Offset */
#define TRAM_RAM1065_REG_OFST          _UINT32_(0x20A4)    /* (TRAM_RAM1065) TrustRAM Offset */
#define TRAM_RAM1066_REG_OFST          _UINT32_(0x20A8)    /* (TRAM_RAM1066) TrustRAM Offset */
#define TRAM_RAM1067_REG_OFST          _UINT32_(0x20AC)    /* (TRAM_RAM1067) TrustRAM Offset */
#define TRAM_RAM1068_REG_OFST          _UINT32_(0x20B0)    /* (TRAM_RAM1068) TrustRAM Offset */
#define TRAM_RAM1069_REG_OFST          _UINT32_(0x20B4)    /* (TRAM_RAM1069) TrustRAM Offset */
#define TRAM_RAM1070_REG_OFST          _UINT32_(0x20B8)    /* (TRAM_RAM1070) TrustRAM Offset */
#define TRAM_RAM1071_REG_OFST          _UINT32_(0x20BC)    /* (TRAM_RAM1071) TrustRAM Offset */
#define TRAM_RAM1072_REG_OFST          _UINT32_(0x20C0)    /* (TRAM_RAM1072) TrustRAM Offset */
#define TRAM_RAM1073_REG_OFST          _UINT32_(0x20C4)    /* (TRAM_RAM1073) TrustRAM Offset */
#define TRAM_RAM1074_REG_OFST          _UINT32_(0x20C8)    /* (TRAM_RAM1074) TrustRAM Offset */
#define TRAM_RAM1075_REG_OFST          _UINT32_(0x20CC)    /* (TRAM_RAM1075) TrustRAM Offset */
#define TRAM_RAM1076_REG_OFST          _UINT32_(0x20D0)    /* (TRAM_RAM1076) TrustRAM Offset */
#define TRAM_RAM1077_REG_OFST          _UINT32_(0x20D4)    /* (TRAM_RAM1077) TrustRAM Offset */
#define TRAM_RAM1078_REG_OFST          _UINT32_(0x20D8)    /* (TRAM_RAM1078) TrustRAM Offset */
#define TRAM_RAM1079_REG_OFST          _UINT32_(0x20DC)    /* (TRAM_RAM1079) TrustRAM Offset */
#define TRAM_RAM1080_REG_OFST          _UINT32_(0x20E0)    /* (TRAM_RAM1080) TrustRAM Offset */
#define TRAM_RAM1081_REG_OFST          _UINT32_(0x20E4)    /* (TRAM_RAM1081) TrustRAM Offset */
#define TRAM_RAM1082_REG_OFST          _UINT32_(0x20E8)    /* (TRAM_RAM1082) TrustRAM Offset */
#define TRAM_RAM1083_REG_OFST          _UINT32_(0x20EC)    /* (TRAM_RAM1083) TrustRAM Offset */
#define TRAM_RAM1084_REG_OFST          _UINT32_(0x20F0)    /* (TRAM_RAM1084) TrustRAM Offset */
#define TRAM_RAM1085_REG_OFST          _UINT32_(0x20F4)    /* (TRAM_RAM1085) TrustRAM Offset */
#define TRAM_RAM1086_REG_OFST          _UINT32_(0x20F8)    /* (TRAM_RAM1086) TrustRAM Offset */
#define TRAM_RAM1087_REG_OFST          _UINT32_(0x20FC)    /* (TRAM_RAM1087) TrustRAM Offset */
#define TRAM_RAM1088_REG_OFST          _UINT32_(0x2100)    /* (TRAM_RAM1088) TrustRAM Offset */
#define TRAM_RAM1089_REG_OFST          _UINT32_(0x2104)    /* (TRAM_RAM1089) TrustRAM Offset */
#define TRAM_RAM1090_REG_OFST          _UINT32_(0x2108)    /* (TRAM_RAM1090) TrustRAM Offset */
#define TRAM_RAM1091_REG_OFST          _UINT32_(0x210C)    /* (TRAM_RAM1091) TrustRAM Offset */
#define TRAM_RAM1092_REG_OFST          _UINT32_(0x2110)    /* (TRAM_RAM1092) TrustRAM Offset */
#define TRAM_RAM1093_REG_OFST          _UINT32_(0x2114)    /* (TRAM_RAM1093) TrustRAM Offset */
#define TRAM_RAM1094_REG_OFST          _UINT32_(0x2118)    /* (TRAM_RAM1094) TrustRAM Offset */
#define TRAM_RAM1095_REG_OFST          _UINT32_(0x211C)    /* (TRAM_RAM1095) TrustRAM Offset */
#define TRAM_RAM1096_REG_OFST          _UINT32_(0x2120)    /* (TRAM_RAM1096) TrustRAM Offset */
#define TRAM_RAM1097_REG_OFST          _UINT32_(0x2124)    /* (TRAM_RAM1097) TrustRAM Offset */
#define TRAM_RAM1098_REG_OFST          _UINT32_(0x2128)    /* (TRAM_RAM1098) TrustRAM Offset */
#define TRAM_RAM1099_REG_OFST          _UINT32_(0x212C)    /* (TRAM_RAM1099) TrustRAM Offset */
#define TRAM_RAM1100_REG_OFST          _UINT32_(0x2130)    /* (TRAM_RAM1100) TrustRAM Offset */
#define TRAM_RAM1101_REG_OFST          _UINT32_(0x2134)    /* (TRAM_RAM1101) TrustRAM Offset */
#define TRAM_RAM1102_REG_OFST          _UINT32_(0x2138)    /* (TRAM_RAM1102) TrustRAM Offset */
#define TRAM_RAM1103_REG_OFST          _UINT32_(0x213C)    /* (TRAM_RAM1103) TrustRAM Offset */
#define TRAM_RAM1104_REG_OFST          _UINT32_(0x2140)    /* (TRAM_RAM1104) TrustRAM Offset */
#define TRAM_RAM1105_REG_OFST          _UINT32_(0x2144)    /* (TRAM_RAM1105) TrustRAM Offset */
#define TRAM_RAM1106_REG_OFST          _UINT32_(0x2148)    /* (TRAM_RAM1106) TrustRAM Offset */
#define TRAM_RAM1107_REG_OFST          _UINT32_(0x214C)    /* (TRAM_RAM1107) TrustRAM Offset */
#define TRAM_RAM1108_REG_OFST          _UINT32_(0x2150)    /* (TRAM_RAM1108) TrustRAM Offset */
#define TRAM_RAM1109_REG_OFST          _UINT32_(0x2154)    /* (TRAM_RAM1109) TrustRAM Offset */
#define TRAM_RAM1110_REG_OFST          _UINT32_(0x2158)    /* (TRAM_RAM1110) TrustRAM Offset */
#define TRAM_RAM1111_REG_OFST          _UINT32_(0x215C)    /* (TRAM_RAM1111) TrustRAM Offset */
#define TRAM_RAM1112_REG_OFST          _UINT32_(0x2160)    /* (TRAM_RAM1112) TrustRAM Offset */
#define TRAM_RAM1113_REG_OFST          _UINT32_(0x2164)    /* (TRAM_RAM1113) TrustRAM Offset */
#define TRAM_RAM1114_REG_OFST          _UINT32_(0x2168)    /* (TRAM_RAM1114) TrustRAM Offset */
#define TRAM_RAM1115_REG_OFST          _UINT32_(0x216C)    /* (TRAM_RAM1115) TrustRAM Offset */
#define TRAM_RAM1116_REG_OFST          _UINT32_(0x2170)    /* (TRAM_RAM1116) TrustRAM Offset */
#define TRAM_RAM1117_REG_OFST          _UINT32_(0x2174)    /* (TRAM_RAM1117) TrustRAM Offset */
#define TRAM_RAM1118_REG_OFST          _UINT32_(0x2178)    /* (TRAM_RAM1118) TrustRAM Offset */
#define TRAM_RAM1119_REG_OFST          _UINT32_(0x217C)    /* (TRAM_RAM1119) TrustRAM Offset */
#define TRAM_RAM1120_REG_OFST          _UINT32_(0x2180)    /* (TRAM_RAM1120) TrustRAM Offset */
#define TRAM_RAM1121_REG_OFST          _UINT32_(0x2184)    /* (TRAM_RAM1121) TrustRAM Offset */
#define TRAM_RAM1122_REG_OFST          _UINT32_(0x2188)    /* (TRAM_RAM1122) TrustRAM Offset */
#define TRAM_RAM1123_REG_OFST          _UINT32_(0x218C)    /* (TRAM_RAM1123) TrustRAM Offset */
#define TRAM_RAM1124_REG_OFST          _UINT32_(0x2190)    /* (TRAM_RAM1124) TrustRAM Offset */
#define TRAM_RAM1125_REG_OFST          _UINT32_(0x2194)    /* (TRAM_RAM1125) TrustRAM Offset */
#define TRAM_RAM1126_REG_OFST          _UINT32_(0x2198)    /* (TRAM_RAM1126) TrustRAM Offset */
#define TRAM_RAM1127_REG_OFST          _UINT32_(0x219C)    /* (TRAM_RAM1127) TrustRAM Offset */
#define TRAM_RAM1128_REG_OFST          _UINT32_(0x21A0)    /* (TRAM_RAM1128) TrustRAM Offset */
#define TRAM_RAM1129_REG_OFST          _UINT32_(0x21A4)    /* (TRAM_RAM1129) TrustRAM Offset */
#define TRAM_RAM1130_REG_OFST          _UINT32_(0x21A8)    /* (TRAM_RAM1130) TrustRAM Offset */
#define TRAM_RAM1131_REG_OFST          _UINT32_(0x21AC)    /* (TRAM_RAM1131) TrustRAM Offset */
#define TRAM_RAM1132_REG_OFST          _UINT32_(0x21B0)    /* (TRAM_RAM1132) TrustRAM Offset */
#define TRAM_RAM1133_REG_OFST          _UINT32_(0x21B4)    /* (TRAM_RAM1133) TrustRAM Offset */
#define TRAM_RAM1134_REG_OFST          _UINT32_(0x21B8)    /* (TRAM_RAM1134) TrustRAM Offset */
#define TRAM_RAM1135_REG_OFST          _UINT32_(0x21BC)    /* (TRAM_RAM1135) TrustRAM Offset */
#define TRAM_RAM1136_REG_OFST          _UINT32_(0x21C0)    /* (TRAM_RAM1136) TrustRAM Offset */
#define TRAM_RAM1137_REG_OFST          _UINT32_(0x21C4)    /* (TRAM_RAM1137) TrustRAM Offset */
#define TRAM_RAM1138_REG_OFST          _UINT32_(0x21C8)    /* (TRAM_RAM1138) TrustRAM Offset */
#define TRAM_RAM1139_REG_OFST          _UINT32_(0x21CC)    /* (TRAM_RAM1139) TrustRAM Offset */
#define TRAM_RAM1140_REG_OFST          _UINT32_(0x21D0)    /* (TRAM_RAM1140) TrustRAM Offset */
#define TRAM_RAM1141_REG_OFST          _UINT32_(0x21D4)    /* (TRAM_RAM1141) TrustRAM Offset */
#define TRAM_RAM1142_REG_OFST          _UINT32_(0x21D8)    /* (TRAM_RAM1142) TrustRAM Offset */
#define TRAM_RAM1143_REG_OFST          _UINT32_(0x21DC)    /* (TRAM_RAM1143) TrustRAM Offset */
#define TRAM_RAM1144_REG_OFST          _UINT32_(0x21E0)    /* (TRAM_RAM1144) TrustRAM Offset */
#define TRAM_RAM1145_REG_OFST          _UINT32_(0x21E4)    /* (TRAM_RAM1145) TrustRAM Offset */
#define TRAM_RAM1146_REG_OFST          _UINT32_(0x21E8)    /* (TRAM_RAM1146) TrustRAM Offset */
#define TRAM_RAM1147_REG_OFST          _UINT32_(0x21EC)    /* (TRAM_RAM1147) TrustRAM Offset */
#define TRAM_RAM1148_REG_OFST          _UINT32_(0x21F0)    /* (TRAM_RAM1148) TrustRAM Offset */
#define TRAM_RAM1149_REG_OFST          _UINT32_(0x21F4)    /* (TRAM_RAM1149) TrustRAM Offset */
#define TRAM_RAM1150_REG_OFST          _UINT32_(0x21F8)    /* (TRAM_RAM1150) TrustRAM Offset */
#define TRAM_RAM1151_REG_OFST          _UINT32_(0x21FC)    /* (TRAM_RAM1151) TrustRAM Offset */
#define TRAM_RAM1152_REG_OFST          _UINT32_(0x2200)    /* (TRAM_RAM1152) TrustRAM Offset */
#define TRAM_RAM1153_REG_OFST          _UINT32_(0x2204)    /* (TRAM_RAM1153) TrustRAM Offset */
#define TRAM_RAM1154_REG_OFST          _UINT32_(0x2208)    /* (TRAM_RAM1154) TrustRAM Offset */
#define TRAM_RAM1155_REG_OFST          _UINT32_(0x220C)    /* (TRAM_RAM1155) TrustRAM Offset */
#define TRAM_RAM1156_REG_OFST          _UINT32_(0x2210)    /* (TRAM_RAM1156) TrustRAM Offset */
#define TRAM_RAM1157_REG_OFST          _UINT32_(0x2214)    /* (TRAM_RAM1157) TrustRAM Offset */
#define TRAM_RAM1158_REG_OFST          _UINT32_(0x2218)    /* (TRAM_RAM1158) TrustRAM Offset */
#define TRAM_RAM1159_REG_OFST          _UINT32_(0x221C)    /* (TRAM_RAM1159) TrustRAM Offset */
#define TRAM_RAM1160_REG_OFST          _UINT32_(0x2220)    /* (TRAM_RAM1160) TrustRAM Offset */
#define TRAM_RAM1161_REG_OFST          _UINT32_(0x2224)    /* (TRAM_RAM1161) TrustRAM Offset */
#define TRAM_RAM1162_REG_OFST          _UINT32_(0x2228)    /* (TRAM_RAM1162) TrustRAM Offset */
#define TRAM_RAM1163_REG_OFST          _UINT32_(0x222C)    /* (TRAM_RAM1163) TrustRAM Offset */
#define TRAM_RAM1164_REG_OFST          _UINT32_(0x2230)    /* (TRAM_RAM1164) TrustRAM Offset */
#define TRAM_RAM1165_REG_OFST          _UINT32_(0x2234)    /* (TRAM_RAM1165) TrustRAM Offset */
#define TRAM_RAM1166_REG_OFST          _UINT32_(0x2238)    /* (TRAM_RAM1166) TrustRAM Offset */
#define TRAM_RAM1167_REG_OFST          _UINT32_(0x223C)    /* (TRAM_RAM1167) TrustRAM Offset */
#define TRAM_RAM1168_REG_OFST          _UINT32_(0x2240)    /* (TRAM_RAM1168) TrustRAM Offset */
#define TRAM_RAM1169_REG_OFST          _UINT32_(0x2244)    /* (TRAM_RAM1169) TrustRAM Offset */
#define TRAM_RAM1170_REG_OFST          _UINT32_(0x2248)    /* (TRAM_RAM1170) TrustRAM Offset */
#define TRAM_RAM1171_REG_OFST          _UINT32_(0x224C)    /* (TRAM_RAM1171) TrustRAM Offset */
#define TRAM_RAM1172_REG_OFST          _UINT32_(0x2250)    /* (TRAM_RAM1172) TrustRAM Offset */
#define TRAM_RAM1173_REG_OFST          _UINT32_(0x2254)    /* (TRAM_RAM1173) TrustRAM Offset */
#define TRAM_RAM1174_REG_OFST          _UINT32_(0x2258)    /* (TRAM_RAM1174) TrustRAM Offset */
#define TRAM_RAM1175_REG_OFST          _UINT32_(0x225C)    /* (TRAM_RAM1175) TrustRAM Offset */
#define TRAM_RAM1176_REG_OFST          _UINT32_(0x2260)    /* (TRAM_RAM1176) TrustRAM Offset */
#define TRAM_RAM1177_REG_OFST          _UINT32_(0x2264)    /* (TRAM_RAM1177) TrustRAM Offset */
#define TRAM_RAM1178_REG_OFST          _UINT32_(0x2268)    /* (TRAM_RAM1178) TrustRAM Offset */
#define TRAM_RAM1179_REG_OFST          _UINT32_(0x226C)    /* (TRAM_RAM1179) TrustRAM Offset */
#define TRAM_RAM1180_REG_OFST          _UINT32_(0x2270)    /* (TRAM_RAM1180) TrustRAM Offset */
#define TRAM_RAM1181_REG_OFST          _UINT32_(0x2274)    /* (TRAM_RAM1181) TrustRAM Offset */
#define TRAM_RAM1182_REG_OFST          _UINT32_(0x2278)    /* (TRAM_RAM1182) TrustRAM Offset */
#define TRAM_RAM1183_REG_OFST          _UINT32_(0x227C)    /* (TRAM_RAM1183) TrustRAM Offset */
#define TRAM_RAM1184_REG_OFST          _UINT32_(0x2280)    /* (TRAM_RAM1184) TrustRAM Offset */
#define TRAM_RAM1185_REG_OFST          _UINT32_(0x2284)    /* (TRAM_RAM1185) TrustRAM Offset */
#define TRAM_RAM1186_REG_OFST          _UINT32_(0x2288)    /* (TRAM_RAM1186) TrustRAM Offset */
#define TRAM_RAM1187_REG_OFST          _UINT32_(0x228C)    /* (TRAM_RAM1187) TrustRAM Offset */
#define TRAM_RAM1188_REG_OFST          _UINT32_(0x2290)    /* (TRAM_RAM1188) TrustRAM Offset */
#define TRAM_RAM1189_REG_OFST          _UINT32_(0x2294)    /* (TRAM_RAM1189) TrustRAM Offset */
#define TRAM_RAM1190_REG_OFST          _UINT32_(0x2298)    /* (TRAM_RAM1190) TrustRAM Offset */
#define TRAM_RAM1191_REG_OFST          _UINT32_(0x229C)    /* (TRAM_RAM1191) TrustRAM Offset */
#define TRAM_RAM1192_REG_OFST          _UINT32_(0x22A0)    /* (TRAM_RAM1192) TrustRAM Offset */
#define TRAM_RAM1193_REG_OFST          _UINT32_(0x22A4)    /* (TRAM_RAM1193) TrustRAM Offset */
#define TRAM_RAM1194_REG_OFST          _UINT32_(0x22A8)    /* (TRAM_RAM1194) TrustRAM Offset */
#define TRAM_RAM1195_REG_OFST          _UINT32_(0x22AC)    /* (TRAM_RAM1195) TrustRAM Offset */
#define TRAM_RAM1196_REG_OFST          _UINT32_(0x22B0)    /* (TRAM_RAM1196) TrustRAM Offset */
#define TRAM_RAM1197_REG_OFST          _UINT32_(0x22B4)    /* (TRAM_RAM1197) TrustRAM Offset */
#define TRAM_RAM1198_REG_OFST          _UINT32_(0x22B8)    /* (TRAM_RAM1198) TrustRAM Offset */
#define TRAM_RAM1199_REG_OFST          _UINT32_(0x22BC)    /* (TRAM_RAM1199) TrustRAM Offset */
#define TRAM_RAM1200_REG_OFST          _UINT32_(0x22C0)    /* (TRAM_RAM1200) TrustRAM Offset */
#define TRAM_RAM1201_REG_OFST          _UINT32_(0x22C4)    /* (TRAM_RAM1201) TrustRAM Offset */
#define TRAM_RAM1202_REG_OFST          _UINT32_(0x22C8)    /* (TRAM_RAM1202) TrustRAM Offset */
#define TRAM_RAM1203_REG_OFST          _UINT32_(0x22CC)    /* (TRAM_RAM1203) TrustRAM Offset */
#define TRAM_RAM1204_REG_OFST          _UINT32_(0x22D0)    /* (TRAM_RAM1204) TrustRAM Offset */
#define TRAM_RAM1205_REG_OFST          _UINT32_(0x22D4)    /* (TRAM_RAM1205) TrustRAM Offset */
#define TRAM_RAM1206_REG_OFST          _UINT32_(0x22D8)    /* (TRAM_RAM1206) TrustRAM Offset */
#define TRAM_RAM1207_REG_OFST          _UINT32_(0x22DC)    /* (TRAM_RAM1207) TrustRAM Offset */
#define TRAM_RAM1208_REG_OFST          _UINT32_(0x22E0)    /* (TRAM_RAM1208) TrustRAM Offset */
#define TRAM_RAM1209_REG_OFST          _UINT32_(0x22E4)    /* (TRAM_RAM1209) TrustRAM Offset */
#define TRAM_RAM1210_REG_OFST          _UINT32_(0x22E8)    /* (TRAM_RAM1210) TrustRAM Offset */
#define TRAM_RAM1211_REG_OFST          _UINT32_(0x22EC)    /* (TRAM_RAM1211) TrustRAM Offset */
#define TRAM_RAM1212_REG_OFST          _UINT32_(0x22F0)    /* (TRAM_RAM1212) TrustRAM Offset */
#define TRAM_RAM1213_REG_OFST          _UINT32_(0x22F4)    /* (TRAM_RAM1213) TrustRAM Offset */
#define TRAM_RAM1214_REG_OFST          _UINT32_(0x22F8)    /* (TRAM_RAM1214) TrustRAM Offset */
#define TRAM_RAM1215_REG_OFST          _UINT32_(0x22FC)    /* (TRAM_RAM1215) TrustRAM Offset */
#define TRAM_RAM1216_REG_OFST          _UINT32_(0x2300)    /* (TRAM_RAM1216) TrustRAM Offset */
#define TRAM_RAM1217_REG_OFST          _UINT32_(0x2304)    /* (TRAM_RAM1217) TrustRAM Offset */
#define TRAM_RAM1218_REG_OFST          _UINT32_(0x2308)    /* (TRAM_RAM1218) TrustRAM Offset */
#define TRAM_RAM1219_REG_OFST          _UINT32_(0x230C)    /* (TRAM_RAM1219) TrustRAM Offset */
#define TRAM_RAM1220_REG_OFST          _UINT32_(0x2310)    /* (TRAM_RAM1220) TrustRAM Offset */
#define TRAM_RAM1221_REG_OFST          _UINT32_(0x2314)    /* (TRAM_RAM1221) TrustRAM Offset */
#define TRAM_RAM1222_REG_OFST          _UINT32_(0x2318)    /* (TRAM_RAM1222) TrustRAM Offset */
#define TRAM_RAM1223_REG_OFST          _UINT32_(0x231C)    /* (TRAM_RAM1223) TrustRAM Offset */
#define TRAM_RAM1224_REG_OFST          _UINT32_(0x2320)    /* (TRAM_RAM1224) TrustRAM Offset */
#define TRAM_RAM1225_REG_OFST          _UINT32_(0x2324)    /* (TRAM_RAM1225) TrustRAM Offset */
#define TRAM_RAM1226_REG_OFST          _UINT32_(0x2328)    /* (TRAM_RAM1226) TrustRAM Offset */
#define TRAM_RAM1227_REG_OFST          _UINT32_(0x232C)    /* (TRAM_RAM1227) TrustRAM Offset */
#define TRAM_RAM1228_REG_OFST          _UINT32_(0x2330)    /* (TRAM_RAM1228) TrustRAM Offset */
#define TRAM_RAM1229_REG_OFST          _UINT32_(0x2334)    /* (TRAM_RAM1229) TrustRAM Offset */
#define TRAM_RAM1230_REG_OFST          _UINT32_(0x2338)    /* (TRAM_RAM1230) TrustRAM Offset */
#define TRAM_RAM1231_REG_OFST          _UINT32_(0x233C)    /* (TRAM_RAM1231) TrustRAM Offset */
#define TRAM_RAM1232_REG_OFST          _UINT32_(0x2340)    /* (TRAM_RAM1232) TrustRAM Offset */
#define TRAM_RAM1233_REG_OFST          _UINT32_(0x2344)    /* (TRAM_RAM1233) TrustRAM Offset */
#define TRAM_RAM1234_REG_OFST          _UINT32_(0x2348)    /* (TRAM_RAM1234) TrustRAM Offset */
#define TRAM_RAM1235_REG_OFST          _UINT32_(0x234C)    /* (TRAM_RAM1235) TrustRAM Offset */
#define TRAM_RAM1236_REG_OFST          _UINT32_(0x2350)    /* (TRAM_RAM1236) TrustRAM Offset */
#define TRAM_RAM1237_REG_OFST          _UINT32_(0x2354)    /* (TRAM_RAM1237) TrustRAM Offset */
#define TRAM_RAM1238_REG_OFST          _UINT32_(0x2358)    /* (TRAM_RAM1238) TrustRAM Offset */
#define TRAM_RAM1239_REG_OFST          _UINT32_(0x235C)    /* (TRAM_RAM1239) TrustRAM Offset */
#define TRAM_RAM1240_REG_OFST          _UINT32_(0x2360)    /* (TRAM_RAM1240) TrustRAM Offset */
#define TRAM_RAM1241_REG_OFST          _UINT32_(0x2364)    /* (TRAM_RAM1241) TrustRAM Offset */
#define TRAM_RAM1242_REG_OFST          _UINT32_(0x2368)    /* (TRAM_RAM1242) TrustRAM Offset */
#define TRAM_RAM1243_REG_OFST          _UINT32_(0x236C)    /* (TRAM_RAM1243) TrustRAM Offset */
#define TRAM_RAM1244_REG_OFST          _UINT32_(0x2370)    /* (TRAM_RAM1244) TrustRAM Offset */
#define TRAM_RAM1245_REG_OFST          _UINT32_(0x2374)    /* (TRAM_RAM1245) TrustRAM Offset */
#define TRAM_RAM1246_REG_OFST          _UINT32_(0x2378)    /* (TRAM_RAM1246) TrustRAM Offset */
#define TRAM_RAM1247_REG_OFST          _UINT32_(0x237C)    /* (TRAM_RAM1247) TrustRAM Offset */
#define TRAM_RAM1248_REG_OFST          _UINT32_(0x2380)    /* (TRAM_RAM1248) TrustRAM Offset */
#define TRAM_RAM1249_REG_OFST          _UINT32_(0x2384)    /* (TRAM_RAM1249) TrustRAM Offset */
#define TRAM_RAM1250_REG_OFST          _UINT32_(0x2388)    /* (TRAM_RAM1250) TrustRAM Offset */
#define TRAM_RAM1251_REG_OFST          _UINT32_(0x238C)    /* (TRAM_RAM1251) TrustRAM Offset */
#define TRAM_RAM1252_REG_OFST          _UINT32_(0x2390)    /* (TRAM_RAM1252) TrustRAM Offset */
#define TRAM_RAM1253_REG_OFST          _UINT32_(0x2394)    /* (TRAM_RAM1253) TrustRAM Offset */
#define TRAM_RAM1254_REG_OFST          _UINT32_(0x2398)    /* (TRAM_RAM1254) TrustRAM Offset */
#define TRAM_RAM1255_REG_OFST          _UINT32_(0x239C)    /* (TRAM_RAM1255) TrustRAM Offset */
#define TRAM_RAM1256_REG_OFST          _UINT32_(0x23A0)    /* (TRAM_RAM1256) TrustRAM Offset */
#define TRAM_RAM1257_REG_OFST          _UINT32_(0x23A4)    /* (TRAM_RAM1257) TrustRAM Offset */
#define TRAM_RAM1258_REG_OFST          _UINT32_(0x23A8)    /* (TRAM_RAM1258) TrustRAM Offset */
#define TRAM_RAM1259_REG_OFST          _UINT32_(0x23AC)    /* (TRAM_RAM1259) TrustRAM Offset */
#define TRAM_RAM1260_REG_OFST          _UINT32_(0x23B0)    /* (TRAM_RAM1260) TrustRAM Offset */
#define TRAM_RAM1261_REG_OFST          _UINT32_(0x23B4)    /* (TRAM_RAM1261) TrustRAM Offset */
#define TRAM_RAM1262_REG_OFST          _UINT32_(0x23B8)    /* (TRAM_RAM1262) TrustRAM Offset */
#define TRAM_RAM1263_REG_OFST          _UINT32_(0x23BC)    /* (TRAM_RAM1263) TrustRAM Offset */
#define TRAM_RAM1264_REG_OFST          _UINT32_(0x23C0)    /* (TRAM_RAM1264) TrustRAM Offset */
#define TRAM_RAM1265_REG_OFST          _UINT32_(0x23C4)    /* (TRAM_RAM1265) TrustRAM Offset */
#define TRAM_RAM1266_REG_OFST          _UINT32_(0x23C8)    /* (TRAM_RAM1266) TrustRAM Offset */
#define TRAM_RAM1267_REG_OFST          _UINT32_(0x23CC)    /* (TRAM_RAM1267) TrustRAM Offset */
#define TRAM_RAM1268_REG_OFST          _UINT32_(0x23D0)    /* (TRAM_RAM1268) TrustRAM Offset */
#define TRAM_RAM1269_REG_OFST          _UINT32_(0x23D4)    /* (TRAM_RAM1269) TrustRAM Offset */
#define TRAM_RAM1270_REG_OFST          _UINT32_(0x23D8)    /* (TRAM_RAM1270) TrustRAM Offset */
#define TRAM_RAM1271_REG_OFST          _UINT32_(0x23DC)    /* (TRAM_RAM1271) TrustRAM Offset */
#define TRAM_RAM1272_REG_OFST          _UINT32_(0x23E0)    /* (TRAM_RAM1272) TrustRAM Offset */
#define TRAM_RAM1273_REG_OFST          _UINT32_(0x23E4)    /* (TRAM_RAM1273) TrustRAM Offset */
#define TRAM_RAM1274_REG_OFST          _UINT32_(0x23E8)    /* (TRAM_RAM1274) TrustRAM Offset */
#define TRAM_RAM1275_REG_OFST          _UINT32_(0x23EC)    /* (TRAM_RAM1275) TrustRAM Offset */
#define TRAM_RAM1276_REG_OFST          _UINT32_(0x23F0)    /* (TRAM_RAM1276) TrustRAM Offset */
#define TRAM_RAM1277_REG_OFST          _UINT32_(0x23F4)    /* (TRAM_RAM1277) TrustRAM Offset */
#define TRAM_RAM1278_REG_OFST          _UINT32_(0x23F8)    /* (TRAM_RAM1278) TrustRAM Offset */
#define TRAM_RAM1279_REG_OFST          _UINT32_(0x23FC)    /* (TRAM_RAM1279) TrustRAM Offset */
#define TRAM_RAM1280_REG_OFST          _UINT32_(0x2400)    /* (TRAM_RAM1280) TrustRAM Offset */
#define TRAM_RAM1281_REG_OFST          _UINT32_(0x2404)    /* (TRAM_RAM1281) TrustRAM Offset */
#define TRAM_RAM1282_REG_OFST          _UINT32_(0x2408)    /* (TRAM_RAM1282) TrustRAM Offset */
#define TRAM_RAM1283_REG_OFST          _UINT32_(0x240C)    /* (TRAM_RAM1283) TrustRAM Offset */
#define TRAM_RAM1284_REG_OFST          _UINT32_(0x2410)    /* (TRAM_RAM1284) TrustRAM Offset */
#define TRAM_RAM1285_REG_OFST          _UINT32_(0x2414)    /* (TRAM_RAM1285) TrustRAM Offset */
#define TRAM_RAM1286_REG_OFST          _UINT32_(0x2418)    /* (TRAM_RAM1286) TrustRAM Offset */
#define TRAM_RAM1287_REG_OFST          _UINT32_(0x241C)    /* (TRAM_RAM1287) TrustRAM Offset */
#define TRAM_RAM1288_REG_OFST          _UINT32_(0x2420)    /* (TRAM_RAM1288) TrustRAM Offset */
#define TRAM_RAM1289_REG_OFST          _UINT32_(0x2424)    /* (TRAM_RAM1289) TrustRAM Offset */
#define TRAM_RAM1290_REG_OFST          _UINT32_(0x2428)    /* (TRAM_RAM1290) TrustRAM Offset */
#define TRAM_RAM1291_REG_OFST          _UINT32_(0x242C)    /* (TRAM_RAM1291) TrustRAM Offset */
#define TRAM_RAM1292_REG_OFST          _UINT32_(0x2430)    /* (TRAM_RAM1292) TrustRAM Offset */
#define TRAM_RAM1293_REG_OFST          _UINT32_(0x2434)    /* (TRAM_RAM1293) TrustRAM Offset */
#define TRAM_RAM1294_REG_OFST          _UINT32_(0x2438)    /* (TRAM_RAM1294) TrustRAM Offset */
#define TRAM_RAM1295_REG_OFST          _UINT32_(0x243C)    /* (TRAM_RAM1295) TrustRAM Offset */
#define TRAM_RAM1296_REG_OFST          _UINT32_(0x2440)    /* (TRAM_RAM1296) TrustRAM Offset */
#define TRAM_RAM1297_REG_OFST          _UINT32_(0x2444)    /* (TRAM_RAM1297) TrustRAM Offset */
#define TRAM_RAM1298_REG_OFST          _UINT32_(0x2448)    /* (TRAM_RAM1298) TrustRAM Offset */
#define TRAM_RAM1299_REG_OFST          _UINT32_(0x244C)    /* (TRAM_RAM1299) TrustRAM Offset */
#define TRAM_RAM1300_REG_OFST          _UINT32_(0x2450)    /* (TRAM_RAM1300) TrustRAM Offset */
#define TRAM_RAM1301_REG_OFST          _UINT32_(0x2454)    /* (TRAM_RAM1301) TrustRAM Offset */
#define TRAM_RAM1302_REG_OFST          _UINT32_(0x2458)    /* (TRAM_RAM1302) TrustRAM Offset */
#define TRAM_RAM1303_REG_OFST          _UINT32_(0x245C)    /* (TRAM_RAM1303) TrustRAM Offset */
#define TRAM_RAM1304_REG_OFST          _UINT32_(0x2460)    /* (TRAM_RAM1304) TrustRAM Offset */
#define TRAM_RAM1305_REG_OFST          _UINT32_(0x2464)    /* (TRAM_RAM1305) TrustRAM Offset */
#define TRAM_RAM1306_REG_OFST          _UINT32_(0x2468)    /* (TRAM_RAM1306) TrustRAM Offset */
#define TRAM_RAM1307_REG_OFST          _UINT32_(0x246C)    /* (TRAM_RAM1307) TrustRAM Offset */
#define TRAM_RAM1308_REG_OFST          _UINT32_(0x2470)    /* (TRAM_RAM1308) TrustRAM Offset */
#define TRAM_RAM1309_REG_OFST          _UINT32_(0x2474)    /* (TRAM_RAM1309) TrustRAM Offset */
#define TRAM_RAM1310_REG_OFST          _UINT32_(0x2478)    /* (TRAM_RAM1310) TrustRAM Offset */
#define TRAM_RAM1311_REG_OFST          _UINT32_(0x247C)    /* (TRAM_RAM1311) TrustRAM Offset */
#define TRAM_RAM1312_REG_OFST          _UINT32_(0x2480)    /* (TRAM_RAM1312) TrustRAM Offset */
#define TRAM_RAM1313_REG_OFST          _UINT32_(0x2484)    /* (TRAM_RAM1313) TrustRAM Offset */
#define TRAM_RAM1314_REG_OFST          _UINT32_(0x2488)    /* (TRAM_RAM1314) TrustRAM Offset */
#define TRAM_RAM1315_REG_OFST          _UINT32_(0x248C)    /* (TRAM_RAM1315) TrustRAM Offset */
#define TRAM_RAM1316_REG_OFST          _UINT32_(0x2490)    /* (TRAM_RAM1316) TrustRAM Offset */
#define TRAM_RAM1317_REG_OFST          _UINT32_(0x2494)    /* (TRAM_RAM1317) TrustRAM Offset */
#define TRAM_RAM1318_REG_OFST          _UINT32_(0x2498)    /* (TRAM_RAM1318) TrustRAM Offset */
#define TRAM_RAM1319_REG_OFST          _UINT32_(0x249C)    /* (TRAM_RAM1319) TrustRAM Offset */
#define TRAM_RAM1320_REG_OFST          _UINT32_(0x24A0)    /* (TRAM_RAM1320) TrustRAM Offset */
#define TRAM_RAM1321_REG_OFST          _UINT32_(0x24A4)    /* (TRAM_RAM1321) TrustRAM Offset */
#define TRAM_RAM1322_REG_OFST          _UINT32_(0x24A8)    /* (TRAM_RAM1322) TrustRAM Offset */
#define TRAM_RAM1323_REG_OFST          _UINT32_(0x24AC)    /* (TRAM_RAM1323) TrustRAM Offset */
#define TRAM_RAM1324_REG_OFST          _UINT32_(0x24B0)    /* (TRAM_RAM1324) TrustRAM Offset */
#define TRAM_RAM1325_REG_OFST          _UINT32_(0x24B4)    /* (TRAM_RAM1325) TrustRAM Offset */
#define TRAM_RAM1326_REG_OFST          _UINT32_(0x24B8)    /* (TRAM_RAM1326) TrustRAM Offset */
#define TRAM_RAM1327_REG_OFST          _UINT32_(0x24BC)    /* (TRAM_RAM1327) TrustRAM Offset */
#define TRAM_RAM1328_REG_OFST          _UINT32_(0x24C0)    /* (TRAM_RAM1328) TrustRAM Offset */
#define TRAM_RAM1329_REG_OFST          _UINT32_(0x24C4)    /* (TRAM_RAM1329) TrustRAM Offset */
#define TRAM_RAM1330_REG_OFST          _UINT32_(0x24C8)    /* (TRAM_RAM1330) TrustRAM Offset */
#define TRAM_RAM1331_REG_OFST          _UINT32_(0x24CC)    /* (TRAM_RAM1331) TrustRAM Offset */
#define TRAM_RAM1332_REG_OFST          _UINT32_(0x24D0)    /* (TRAM_RAM1332) TrustRAM Offset */
#define TRAM_RAM1333_REG_OFST          _UINT32_(0x24D4)    /* (TRAM_RAM1333) TrustRAM Offset */
#define TRAM_RAM1334_REG_OFST          _UINT32_(0x24D8)    /* (TRAM_RAM1334) TrustRAM Offset */
#define TRAM_RAM1335_REG_OFST          _UINT32_(0x24DC)    /* (TRAM_RAM1335) TrustRAM Offset */
#define TRAM_RAM1336_REG_OFST          _UINT32_(0x24E0)    /* (TRAM_RAM1336) TrustRAM Offset */
#define TRAM_RAM1337_REG_OFST          _UINT32_(0x24E4)    /* (TRAM_RAM1337) TrustRAM Offset */
#define TRAM_RAM1338_REG_OFST          _UINT32_(0x24E8)    /* (TRAM_RAM1338) TrustRAM Offset */
#define TRAM_RAM1339_REG_OFST          _UINT32_(0x24EC)    /* (TRAM_RAM1339) TrustRAM Offset */
#define TRAM_RAM1340_REG_OFST          _UINT32_(0x24F0)    /* (TRAM_RAM1340) TrustRAM Offset */
#define TRAM_RAM1341_REG_OFST          _UINT32_(0x24F4)    /* (TRAM_RAM1341) TrustRAM Offset */
#define TRAM_RAM1342_REG_OFST          _UINT32_(0x24F8)    /* (TRAM_RAM1342) TrustRAM Offset */
#define TRAM_RAM1343_REG_OFST          _UINT32_(0x24FC)    /* (TRAM_RAM1343) TrustRAM Offset */
#define TRAM_RAM1344_REG_OFST          _UINT32_(0x2500)    /* (TRAM_RAM1344) TrustRAM Offset */
#define TRAM_RAM1345_REG_OFST          _UINT32_(0x2504)    /* (TRAM_RAM1345) TrustRAM Offset */
#define TRAM_RAM1346_REG_OFST          _UINT32_(0x2508)    /* (TRAM_RAM1346) TrustRAM Offset */
#define TRAM_RAM1347_REG_OFST          _UINT32_(0x250C)    /* (TRAM_RAM1347) TrustRAM Offset */
#define TRAM_RAM1348_REG_OFST          _UINT32_(0x2510)    /* (TRAM_RAM1348) TrustRAM Offset */
#define TRAM_RAM1349_REG_OFST          _UINT32_(0x2514)    /* (TRAM_RAM1349) TrustRAM Offset */
#define TRAM_RAM1350_REG_OFST          _UINT32_(0x2518)    /* (TRAM_RAM1350) TrustRAM Offset */
#define TRAM_RAM1351_REG_OFST          _UINT32_(0x251C)    /* (TRAM_RAM1351) TrustRAM Offset */
#define TRAM_RAM1352_REG_OFST          _UINT32_(0x2520)    /* (TRAM_RAM1352) TrustRAM Offset */
#define TRAM_RAM1353_REG_OFST          _UINT32_(0x2524)    /* (TRAM_RAM1353) TrustRAM Offset */
#define TRAM_RAM1354_REG_OFST          _UINT32_(0x2528)    /* (TRAM_RAM1354) TrustRAM Offset */
#define TRAM_RAM1355_REG_OFST          _UINT32_(0x252C)    /* (TRAM_RAM1355) TrustRAM Offset */
#define TRAM_RAM1356_REG_OFST          _UINT32_(0x2530)    /* (TRAM_RAM1356) TrustRAM Offset */
#define TRAM_RAM1357_REG_OFST          _UINT32_(0x2534)    /* (TRAM_RAM1357) TrustRAM Offset */
#define TRAM_RAM1358_REG_OFST          _UINT32_(0x2538)    /* (TRAM_RAM1358) TrustRAM Offset */
#define TRAM_RAM1359_REG_OFST          _UINT32_(0x253C)    /* (TRAM_RAM1359) TrustRAM Offset */
#define TRAM_RAM1360_REG_OFST          _UINT32_(0x2540)    /* (TRAM_RAM1360) TrustRAM Offset */
#define TRAM_RAM1361_REG_OFST          _UINT32_(0x2544)    /* (TRAM_RAM1361) TrustRAM Offset */
#define TRAM_RAM1362_REG_OFST          _UINT32_(0x2548)    /* (TRAM_RAM1362) TrustRAM Offset */
#define TRAM_RAM1363_REG_OFST          _UINT32_(0x254C)    /* (TRAM_RAM1363) TrustRAM Offset */
#define TRAM_RAM1364_REG_OFST          _UINT32_(0x2550)    /* (TRAM_RAM1364) TrustRAM Offset */
#define TRAM_RAM1365_REG_OFST          _UINT32_(0x2554)    /* (TRAM_RAM1365) TrustRAM Offset */
#define TRAM_RAM1366_REG_OFST          _UINT32_(0x2558)    /* (TRAM_RAM1366) TrustRAM Offset */
#define TRAM_RAM1367_REG_OFST          _UINT32_(0x255C)    /* (TRAM_RAM1367) TrustRAM Offset */
#define TRAM_RAM1368_REG_OFST          _UINT32_(0x2560)    /* (TRAM_RAM1368) TrustRAM Offset */
#define TRAM_RAM1369_REG_OFST          _UINT32_(0x2564)    /* (TRAM_RAM1369) TrustRAM Offset */
#define TRAM_RAM1370_REG_OFST          _UINT32_(0x2568)    /* (TRAM_RAM1370) TrustRAM Offset */
#define TRAM_RAM1371_REG_OFST          _UINT32_(0x256C)    /* (TRAM_RAM1371) TrustRAM Offset */
#define TRAM_RAM1372_REG_OFST          _UINT32_(0x2570)    /* (TRAM_RAM1372) TrustRAM Offset */
#define TRAM_RAM1373_REG_OFST          _UINT32_(0x2574)    /* (TRAM_RAM1373) TrustRAM Offset */
#define TRAM_RAM1374_REG_OFST          _UINT32_(0x2578)    /* (TRAM_RAM1374) TrustRAM Offset */
#define TRAM_RAM1375_REG_OFST          _UINT32_(0x257C)    /* (TRAM_RAM1375) TrustRAM Offset */
#define TRAM_RAM1376_REG_OFST          _UINT32_(0x2580)    /* (TRAM_RAM1376) TrustRAM Offset */
#define TRAM_RAM1377_REG_OFST          _UINT32_(0x2584)    /* (TRAM_RAM1377) TrustRAM Offset */
#define TRAM_RAM1378_REG_OFST          _UINT32_(0x2588)    /* (TRAM_RAM1378) TrustRAM Offset */
#define TRAM_RAM1379_REG_OFST          _UINT32_(0x258C)    /* (TRAM_RAM1379) TrustRAM Offset */
#define TRAM_RAM1380_REG_OFST          _UINT32_(0x2590)    /* (TRAM_RAM1380) TrustRAM Offset */
#define TRAM_RAM1381_REG_OFST          _UINT32_(0x2594)    /* (TRAM_RAM1381) TrustRAM Offset */
#define TRAM_RAM1382_REG_OFST          _UINT32_(0x2598)    /* (TRAM_RAM1382) TrustRAM Offset */
#define TRAM_RAM1383_REG_OFST          _UINT32_(0x259C)    /* (TRAM_RAM1383) TrustRAM Offset */
#define TRAM_RAM1384_REG_OFST          _UINT32_(0x25A0)    /* (TRAM_RAM1384) TrustRAM Offset */
#define TRAM_RAM1385_REG_OFST          _UINT32_(0x25A4)    /* (TRAM_RAM1385) TrustRAM Offset */
#define TRAM_RAM1386_REG_OFST          _UINT32_(0x25A8)    /* (TRAM_RAM1386) TrustRAM Offset */
#define TRAM_RAM1387_REG_OFST          _UINT32_(0x25AC)    /* (TRAM_RAM1387) TrustRAM Offset */
#define TRAM_RAM1388_REG_OFST          _UINT32_(0x25B0)    /* (TRAM_RAM1388) TrustRAM Offset */
#define TRAM_RAM1389_REG_OFST          _UINT32_(0x25B4)    /* (TRAM_RAM1389) TrustRAM Offset */
#define TRAM_RAM1390_REG_OFST          _UINT32_(0x25B8)    /* (TRAM_RAM1390) TrustRAM Offset */
#define TRAM_RAM1391_REG_OFST          _UINT32_(0x25BC)    /* (TRAM_RAM1391) TrustRAM Offset */
#define TRAM_RAM1392_REG_OFST          _UINT32_(0x25C0)    /* (TRAM_RAM1392) TrustRAM Offset */
#define TRAM_RAM1393_REG_OFST          _UINT32_(0x25C4)    /* (TRAM_RAM1393) TrustRAM Offset */
#define TRAM_RAM1394_REG_OFST          _UINT32_(0x25C8)    /* (TRAM_RAM1394) TrustRAM Offset */
#define TRAM_RAM1395_REG_OFST          _UINT32_(0x25CC)    /* (TRAM_RAM1395) TrustRAM Offset */
#define TRAM_RAM1396_REG_OFST          _UINT32_(0x25D0)    /* (TRAM_RAM1396) TrustRAM Offset */
#define TRAM_RAM1397_REG_OFST          _UINT32_(0x25D4)    /* (TRAM_RAM1397) TrustRAM Offset */
#define TRAM_RAM1398_REG_OFST          _UINT32_(0x25D8)    /* (TRAM_RAM1398) TrustRAM Offset */
#define TRAM_RAM1399_REG_OFST          _UINT32_(0x25DC)    /* (TRAM_RAM1399) TrustRAM Offset */
#define TRAM_RAM1400_REG_OFST          _UINT32_(0x25E0)    /* (TRAM_RAM1400) TrustRAM Offset */
#define TRAM_RAM1401_REG_OFST          _UINT32_(0x25E4)    /* (TRAM_RAM1401) TrustRAM Offset */
#define TRAM_RAM1402_REG_OFST          _UINT32_(0x25E8)    /* (TRAM_RAM1402) TrustRAM Offset */
#define TRAM_RAM1403_REG_OFST          _UINT32_(0x25EC)    /* (TRAM_RAM1403) TrustRAM Offset */
#define TRAM_RAM1404_REG_OFST          _UINT32_(0x25F0)    /* (TRAM_RAM1404) TrustRAM Offset */
#define TRAM_RAM1405_REG_OFST          _UINT32_(0x25F4)    /* (TRAM_RAM1405) TrustRAM Offset */
#define TRAM_RAM1406_REG_OFST          _UINT32_(0x25F8)    /* (TRAM_RAM1406) TrustRAM Offset */
#define TRAM_RAM1407_REG_OFST          _UINT32_(0x25FC)    /* (TRAM_RAM1407) TrustRAM Offset */
#define TRAM_RAM1408_REG_OFST          _UINT32_(0x2600)    /* (TRAM_RAM1408) TrustRAM Offset */
#define TRAM_RAM1409_REG_OFST          _UINT32_(0x2604)    /* (TRAM_RAM1409) TrustRAM Offset */
#define TRAM_RAM1410_REG_OFST          _UINT32_(0x2608)    /* (TRAM_RAM1410) TrustRAM Offset */
#define TRAM_RAM1411_REG_OFST          _UINT32_(0x260C)    /* (TRAM_RAM1411) TrustRAM Offset */
#define TRAM_RAM1412_REG_OFST          _UINT32_(0x2610)    /* (TRAM_RAM1412) TrustRAM Offset */
#define TRAM_RAM1413_REG_OFST          _UINT32_(0x2614)    /* (TRAM_RAM1413) TrustRAM Offset */
#define TRAM_RAM1414_REG_OFST          _UINT32_(0x2618)    /* (TRAM_RAM1414) TrustRAM Offset */
#define TRAM_RAM1415_REG_OFST          _UINT32_(0x261C)    /* (TRAM_RAM1415) TrustRAM Offset */
#define TRAM_RAM1416_REG_OFST          _UINT32_(0x2620)    /* (TRAM_RAM1416) TrustRAM Offset */
#define TRAM_RAM1417_REG_OFST          _UINT32_(0x2624)    /* (TRAM_RAM1417) TrustRAM Offset */
#define TRAM_RAM1418_REG_OFST          _UINT32_(0x2628)    /* (TRAM_RAM1418) TrustRAM Offset */
#define TRAM_RAM1419_REG_OFST          _UINT32_(0x262C)    /* (TRAM_RAM1419) TrustRAM Offset */
#define TRAM_RAM1420_REG_OFST          _UINT32_(0x2630)    /* (TRAM_RAM1420) TrustRAM Offset */
#define TRAM_RAM1421_REG_OFST          _UINT32_(0x2634)    /* (TRAM_RAM1421) TrustRAM Offset */
#define TRAM_RAM1422_REG_OFST          _UINT32_(0x2638)    /* (TRAM_RAM1422) TrustRAM Offset */
#define TRAM_RAM1423_REG_OFST          _UINT32_(0x263C)    /* (TRAM_RAM1423) TrustRAM Offset */
#define TRAM_RAM1424_REG_OFST          _UINT32_(0x2640)    /* (TRAM_RAM1424) TrustRAM Offset */
#define TRAM_RAM1425_REG_OFST          _UINT32_(0x2644)    /* (TRAM_RAM1425) TrustRAM Offset */
#define TRAM_RAM1426_REG_OFST          _UINT32_(0x2648)    /* (TRAM_RAM1426) TrustRAM Offset */
#define TRAM_RAM1427_REG_OFST          _UINT32_(0x264C)    /* (TRAM_RAM1427) TrustRAM Offset */
#define TRAM_RAM1428_REG_OFST          _UINT32_(0x2650)    /* (TRAM_RAM1428) TrustRAM Offset */
#define TRAM_RAM1429_REG_OFST          _UINT32_(0x2654)    /* (TRAM_RAM1429) TrustRAM Offset */
#define TRAM_RAM1430_REG_OFST          _UINT32_(0x2658)    /* (TRAM_RAM1430) TrustRAM Offset */
#define TRAM_RAM1431_REG_OFST          _UINT32_(0x265C)    /* (TRAM_RAM1431) TrustRAM Offset */
#define TRAM_RAM1432_REG_OFST          _UINT32_(0x2660)    /* (TRAM_RAM1432) TrustRAM Offset */
#define TRAM_RAM1433_REG_OFST          _UINT32_(0x2664)    /* (TRAM_RAM1433) TrustRAM Offset */
#define TRAM_RAM1434_REG_OFST          _UINT32_(0x2668)    /* (TRAM_RAM1434) TrustRAM Offset */
#define TRAM_RAM1435_REG_OFST          _UINT32_(0x266C)    /* (TRAM_RAM1435) TrustRAM Offset */
#define TRAM_RAM1436_REG_OFST          _UINT32_(0x2670)    /* (TRAM_RAM1436) TrustRAM Offset */
#define TRAM_RAM1437_REG_OFST          _UINT32_(0x2674)    /* (TRAM_RAM1437) TrustRAM Offset */
#define TRAM_RAM1438_REG_OFST          _UINT32_(0x2678)    /* (TRAM_RAM1438) TrustRAM Offset */
#define TRAM_RAM1439_REG_OFST          _UINT32_(0x267C)    /* (TRAM_RAM1439) TrustRAM Offset */
#define TRAM_RAM1440_REG_OFST          _UINT32_(0x2680)    /* (TRAM_RAM1440) TrustRAM Offset */
#define TRAM_RAM1441_REG_OFST          _UINT32_(0x2684)    /* (TRAM_RAM1441) TrustRAM Offset */
#define TRAM_RAM1442_REG_OFST          _UINT32_(0x2688)    /* (TRAM_RAM1442) TrustRAM Offset */
#define TRAM_RAM1443_REG_OFST          _UINT32_(0x268C)    /* (TRAM_RAM1443) TrustRAM Offset */
#define TRAM_RAM1444_REG_OFST          _UINT32_(0x2690)    /* (TRAM_RAM1444) TrustRAM Offset */
#define TRAM_RAM1445_REG_OFST          _UINT32_(0x2694)    /* (TRAM_RAM1445) TrustRAM Offset */
#define TRAM_RAM1446_REG_OFST          _UINT32_(0x2698)    /* (TRAM_RAM1446) TrustRAM Offset */
#define TRAM_RAM1447_REG_OFST          _UINT32_(0x269C)    /* (TRAM_RAM1447) TrustRAM Offset */
#define TRAM_RAM1448_REG_OFST          _UINT32_(0x26A0)    /* (TRAM_RAM1448) TrustRAM Offset */
#define TRAM_RAM1449_REG_OFST          _UINT32_(0x26A4)    /* (TRAM_RAM1449) TrustRAM Offset */
#define TRAM_RAM1450_REG_OFST          _UINT32_(0x26A8)    /* (TRAM_RAM1450) TrustRAM Offset */
#define TRAM_RAM1451_REG_OFST          _UINT32_(0x26AC)    /* (TRAM_RAM1451) TrustRAM Offset */
#define TRAM_RAM1452_REG_OFST          _UINT32_(0x26B0)    /* (TRAM_RAM1452) TrustRAM Offset */
#define TRAM_RAM1453_REG_OFST          _UINT32_(0x26B4)    /* (TRAM_RAM1453) TrustRAM Offset */
#define TRAM_RAM1454_REG_OFST          _UINT32_(0x26B8)    /* (TRAM_RAM1454) TrustRAM Offset */
#define TRAM_RAM1455_REG_OFST          _UINT32_(0x26BC)    /* (TRAM_RAM1455) TrustRAM Offset */
#define TRAM_RAM1456_REG_OFST          _UINT32_(0x26C0)    /* (TRAM_RAM1456) TrustRAM Offset */
#define TRAM_RAM1457_REG_OFST          _UINT32_(0x26C4)    /* (TRAM_RAM1457) TrustRAM Offset */
#define TRAM_RAM1458_REG_OFST          _UINT32_(0x26C8)    /* (TRAM_RAM1458) TrustRAM Offset */
#define TRAM_RAM1459_REG_OFST          _UINT32_(0x26CC)    /* (TRAM_RAM1459) TrustRAM Offset */
#define TRAM_RAM1460_REG_OFST          _UINT32_(0x26D0)    /* (TRAM_RAM1460) TrustRAM Offset */
#define TRAM_RAM1461_REG_OFST          _UINT32_(0x26D4)    /* (TRAM_RAM1461) TrustRAM Offset */
#define TRAM_RAM1462_REG_OFST          _UINT32_(0x26D8)    /* (TRAM_RAM1462) TrustRAM Offset */
#define TRAM_RAM1463_REG_OFST          _UINT32_(0x26DC)    /* (TRAM_RAM1463) TrustRAM Offset */
#define TRAM_RAM1464_REG_OFST          _UINT32_(0x26E0)    /* (TRAM_RAM1464) TrustRAM Offset */
#define TRAM_RAM1465_REG_OFST          _UINT32_(0x26E4)    /* (TRAM_RAM1465) TrustRAM Offset */
#define TRAM_RAM1466_REG_OFST          _UINT32_(0x26E8)    /* (TRAM_RAM1466) TrustRAM Offset */
#define TRAM_RAM1467_REG_OFST          _UINT32_(0x26EC)    /* (TRAM_RAM1467) TrustRAM Offset */
#define TRAM_RAM1468_REG_OFST          _UINT32_(0x26F0)    /* (TRAM_RAM1468) TrustRAM Offset */
#define TRAM_RAM1469_REG_OFST          _UINT32_(0x26F4)    /* (TRAM_RAM1469) TrustRAM Offset */
#define TRAM_RAM1470_REG_OFST          _UINT32_(0x26F8)    /* (TRAM_RAM1470) TrustRAM Offset */
#define TRAM_RAM1471_REG_OFST          _UINT32_(0x26FC)    /* (TRAM_RAM1471) TrustRAM Offset */
#define TRAM_RAM1472_REG_OFST          _UINT32_(0x2700)    /* (TRAM_RAM1472) TrustRAM Offset */
#define TRAM_RAM1473_REG_OFST          _UINT32_(0x2704)    /* (TRAM_RAM1473) TrustRAM Offset */
#define TRAM_RAM1474_REG_OFST          _UINT32_(0x2708)    /* (TRAM_RAM1474) TrustRAM Offset */
#define TRAM_RAM1475_REG_OFST          _UINT32_(0x270C)    /* (TRAM_RAM1475) TrustRAM Offset */
#define TRAM_RAM1476_REG_OFST          _UINT32_(0x2710)    /* (TRAM_RAM1476) TrustRAM Offset */
#define TRAM_RAM1477_REG_OFST          _UINT32_(0x2714)    /* (TRAM_RAM1477) TrustRAM Offset */
#define TRAM_RAM1478_REG_OFST          _UINT32_(0x2718)    /* (TRAM_RAM1478) TrustRAM Offset */
#define TRAM_RAM1479_REG_OFST          _UINT32_(0x271C)    /* (TRAM_RAM1479) TrustRAM Offset */
#define TRAM_RAM1480_REG_OFST          _UINT32_(0x2720)    /* (TRAM_RAM1480) TrustRAM Offset */
#define TRAM_RAM1481_REG_OFST          _UINT32_(0x2724)    /* (TRAM_RAM1481) TrustRAM Offset */
#define TRAM_RAM1482_REG_OFST          _UINT32_(0x2728)    /* (TRAM_RAM1482) TrustRAM Offset */
#define TRAM_RAM1483_REG_OFST          _UINT32_(0x272C)    /* (TRAM_RAM1483) TrustRAM Offset */
#define TRAM_RAM1484_REG_OFST          _UINT32_(0x2730)    /* (TRAM_RAM1484) TrustRAM Offset */
#define TRAM_RAM1485_REG_OFST          _UINT32_(0x2734)    /* (TRAM_RAM1485) TrustRAM Offset */
#define TRAM_RAM1486_REG_OFST          _UINT32_(0x2738)    /* (TRAM_RAM1486) TrustRAM Offset */
#define TRAM_RAM1487_REG_OFST          _UINT32_(0x273C)    /* (TRAM_RAM1487) TrustRAM Offset */
#define TRAM_RAM1488_REG_OFST          _UINT32_(0x2740)    /* (TRAM_RAM1488) TrustRAM Offset */
#define TRAM_RAM1489_REG_OFST          _UINT32_(0x2744)    /* (TRAM_RAM1489) TrustRAM Offset */
#define TRAM_RAM1490_REG_OFST          _UINT32_(0x2748)    /* (TRAM_RAM1490) TrustRAM Offset */
#define TRAM_RAM1491_REG_OFST          _UINT32_(0x274C)    /* (TRAM_RAM1491) TrustRAM Offset */
#define TRAM_RAM1492_REG_OFST          _UINT32_(0x2750)    /* (TRAM_RAM1492) TrustRAM Offset */
#define TRAM_RAM1493_REG_OFST          _UINT32_(0x2754)    /* (TRAM_RAM1493) TrustRAM Offset */
#define TRAM_RAM1494_REG_OFST          _UINT32_(0x2758)    /* (TRAM_RAM1494) TrustRAM Offset */
#define TRAM_RAM1495_REG_OFST          _UINT32_(0x275C)    /* (TRAM_RAM1495) TrustRAM Offset */
#define TRAM_RAM1496_REG_OFST          _UINT32_(0x2760)    /* (TRAM_RAM1496) TrustRAM Offset */
#define TRAM_RAM1497_REG_OFST          _UINT32_(0x2764)    /* (TRAM_RAM1497) TrustRAM Offset */
#define TRAM_RAM1498_REG_OFST          _UINT32_(0x2768)    /* (TRAM_RAM1498) TrustRAM Offset */
#define TRAM_RAM1499_REG_OFST          _UINT32_(0x276C)    /* (TRAM_RAM1499) TrustRAM Offset */
#define TRAM_RAM1500_REG_OFST          _UINT32_(0x2770)    /* (TRAM_RAM1500) TrustRAM Offset */
#define TRAM_RAM1501_REG_OFST          _UINT32_(0x2774)    /* (TRAM_RAM1501) TrustRAM Offset */
#define TRAM_RAM1502_REG_OFST          _UINT32_(0x2778)    /* (TRAM_RAM1502) TrustRAM Offset */
#define TRAM_RAM1503_REG_OFST          _UINT32_(0x277C)    /* (TRAM_RAM1503) TrustRAM Offset */
#define TRAM_RAM1504_REG_OFST          _UINT32_(0x2780)    /* (TRAM_RAM1504) TrustRAM Offset */
#define TRAM_RAM1505_REG_OFST          _UINT32_(0x2784)    /* (TRAM_RAM1505) TrustRAM Offset */
#define TRAM_RAM1506_REG_OFST          _UINT32_(0x2788)    /* (TRAM_RAM1506) TrustRAM Offset */
#define TRAM_RAM1507_REG_OFST          _UINT32_(0x278C)    /* (TRAM_RAM1507) TrustRAM Offset */
#define TRAM_RAM1508_REG_OFST          _UINT32_(0x2790)    /* (TRAM_RAM1508) TrustRAM Offset */
#define TRAM_RAM1509_REG_OFST          _UINT32_(0x2794)    /* (TRAM_RAM1509) TrustRAM Offset */
#define TRAM_RAM1510_REG_OFST          _UINT32_(0x2798)    /* (TRAM_RAM1510) TrustRAM Offset */
#define TRAM_RAM1511_REG_OFST          _UINT32_(0x279C)    /* (TRAM_RAM1511) TrustRAM Offset */
#define TRAM_RAM1512_REG_OFST          _UINT32_(0x27A0)    /* (TRAM_RAM1512) TrustRAM Offset */
#define TRAM_RAM1513_REG_OFST          _UINT32_(0x27A4)    /* (TRAM_RAM1513) TrustRAM Offset */
#define TRAM_RAM1514_REG_OFST          _UINT32_(0x27A8)    /* (TRAM_RAM1514) TrustRAM Offset */
#define TRAM_RAM1515_REG_OFST          _UINT32_(0x27AC)    /* (TRAM_RAM1515) TrustRAM Offset */
#define TRAM_RAM1516_REG_OFST          _UINT32_(0x27B0)    /* (TRAM_RAM1516) TrustRAM Offset */
#define TRAM_RAM1517_REG_OFST          _UINT32_(0x27B4)    /* (TRAM_RAM1517) TrustRAM Offset */
#define TRAM_RAM1518_REG_OFST          _UINT32_(0x27B8)    /* (TRAM_RAM1518) TrustRAM Offset */
#define TRAM_RAM1519_REG_OFST          _UINT32_(0x27BC)    /* (TRAM_RAM1519) TrustRAM Offset */
#define TRAM_RAM1520_REG_OFST          _UINT32_(0x27C0)    /* (TRAM_RAM1520) TrustRAM Offset */
#define TRAM_RAM1521_REG_OFST          _UINT32_(0x27C4)    /* (TRAM_RAM1521) TrustRAM Offset */
#define TRAM_RAM1522_REG_OFST          _UINT32_(0x27C8)    /* (TRAM_RAM1522) TrustRAM Offset */
#define TRAM_RAM1523_REG_OFST          _UINT32_(0x27CC)    /* (TRAM_RAM1523) TrustRAM Offset */
#define TRAM_RAM1524_REG_OFST          _UINT32_(0x27D0)    /* (TRAM_RAM1524) TrustRAM Offset */
#define TRAM_RAM1525_REG_OFST          _UINT32_(0x27D4)    /* (TRAM_RAM1525) TrustRAM Offset */
#define TRAM_RAM1526_REG_OFST          _UINT32_(0x27D8)    /* (TRAM_RAM1526) TrustRAM Offset */
#define TRAM_RAM1527_REG_OFST          _UINT32_(0x27DC)    /* (TRAM_RAM1527) TrustRAM Offset */
#define TRAM_RAM1528_REG_OFST          _UINT32_(0x27E0)    /* (TRAM_RAM1528) TrustRAM Offset */
#define TRAM_RAM1529_REG_OFST          _UINT32_(0x27E4)    /* (TRAM_RAM1529) TrustRAM Offset */
#define TRAM_RAM1530_REG_OFST          _UINT32_(0x27E8)    /* (TRAM_RAM1530) TrustRAM Offset */
#define TRAM_RAM1531_REG_OFST          _UINT32_(0x27EC)    /* (TRAM_RAM1531) TrustRAM Offset */
#define TRAM_RAM1532_REG_OFST          _UINT32_(0x27F0)    /* (TRAM_RAM1532) TrustRAM Offset */
#define TRAM_RAM1533_REG_OFST          _UINT32_(0x27F4)    /* (TRAM_RAM1533) TrustRAM Offset */
#define TRAM_RAM1534_REG_OFST          _UINT32_(0x27F8)    /* (TRAM_RAM1534) TrustRAM Offset */
#define TRAM_RAM1535_REG_OFST          _UINT32_(0x27FC)    /* (TRAM_RAM1535) TrustRAM Offset */
#define TRAM_RAM1536_REG_OFST          _UINT32_(0x2800)    /* (TRAM_RAM1536) TrustRAM Offset */
#define TRAM_RAM1537_REG_OFST          _UINT32_(0x2804)    /* (TRAM_RAM1537) TrustRAM Offset */
#define TRAM_RAM1538_REG_OFST          _UINT32_(0x2808)    /* (TRAM_RAM1538) TrustRAM Offset */
#define TRAM_RAM1539_REG_OFST          _UINT32_(0x280C)    /* (TRAM_RAM1539) TrustRAM Offset */
#define TRAM_RAM1540_REG_OFST          _UINT32_(0x2810)    /* (TRAM_RAM1540) TrustRAM Offset */
#define TRAM_RAM1541_REG_OFST          _UINT32_(0x2814)    /* (TRAM_RAM1541) TrustRAM Offset */
#define TRAM_RAM1542_REG_OFST          _UINT32_(0x2818)    /* (TRAM_RAM1542) TrustRAM Offset */
#define TRAM_RAM1543_REG_OFST          _UINT32_(0x281C)    /* (TRAM_RAM1543) TrustRAM Offset */
#define TRAM_RAM1544_REG_OFST          _UINT32_(0x2820)    /* (TRAM_RAM1544) TrustRAM Offset */
#define TRAM_RAM1545_REG_OFST          _UINT32_(0x2824)    /* (TRAM_RAM1545) TrustRAM Offset */
#define TRAM_RAM1546_REG_OFST          _UINT32_(0x2828)    /* (TRAM_RAM1546) TrustRAM Offset */
#define TRAM_RAM1547_REG_OFST          _UINT32_(0x282C)    /* (TRAM_RAM1547) TrustRAM Offset */
#define TRAM_RAM1548_REG_OFST          _UINT32_(0x2830)    /* (TRAM_RAM1548) TrustRAM Offset */
#define TRAM_RAM1549_REG_OFST          _UINT32_(0x2834)    /* (TRAM_RAM1549) TrustRAM Offset */
#define TRAM_RAM1550_REG_OFST          _UINT32_(0x2838)    /* (TRAM_RAM1550) TrustRAM Offset */
#define TRAM_RAM1551_REG_OFST          _UINT32_(0x283C)    /* (TRAM_RAM1551) TrustRAM Offset */
#define TRAM_RAM1552_REG_OFST          _UINT32_(0x2840)    /* (TRAM_RAM1552) TrustRAM Offset */
#define TRAM_RAM1553_REG_OFST          _UINT32_(0x2844)    /* (TRAM_RAM1553) TrustRAM Offset */
#define TRAM_RAM1554_REG_OFST          _UINT32_(0x2848)    /* (TRAM_RAM1554) TrustRAM Offset */
#define TRAM_RAM1555_REG_OFST          _UINT32_(0x284C)    /* (TRAM_RAM1555) TrustRAM Offset */
#define TRAM_RAM1556_REG_OFST          _UINT32_(0x2850)    /* (TRAM_RAM1556) TrustRAM Offset */
#define TRAM_RAM1557_REG_OFST          _UINT32_(0x2854)    /* (TRAM_RAM1557) TrustRAM Offset */
#define TRAM_RAM1558_REG_OFST          _UINT32_(0x2858)    /* (TRAM_RAM1558) TrustRAM Offset */
#define TRAM_RAM1559_REG_OFST          _UINT32_(0x285C)    /* (TRAM_RAM1559) TrustRAM Offset */
#define TRAM_RAM1560_REG_OFST          _UINT32_(0x2860)    /* (TRAM_RAM1560) TrustRAM Offset */
#define TRAM_RAM1561_REG_OFST          _UINT32_(0x2864)    /* (TRAM_RAM1561) TrustRAM Offset */
#define TRAM_RAM1562_REG_OFST          _UINT32_(0x2868)    /* (TRAM_RAM1562) TrustRAM Offset */
#define TRAM_RAM1563_REG_OFST          _UINT32_(0x286C)    /* (TRAM_RAM1563) TrustRAM Offset */
#define TRAM_RAM1564_REG_OFST          _UINT32_(0x2870)    /* (TRAM_RAM1564) TrustRAM Offset */
#define TRAM_RAM1565_REG_OFST          _UINT32_(0x2874)    /* (TRAM_RAM1565) TrustRAM Offset */
#define TRAM_RAM1566_REG_OFST          _UINT32_(0x2878)    /* (TRAM_RAM1566) TrustRAM Offset */
#define TRAM_RAM1567_REG_OFST          _UINT32_(0x287C)    /* (TRAM_RAM1567) TrustRAM Offset */
#define TRAM_RAM1568_REG_OFST          _UINT32_(0x2880)    /* (TRAM_RAM1568) TrustRAM Offset */
#define TRAM_RAM1569_REG_OFST          _UINT32_(0x2884)    /* (TRAM_RAM1569) TrustRAM Offset */
#define TRAM_RAM1570_REG_OFST          _UINT32_(0x2888)    /* (TRAM_RAM1570) TrustRAM Offset */
#define TRAM_RAM1571_REG_OFST          _UINT32_(0x288C)    /* (TRAM_RAM1571) TrustRAM Offset */
#define TRAM_RAM1572_REG_OFST          _UINT32_(0x2890)    /* (TRAM_RAM1572) TrustRAM Offset */
#define TRAM_RAM1573_REG_OFST          _UINT32_(0x2894)    /* (TRAM_RAM1573) TrustRAM Offset */
#define TRAM_RAM1574_REG_OFST          _UINT32_(0x2898)    /* (TRAM_RAM1574) TrustRAM Offset */
#define TRAM_RAM1575_REG_OFST          _UINT32_(0x289C)    /* (TRAM_RAM1575) TrustRAM Offset */
#define TRAM_RAM1576_REG_OFST          _UINT32_(0x28A0)    /* (TRAM_RAM1576) TrustRAM Offset */
#define TRAM_RAM1577_REG_OFST          _UINT32_(0x28A4)    /* (TRAM_RAM1577) TrustRAM Offset */
#define TRAM_RAM1578_REG_OFST          _UINT32_(0x28A8)    /* (TRAM_RAM1578) TrustRAM Offset */
#define TRAM_RAM1579_REG_OFST          _UINT32_(0x28AC)    /* (TRAM_RAM1579) TrustRAM Offset */
#define TRAM_RAM1580_REG_OFST          _UINT32_(0x28B0)    /* (TRAM_RAM1580) TrustRAM Offset */
#define TRAM_RAM1581_REG_OFST          _UINT32_(0x28B4)    /* (TRAM_RAM1581) TrustRAM Offset */
#define TRAM_RAM1582_REG_OFST          _UINT32_(0x28B8)    /* (TRAM_RAM1582) TrustRAM Offset */
#define TRAM_RAM1583_REG_OFST          _UINT32_(0x28BC)    /* (TRAM_RAM1583) TrustRAM Offset */
#define TRAM_RAM1584_REG_OFST          _UINT32_(0x28C0)    /* (TRAM_RAM1584) TrustRAM Offset */
#define TRAM_RAM1585_REG_OFST          _UINT32_(0x28C4)    /* (TRAM_RAM1585) TrustRAM Offset */
#define TRAM_RAM1586_REG_OFST          _UINT32_(0x28C8)    /* (TRAM_RAM1586) TrustRAM Offset */
#define TRAM_RAM1587_REG_OFST          _UINT32_(0x28CC)    /* (TRAM_RAM1587) TrustRAM Offset */
#define TRAM_RAM1588_REG_OFST          _UINT32_(0x28D0)    /* (TRAM_RAM1588) TrustRAM Offset */
#define TRAM_RAM1589_REG_OFST          _UINT32_(0x28D4)    /* (TRAM_RAM1589) TrustRAM Offset */
#define TRAM_RAM1590_REG_OFST          _UINT32_(0x28D8)    /* (TRAM_RAM1590) TrustRAM Offset */
#define TRAM_RAM1591_REG_OFST          _UINT32_(0x28DC)    /* (TRAM_RAM1591) TrustRAM Offset */
#define TRAM_RAM1592_REG_OFST          _UINT32_(0x28E0)    /* (TRAM_RAM1592) TrustRAM Offset */
#define TRAM_RAM1593_REG_OFST          _UINT32_(0x28E4)    /* (TRAM_RAM1593) TrustRAM Offset */
#define TRAM_RAM1594_REG_OFST          _UINT32_(0x28E8)    /* (TRAM_RAM1594) TrustRAM Offset */
#define TRAM_RAM1595_REG_OFST          _UINT32_(0x28EC)    /* (TRAM_RAM1595) TrustRAM Offset */
#define TRAM_RAM1596_REG_OFST          _UINT32_(0x28F0)    /* (TRAM_RAM1596) TrustRAM Offset */
#define TRAM_RAM1597_REG_OFST          _UINT32_(0x28F4)    /* (TRAM_RAM1597) TrustRAM Offset */
#define TRAM_RAM1598_REG_OFST          _UINT32_(0x28F8)    /* (TRAM_RAM1598) TrustRAM Offset */
#define TRAM_RAM1599_REG_OFST          _UINT32_(0x28FC)    /* (TRAM_RAM1599) TrustRAM Offset */
#define TRAM_RAM1600_REG_OFST          _UINT32_(0x2900)    /* (TRAM_RAM1600) TrustRAM Offset */
#define TRAM_RAM1601_REG_OFST          _UINT32_(0x2904)    /* (TRAM_RAM1601) TrustRAM Offset */
#define TRAM_RAM1602_REG_OFST          _UINT32_(0x2908)    /* (TRAM_RAM1602) TrustRAM Offset */
#define TRAM_RAM1603_REG_OFST          _UINT32_(0x290C)    /* (TRAM_RAM1603) TrustRAM Offset */
#define TRAM_RAM1604_REG_OFST          _UINT32_(0x2910)    /* (TRAM_RAM1604) TrustRAM Offset */
#define TRAM_RAM1605_REG_OFST          _UINT32_(0x2914)    /* (TRAM_RAM1605) TrustRAM Offset */
#define TRAM_RAM1606_REG_OFST          _UINT32_(0x2918)    /* (TRAM_RAM1606) TrustRAM Offset */
#define TRAM_RAM1607_REG_OFST          _UINT32_(0x291C)    /* (TRAM_RAM1607) TrustRAM Offset */
#define TRAM_RAM1608_REG_OFST          _UINT32_(0x2920)    /* (TRAM_RAM1608) TrustRAM Offset */
#define TRAM_RAM1609_REG_OFST          _UINT32_(0x2924)    /* (TRAM_RAM1609) TrustRAM Offset */
#define TRAM_RAM1610_REG_OFST          _UINT32_(0x2928)    /* (TRAM_RAM1610) TrustRAM Offset */
#define TRAM_RAM1611_REG_OFST          _UINT32_(0x292C)    /* (TRAM_RAM1611) TrustRAM Offset */
#define TRAM_RAM1612_REG_OFST          _UINT32_(0x2930)    /* (TRAM_RAM1612) TrustRAM Offset */
#define TRAM_RAM1613_REG_OFST          _UINT32_(0x2934)    /* (TRAM_RAM1613) TrustRAM Offset */
#define TRAM_RAM1614_REG_OFST          _UINT32_(0x2938)    /* (TRAM_RAM1614) TrustRAM Offset */
#define TRAM_RAM1615_REG_OFST          _UINT32_(0x293C)    /* (TRAM_RAM1615) TrustRAM Offset */
#define TRAM_RAM1616_REG_OFST          _UINT32_(0x2940)    /* (TRAM_RAM1616) TrustRAM Offset */
#define TRAM_RAM1617_REG_OFST          _UINT32_(0x2944)    /* (TRAM_RAM1617) TrustRAM Offset */
#define TRAM_RAM1618_REG_OFST          _UINT32_(0x2948)    /* (TRAM_RAM1618) TrustRAM Offset */
#define TRAM_RAM1619_REG_OFST          _UINT32_(0x294C)    /* (TRAM_RAM1619) TrustRAM Offset */
#define TRAM_RAM1620_REG_OFST          _UINT32_(0x2950)    /* (TRAM_RAM1620) TrustRAM Offset */
#define TRAM_RAM1621_REG_OFST          _UINT32_(0x2954)    /* (TRAM_RAM1621) TrustRAM Offset */
#define TRAM_RAM1622_REG_OFST          _UINT32_(0x2958)    /* (TRAM_RAM1622) TrustRAM Offset */
#define TRAM_RAM1623_REG_OFST          _UINT32_(0x295C)    /* (TRAM_RAM1623) TrustRAM Offset */
#define TRAM_RAM1624_REG_OFST          _UINT32_(0x2960)    /* (TRAM_RAM1624) TrustRAM Offset */
#define TRAM_RAM1625_REG_OFST          _UINT32_(0x2964)    /* (TRAM_RAM1625) TrustRAM Offset */
#define TRAM_RAM1626_REG_OFST          _UINT32_(0x2968)    /* (TRAM_RAM1626) TrustRAM Offset */
#define TRAM_RAM1627_REG_OFST          _UINT32_(0x296C)    /* (TRAM_RAM1627) TrustRAM Offset */
#define TRAM_RAM1628_REG_OFST          _UINT32_(0x2970)    /* (TRAM_RAM1628) TrustRAM Offset */
#define TRAM_RAM1629_REG_OFST          _UINT32_(0x2974)    /* (TRAM_RAM1629) TrustRAM Offset */
#define TRAM_RAM1630_REG_OFST          _UINT32_(0x2978)    /* (TRAM_RAM1630) TrustRAM Offset */
#define TRAM_RAM1631_REG_OFST          _UINT32_(0x297C)    /* (TRAM_RAM1631) TrustRAM Offset */
#define TRAM_RAM1632_REG_OFST          _UINT32_(0x2980)    /* (TRAM_RAM1632) TrustRAM Offset */
#define TRAM_RAM1633_REG_OFST          _UINT32_(0x2984)    /* (TRAM_RAM1633) TrustRAM Offset */
#define TRAM_RAM1634_REG_OFST          _UINT32_(0x2988)    /* (TRAM_RAM1634) TrustRAM Offset */
#define TRAM_RAM1635_REG_OFST          _UINT32_(0x298C)    /* (TRAM_RAM1635) TrustRAM Offset */
#define TRAM_RAM1636_REG_OFST          _UINT32_(0x2990)    /* (TRAM_RAM1636) TrustRAM Offset */
#define TRAM_RAM1637_REG_OFST          _UINT32_(0x2994)    /* (TRAM_RAM1637) TrustRAM Offset */
#define TRAM_RAM1638_REG_OFST          _UINT32_(0x2998)    /* (TRAM_RAM1638) TrustRAM Offset */
#define TRAM_RAM1639_REG_OFST          _UINT32_(0x299C)    /* (TRAM_RAM1639) TrustRAM Offset */
#define TRAM_RAM1640_REG_OFST          _UINT32_(0x29A0)    /* (TRAM_RAM1640) TrustRAM Offset */
#define TRAM_RAM1641_REG_OFST          _UINT32_(0x29A4)    /* (TRAM_RAM1641) TrustRAM Offset */
#define TRAM_RAM1642_REG_OFST          _UINT32_(0x29A8)    /* (TRAM_RAM1642) TrustRAM Offset */
#define TRAM_RAM1643_REG_OFST          _UINT32_(0x29AC)    /* (TRAM_RAM1643) TrustRAM Offset */
#define TRAM_RAM1644_REG_OFST          _UINT32_(0x29B0)    /* (TRAM_RAM1644) TrustRAM Offset */
#define TRAM_RAM1645_REG_OFST          _UINT32_(0x29B4)    /* (TRAM_RAM1645) TrustRAM Offset */
#define TRAM_RAM1646_REG_OFST          _UINT32_(0x29B8)    /* (TRAM_RAM1646) TrustRAM Offset */
#define TRAM_RAM1647_REG_OFST          _UINT32_(0x29BC)    /* (TRAM_RAM1647) TrustRAM Offset */
#define TRAM_RAM1648_REG_OFST          _UINT32_(0x29C0)    /* (TRAM_RAM1648) TrustRAM Offset */
#define TRAM_RAM1649_REG_OFST          _UINT32_(0x29C4)    /* (TRAM_RAM1649) TrustRAM Offset */
#define TRAM_RAM1650_REG_OFST          _UINT32_(0x29C8)    /* (TRAM_RAM1650) TrustRAM Offset */
#define TRAM_RAM1651_REG_OFST          _UINT32_(0x29CC)    /* (TRAM_RAM1651) TrustRAM Offset */
#define TRAM_RAM1652_REG_OFST          _UINT32_(0x29D0)    /* (TRAM_RAM1652) TrustRAM Offset */
#define TRAM_RAM1653_REG_OFST          _UINT32_(0x29D4)    /* (TRAM_RAM1653) TrustRAM Offset */
#define TRAM_RAM1654_REG_OFST          _UINT32_(0x29D8)    /* (TRAM_RAM1654) TrustRAM Offset */
#define TRAM_RAM1655_REG_OFST          _UINT32_(0x29DC)    /* (TRAM_RAM1655) TrustRAM Offset */
#define TRAM_RAM1656_REG_OFST          _UINT32_(0x29E0)    /* (TRAM_RAM1656) TrustRAM Offset */
#define TRAM_RAM1657_REG_OFST          _UINT32_(0x29E4)    /* (TRAM_RAM1657) TrustRAM Offset */
#define TRAM_RAM1658_REG_OFST          _UINT32_(0x29E8)    /* (TRAM_RAM1658) TrustRAM Offset */
#define TRAM_RAM1659_REG_OFST          _UINT32_(0x29EC)    /* (TRAM_RAM1659) TrustRAM Offset */
#define TRAM_RAM1660_REG_OFST          _UINT32_(0x29F0)    /* (TRAM_RAM1660) TrustRAM Offset */
#define TRAM_RAM1661_REG_OFST          _UINT32_(0x29F4)    /* (TRAM_RAM1661) TrustRAM Offset */
#define TRAM_RAM1662_REG_OFST          _UINT32_(0x29F8)    /* (TRAM_RAM1662) TrustRAM Offset */
#define TRAM_RAM1663_REG_OFST          _UINT32_(0x29FC)    /* (TRAM_RAM1663) TrustRAM Offset */
#define TRAM_RAM1664_REG_OFST          _UINT32_(0x2A00)    /* (TRAM_RAM1664) TrustRAM Offset */
#define TRAM_RAM1665_REG_OFST          _UINT32_(0x2A04)    /* (TRAM_RAM1665) TrustRAM Offset */
#define TRAM_RAM1666_REG_OFST          _UINT32_(0x2A08)    /* (TRAM_RAM1666) TrustRAM Offset */
#define TRAM_RAM1667_REG_OFST          _UINT32_(0x2A0C)    /* (TRAM_RAM1667) TrustRAM Offset */
#define TRAM_RAM1668_REG_OFST          _UINT32_(0x2A10)    /* (TRAM_RAM1668) TrustRAM Offset */
#define TRAM_RAM1669_REG_OFST          _UINT32_(0x2A14)    /* (TRAM_RAM1669) TrustRAM Offset */
#define TRAM_RAM1670_REG_OFST          _UINT32_(0x2A18)    /* (TRAM_RAM1670) TrustRAM Offset */
#define TRAM_RAM1671_REG_OFST          _UINT32_(0x2A1C)    /* (TRAM_RAM1671) TrustRAM Offset */
#define TRAM_RAM1672_REG_OFST          _UINT32_(0x2A20)    /* (TRAM_RAM1672) TrustRAM Offset */
#define TRAM_RAM1673_REG_OFST          _UINT32_(0x2A24)    /* (TRAM_RAM1673) TrustRAM Offset */
#define TRAM_RAM1674_REG_OFST          _UINT32_(0x2A28)    /* (TRAM_RAM1674) TrustRAM Offset */
#define TRAM_RAM1675_REG_OFST          _UINT32_(0x2A2C)    /* (TRAM_RAM1675) TrustRAM Offset */
#define TRAM_RAM1676_REG_OFST          _UINT32_(0x2A30)    /* (TRAM_RAM1676) TrustRAM Offset */
#define TRAM_RAM1677_REG_OFST          _UINT32_(0x2A34)    /* (TRAM_RAM1677) TrustRAM Offset */
#define TRAM_RAM1678_REG_OFST          _UINT32_(0x2A38)    /* (TRAM_RAM1678) TrustRAM Offset */
#define TRAM_RAM1679_REG_OFST          _UINT32_(0x2A3C)    /* (TRAM_RAM1679) TrustRAM Offset */
#define TRAM_RAM1680_REG_OFST          _UINT32_(0x2A40)    /* (TRAM_RAM1680) TrustRAM Offset */
#define TRAM_RAM1681_REG_OFST          _UINT32_(0x2A44)    /* (TRAM_RAM1681) TrustRAM Offset */
#define TRAM_RAM1682_REG_OFST          _UINT32_(0x2A48)    /* (TRAM_RAM1682) TrustRAM Offset */
#define TRAM_RAM1683_REG_OFST          _UINT32_(0x2A4C)    /* (TRAM_RAM1683) TrustRAM Offset */
#define TRAM_RAM1684_REG_OFST          _UINT32_(0x2A50)    /* (TRAM_RAM1684) TrustRAM Offset */
#define TRAM_RAM1685_REG_OFST          _UINT32_(0x2A54)    /* (TRAM_RAM1685) TrustRAM Offset */
#define TRAM_RAM1686_REG_OFST          _UINT32_(0x2A58)    /* (TRAM_RAM1686) TrustRAM Offset */
#define TRAM_RAM1687_REG_OFST          _UINT32_(0x2A5C)    /* (TRAM_RAM1687) TrustRAM Offset */
#define TRAM_RAM1688_REG_OFST          _UINT32_(0x2A60)    /* (TRAM_RAM1688) TrustRAM Offset */
#define TRAM_RAM1689_REG_OFST          _UINT32_(0x2A64)    /* (TRAM_RAM1689) TrustRAM Offset */
#define TRAM_RAM1690_REG_OFST          _UINT32_(0x2A68)    /* (TRAM_RAM1690) TrustRAM Offset */
#define TRAM_RAM1691_REG_OFST          _UINT32_(0x2A6C)    /* (TRAM_RAM1691) TrustRAM Offset */
#define TRAM_RAM1692_REG_OFST          _UINT32_(0x2A70)    /* (TRAM_RAM1692) TrustRAM Offset */
#define TRAM_RAM1693_REG_OFST          _UINT32_(0x2A74)    /* (TRAM_RAM1693) TrustRAM Offset */
#define TRAM_RAM1694_REG_OFST          _UINT32_(0x2A78)    /* (TRAM_RAM1694) TrustRAM Offset */
#define TRAM_RAM1695_REG_OFST          _UINT32_(0x2A7C)    /* (TRAM_RAM1695) TrustRAM Offset */
#define TRAM_RAM1696_REG_OFST          _UINT32_(0x2A80)    /* (TRAM_RAM1696) TrustRAM Offset */
#define TRAM_RAM1697_REG_OFST          _UINT32_(0x2A84)    /* (TRAM_RAM1697) TrustRAM Offset */
#define TRAM_RAM1698_REG_OFST          _UINT32_(0x2A88)    /* (TRAM_RAM1698) TrustRAM Offset */
#define TRAM_RAM1699_REG_OFST          _UINT32_(0x2A8C)    /* (TRAM_RAM1699) TrustRAM Offset */
#define TRAM_RAM1700_REG_OFST          _UINT32_(0x2A90)    /* (TRAM_RAM1700) TrustRAM Offset */
#define TRAM_RAM1701_REG_OFST          _UINT32_(0x2A94)    /* (TRAM_RAM1701) TrustRAM Offset */
#define TRAM_RAM1702_REG_OFST          _UINT32_(0x2A98)    /* (TRAM_RAM1702) TrustRAM Offset */
#define TRAM_RAM1703_REG_OFST          _UINT32_(0x2A9C)    /* (TRAM_RAM1703) TrustRAM Offset */
#define TRAM_RAM1704_REG_OFST          _UINT32_(0x2AA0)    /* (TRAM_RAM1704) TrustRAM Offset */
#define TRAM_RAM1705_REG_OFST          _UINT32_(0x2AA4)    /* (TRAM_RAM1705) TrustRAM Offset */
#define TRAM_RAM1706_REG_OFST          _UINT32_(0x2AA8)    /* (TRAM_RAM1706) TrustRAM Offset */
#define TRAM_RAM1707_REG_OFST          _UINT32_(0x2AAC)    /* (TRAM_RAM1707) TrustRAM Offset */
#define TRAM_RAM1708_REG_OFST          _UINT32_(0x2AB0)    /* (TRAM_RAM1708) TrustRAM Offset */
#define TRAM_RAM1709_REG_OFST          _UINT32_(0x2AB4)    /* (TRAM_RAM1709) TrustRAM Offset */
#define TRAM_RAM1710_REG_OFST          _UINT32_(0x2AB8)    /* (TRAM_RAM1710) TrustRAM Offset */
#define TRAM_RAM1711_REG_OFST          _UINT32_(0x2ABC)    /* (TRAM_RAM1711) TrustRAM Offset */
#define TRAM_RAM1712_REG_OFST          _UINT32_(0x2AC0)    /* (TRAM_RAM1712) TrustRAM Offset */
#define TRAM_RAM1713_REG_OFST          _UINT32_(0x2AC4)    /* (TRAM_RAM1713) TrustRAM Offset */
#define TRAM_RAM1714_REG_OFST          _UINT32_(0x2AC8)    /* (TRAM_RAM1714) TrustRAM Offset */
#define TRAM_RAM1715_REG_OFST          _UINT32_(0x2ACC)    /* (TRAM_RAM1715) TrustRAM Offset */
#define TRAM_RAM1716_REG_OFST          _UINT32_(0x2AD0)    /* (TRAM_RAM1716) TrustRAM Offset */
#define TRAM_RAM1717_REG_OFST          _UINT32_(0x2AD4)    /* (TRAM_RAM1717) TrustRAM Offset */
#define TRAM_RAM1718_REG_OFST          _UINT32_(0x2AD8)    /* (TRAM_RAM1718) TrustRAM Offset */
#define TRAM_RAM1719_REG_OFST          _UINT32_(0x2ADC)    /* (TRAM_RAM1719) TrustRAM Offset */
#define TRAM_RAM1720_REG_OFST          _UINT32_(0x2AE0)    /* (TRAM_RAM1720) TrustRAM Offset */
#define TRAM_RAM1721_REG_OFST          _UINT32_(0x2AE4)    /* (TRAM_RAM1721) TrustRAM Offset */
#define TRAM_RAM1722_REG_OFST          _UINT32_(0x2AE8)    /* (TRAM_RAM1722) TrustRAM Offset */
#define TRAM_RAM1723_REG_OFST          _UINT32_(0x2AEC)    /* (TRAM_RAM1723) TrustRAM Offset */
#define TRAM_RAM1724_REG_OFST          _UINT32_(0x2AF0)    /* (TRAM_RAM1724) TrustRAM Offset */
#define TRAM_RAM1725_REG_OFST          _UINT32_(0x2AF4)    /* (TRAM_RAM1725) TrustRAM Offset */
#define TRAM_RAM1726_REG_OFST          _UINT32_(0x2AF8)    /* (TRAM_RAM1726) TrustRAM Offset */
#define TRAM_RAM1727_REG_OFST          _UINT32_(0x2AFC)    /* (TRAM_RAM1727) TrustRAM Offset */
#define TRAM_RAM1728_REG_OFST          _UINT32_(0x2B00)    /* (TRAM_RAM1728) TrustRAM Offset */
#define TRAM_RAM1729_REG_OFST          _UINT32_(0x2B04)    /* (TRAM_RAM1729) TrustRAM Offset */
#define TRAM_RAM1730_REG_OFST          _UINT32_(0x2B08)    /* (TRAM_RAM1730) TrustRAM Offset */
#define TRAM_RAM1731_REG_OFST          _UINT32_(0x2B0C)    /* (TRAM_RAM1731) TrustRAM Offset */
#define TRAM_RAM1732_REG_OFST          _UINT32_(0x2B10)    /* (TRAM_RAM1732) TrustRAM Offset */
#define TRAM_RAM1733_REG_OFST          _UINT32_(0x2B14)    /* (TRAM_RAM1733) TrustRAM Offset */
#define TRAM_RAM1734_REG_OFST          _UINT32_(0x2B18)    /* (TRAM_RAM1734) TrustRAM Offset */
#define TRAM_RAM1735_REG_OFST          _UINT32_(0x2B1C)    /* (TRAM_RAM1735) TrustRAM Offset */
#define TRAM_RAM1736_REG_OFST          _UINT32_(0x2B20)    /* (TRAM_RAM1736) TrustRAM Offset */
#define TRAM_RAM1737_REG_OFST          _UINT32_(0x2B24)    /* (TRAM_RAM1737) TrustRAM Offset */
#define TRAM_RAM1738_REG_OFST          _UINT32_(0x2B28)    /* (TRAM_RAM1738) TrustRAM Offset */
#define TRAM_RAM1739_REG_OFST          _UINT32_(0x2B2C)    /* (TRAM_RAM1739) TrustRAM Offset */
#define TRAM_RAM1740_REG_OFST          _UINT32_(0x2B30)    /* (TRAM_RAM1740) TrustRAM Offset */
#define TRAM_RAM1741_REG_OFST          _UINT32_(0x2B34)    /* (TRAM_RAM1741) TrustRAM Offset */
#define TRAM_RAM1742_REG_OFST          _UINT32_(0x2B38)    /* (TRAM_RAM1742) TrustRAM Offset */
#define TRAM_RAM1743_REG_OFST          _UINT32_(0x2B3C)    /* (TRAM_RAM1743) TrustRAM Offset */
#define TRAM_RAM1744_REG_OFST          _UINT32_(0x2B40)    /* (TRAM_RAM1744) TrustRAM Offset */
#define TRAM_RAM1745_REG_OFST          _UINT32_(0x2B44)    /* (TRAM_RAM1745) TrustRAM Offset */
#define TRAM_RAM1746_REG_OFST          _UINT32_(0x2B48)    /* (TRAM_RAM1746) TrustRAM Offset */
#define TRAM_RAM1747_REG_OFST          _UINT32_(0x2B4C)    /* (TRAM_RAM1747) TrustRAM Offset */
#define TRAM_RAM1748_REG_OFST          _UINT32_(0x2B50)    /* (TRAM_RAM1748) TrustRAM Offset */
#define TRAM_RAM1749_REG_OFST          _UINT32_(0x2B54)    /* (TRAM_RAM1749) TrustRAM Offset */
#define TRAM_RAM1750_REG_OFST          _UINT32_(0x2B58)    /* (TRAM_RAM1750) TrustRAM Offset */
#define TRAM_RAM1751_REG_OFST          _UINT32_(0x2B5C)    /* (TRAM_RAM1751) TrustRAM Offset */
#define TRAM_RAM1752_REG_OFST          _UINT32_(0x2B60)    /* (TRAM_RAM1752) TrustRAM Offset */
#define TRAM_RAM1753_REG_OFST          _UINT32_(0x2B64)    /* (TRAM_RAM1753) TrustRAM Offset */
#define TRAM_RAM1754_REG_OFST          _UINT32_(0x2B68)    /* (TRAM_RAM1754) TrustRAM Offset */
#define TRAM_RAM1755_REG_OFST          _UINT32_(0x2B6C)    /* (TRAM_RAM1755) TrustRAM Offset */
#define TRAM_RAM1756_REG_OFST          _UINT32_(0x2B70)    /* (TRAM_RAM1756) TrustRAM Offset */
#define TRAM_RAM1757_REG_OFST          _UINT32_(0x2B74)    /* (TRAM_RAM1757) TrustRAM Offset */
#define TRAM_RAM1758_REG_OFST          _UINT32_(0x2B78)    /* (TRAM_RAM1758) TrustRAM Offset */
#define TRAM_RAM1759_REG_OFST          _UINT32_(0x2B7C)    /* (TRAM_RAM1759) TrustRAM Offset */
#define TRAM_RAM1760_REG_OFST          _UINT32_(0x2B80)    /* (TRAM_RAM1760) TrustRAM Offset */
#define TRAM_RAM1761_REG_OFST          _UINT32_(0x2B84)    /* (TRAM_RAM1761) TrustRAM Offset */
#define TRAM_RAM1762_REG_OFST          _UINT32_(0x2B88)    /* (TRAM_RAM1762) TrustRAM Offset */
#define TRAM_RAM1763_REG_OFST          _UINT32_(0x2B8C)    /* (TRAM_RAM1763) TrustRAM Offset */
#define TRAM_RAM1764_REG_OFST          _UINT32_(0x2B90)    /* (TRAM_RAM1764) TrustRAM Offset */
#define TRAM_RAM1765_REG_OFST          _UINT32_(0x2B94)    /* (TRAM_RAM1765) TrustRAM Offset */
#define TRAM_RAM1766_REG_OFST          _UINT32_(0x2B98)    /* (TRAM_RAM1766) TrustRAM Offset */
#define TRAM_RAM1767_REG_OFST          _UINT32_(0x2B9C)    /* (TRAM_RAM1767) TrustRAM Offset */
#define TRAM_RAM1768_REG_OFST          _UINT32_(0x2BA0)    /* (TRAM_RAM1768) TrustRAM Offset */
#define TRAM_RAM1769_REG_OFST          _UINT32_(0x2BA4)    /* (TRAM_RAM1769) TrustRAM Offset */
#define TRAM_RAM1770_REG_OFST          _UINT32_(0x2BA8)    /* (TRAM_RAM1770) TrustRAM Offset */
#define TRAM_RAM1771_REG_OFST          _UINT32_(0x2BAC)    /* (TRAM_RAM1771) TrustRAM Offset */
#define TRAM_RAM1772_REG_OFST          _UINT32_(0x2BB0)    /* (TRAM_RAM1772) TrustRAM Offset */
#define TRAM_RAM1773_REG_OFST          _UINT32_(0x2BB4)    /* (TRAM_RAM1773) TrustRAM Offset */
#define TRAM_RAM1774_REG_OFST          _UINT32_(0x2BB8)    /* (TRAM_RAM1774) TrustRAM Offset */
#define TRAM_RAM1775_REG_OFST          _UINT32_(0x2BBC)    /* (TRAM_RAM1775) TrustRAM Offset */
#define TRAM_RAM1776_REG_OFST          _UINT32_(0x2BC0)    /* (TRAM_RAM1776) TrustRAM Offset */
#define TRAM_RAM1777_REG_OFST          _UINT32_(0x2BC4)    /* (TRAM_RAM1777) TrustRAM Offset */
#define TRAM_RAM1778_REG_OFST          _UINT32_(0x2BC8)    /* (TRAM_RAM1778) TrustRAM Offset */
#define TRAM_RAM1779_REG_OFST          _UINT32_(0x2BCC)    /* (TRAM_RAM1779) TrustRAM Offset */
#define TRAM_RAM1780_REG_OFST          _UINT32_(0x2BD0)    /* (TRAM_RAM1780) TrustRAM Offset */
#define TRAM_RAM1781_REG_OFST          _UINT32_(0x2BD4)    /* (TRAM_RAM1781) TrustRAM Offset */
#define TRAM_RAM1782_REG_OFST          _UINT32_(0x2BD8)    /* (TRAM_RAM1782) TrustRAM Offset */
#define TRAM_RAM1783_REG_OFST          _UINT32_(0x2BDC)    /* (TRAM_RAM1783) TrustRAM Offset */
#define TRAM_RAM1784_REG_OFST          _UINT32_(0x2BE0)    /* (TRAM_RAM1784) TrustRAM Offset */
#define TRAM_RAM1785_REG_OFST          _UINT32_(0x2BE4)    /* (TRAM_RAM1785) TrustRAM Offset */
#define TRAM_RAM1786_REG_OFST          _UINT32_(0x2BE8)    /* (TRAM_RAM1786) TrustRAM Offset */
#define TRAM_RAM1787_REG_OFST          _UINT32_(0x2BEC)    /* (TRAM_RAM1787) TrustRAM Offset */
#define TRAM_RAM1788_REG_OFST          _UINT32_(0x2BF0)    /* (TRAM_RAM1788) TrustRAM Offset */
#define TRAM_RAM1789_REG_OFST          _UINT32_(0x2BF4)    /* (TRAM_RAM1789) TrustRAM Offset */
#define TRAM_RAM1790_REG_OFST          _UINT32_(0x2BF8)    /* (TRAM_RAM1790) TrustRAM Offset */
#define TRAM_RAM1791_REG_OFST          _UINT32_(0x2BFC)    /* (TRAM_RAM1791) TrustRAM Offset */
#define TRAM_RAM1792_REG_OFST          _UINT32_(0x2C00)    /* (TRAM_RAM1792) TrustRAM Offset */
#define TRAM_RAM1793_REG_OFST          _UINT32_(0x2C04)    /* (TRAM_RAM1793) TrustRAM Offset */
#define TRAM_RAM1794_REG_OFST          _UINT32_(0x2C08)    /* (TRAM_RAM1794) TrustRAM Offset */
#define TRAM_RAM1795_REG_OFST          _UINT32_(0x2C0C)    /* (TRAM_RAM1795) TrustRAM Offset */
#define TRAM_RAM1796_REG_OFST          _UINT32_(0x2C10)    /* (TRAM_RAM1796) TrustRAM Offset */
#define TRAM_RAM1797_REG_OFST          _UINT32_(0x2C14)    /* (TRAM_RAM1797) TrustRAM Offset */
#define TRAM_RAM1798_REG_OFST          _UINT32_(0x2C18)    /* (TRAM_RAM1798) TrustRAM Offset */
#define TRAM_RAM1799_REG_OFST          _UINT32_(0x2C1C)    /* (TRAM_RAM1799) TrustRAM Offset */
#define TRAM_RAM1800_REG_OFST          _UINT32_(0x2C20)    /* (TRAM_RAM1800) TrustRAM Offset */
#define TRAM_RAM1801_REG_OFST          _UINT32_(0x2C24)    /* (TRAM_RAM1801) TrustRAM Offset */
#define TRAM_RAM1802_REG_OFST          _UINT32_(0x2C28)    /* (TRAM_RAM1802) TrustRAM Offset */
#define TRAM_RAM1803_REG_OFST          _UINT32_(0x2C2C)    /* (TRAM_RAM1803) TrustRAM Offset */
#define TRAM_RAM1804_REG_OFST          _UINT32_(0x2C30)    /* (TRAM_RAM1804) TrustRAM Offset */
#define TRAM_RAM1805_REG_OFST          _UINT32_(0x2C34)    /* (TRAM_RAM1805) TrustRAM Offset */
#define TRAM_RAM1806_REG_OFST          _UINT32_(0x2C38)    /* (TRAM_RAM1806) TrustRAM Offset */
#define TRAM_RAM1807_REG_OFST          _UINT32_(0x2C3C)    /* (TRAM_RAM1807) TrustRAM Offset */
#define TRAM_RAM1808_REG_OFST          _UINT32_(0x2C40)    /* (TRAM_RAM1808) TrustRAM Offset */
#define TRAM_RAM1809_REG_OFST          _UINT32_(0x2C44)    /* (TRAM_RAM1809) TrustRAM Offset */
#define TRAM_RAM1810_REG_OFST          _UINT32_(0x2C48)    /* (TRAM_RAM1810) TrustRAM Offset */
#define TRAM_RAM1811_REG_OFST          _UINT32_(0x2C4C)    /* (TRAM_RAM1811) TrustRAM Offset */
#define TRAM_RAM1812_REG_OFST          _UINT32_(0x2C50)    /* (TRAM_RAM1812) TrustRAM Offset */
#define TRAM_RAM1813_REG_OFST          _UINT32_(0x2C54)    /* (TRAM_RAM1813) TrustRAM Offset */
#define TRAM_RAM1814_REG_OFST          _UINT32_(0x2C58)    /* (TRAM_RAM1814) TrustRAM Offset */
#define TRAM_RAM1815_REG_OFST          _UINT32_(0x2C5C)    /* (TRAM_RAM1815) TrustRAM Offset */
#define TRAM_RAM1816_REG_OFST          _UINT32_(0x2C60)    /* (TRAM_RAM1816) TrustRAM Offset */
#define TRAM_RAM1817_REG_OFST          _UINT32_(0x2C64)    /* (TRAM_RAM1817) TrustRAM Offset */
#define TRAM_RAM1818_REG_OFST          _UINT32_(0x2C68)    /* (TRAM_RAM1818) TrustRAM Offset */
#define TRAM_RAM1819_REG_OFST          _UINT32_(0x2C6C)    /* (TRAM_RAM1819) TrustRAM Offset */
#define TRAM_RAM1820_REG_OFST          _UINT32_(0x2C70)    /* (TRAM_RAM1820) TrustRAM Offset */
#define TRAM_RAM1821_REG_OFST          _UINT32_(0x2C74)    /* (TRAM_RAM1821) TrustRAM Offset */
#define TRAM_RAM1822_REG_OFST          _UINT32_(0x2C78)    /* (TRAM_RAM1822) TrustRAM Offset */
#define TRAM_RAM1823_REG_OFST          _UINT32_(0x2C7C)    /* (TRAM_RAM1823) TrustRAM Offset */
#define TRAM_RAM1824_REG_OFST          _UINT32_(0x2C80)    /* (TRAM_RAM1824) TrustRAM Offset */
#define TRAM_RAM1825_REG_OFST          _UINT32_(0x2C84)    /* (TRAM_RAM1825) TrustRAM Offset */
#define TRAM_RAM1826_REG_OFST          _UINT32_(0x2C88)    /* (TRAM_RAM1826) TrustRAM Offset */
#define TRAM_RAM1827_REG_OFST          _UINT32_(0x2C8C)    /* (TRAM_RAM1827) TrustRAM Offset */
#define TRAM_RAM1828_REG_OFST          _UINT32_(0x2C90)    /* (TRAM_RAM1828) TrustRAM Offset */
#define TRAM_RAM1829_REG_OFST          _UINT32_(0x2C94)    /* (TRAM_RAM1829) TrustRAM Offset */
#define TRAM_RAM1830_REG_OFST          _UINT32_(0x2C98)    /* (TRAM_RAM1830) TrustRAM Offset */
#define TRAM_RAM1831_REG_OFST          _UINT32_(0x2C9C)    /* (TRAM_RAM1831) TrustRAM Offset */
#define TRAM_RAM1832_REG_OFST          _UINT32_(0x2CA0)    /* (TRAM_RAM1832) TrustRAM Offset */
#define TRAM_RAM1833_REG_OFST          _UINT32_(0x2CA4)    /* (TRAM_RAM1833) TrustRAM Offset */
#define TRAM_RAM1834_REG_OFST          _UINT32_(0x2CA8)    /* (TRAM_RAM1834) TrustRAM Offset */
#define TRAM_RAM1835_REG_OFST          _UINT32_(0x2CAC)    /* (TRAM_RAM1835) TrustRAM Offset */
#define TRAM_RAM1836_REG_OFST          _UINT32_(0x2CB0)    /* (TRAM_RAM1836) TrustRAM Offset */
#define TRAM_RAM1837_REG_OFST          _UINT32_(0x2CB4)    /* (TRAM_RAM1837) TrustRAM Offset */
#define TRAM_RAM1838_REG_OFST          _UINT32_(0x2CB8)    /* (TRAM_RAM1838) TrustRAM Offset */
#define TRAM_RAM1839_REG_OFST          _UINT32_(0x2CBC)    /* (TRAM_RAM1839) TrustRAM Offset */
#define TRAM_RAM1840_REG_OFST          _UINT32_(0x2CC0)    /* (TRAM_RAM1840) TrustRAM Offset */
#define TRAM_RAM1841_REG_OFST          _UINT32_(0x2CC4)    /* (TRAM_RAM1841) TrustRAM Offset */
#define TRAM_RAM1842_REG_OFST          _UINT32_(0x2CC8)    /* (TRAM_RAM1842) TrustRAM Offset */
#define TRAM_RAM1843_REG_OFST          _UINT32_(0x2CCC)    /* (TRAM_RAM1843) TrustRAM Offset */
#define TRAM_RAM1844_REG_OFST          _UINT32_(0x2CD0)    /* (TRAM_RAM1844) TrustRAM Offset */
#define TRAM_RAM1845_REG_OFST          _UINT32_(0x2CD4)    /* (TRAM_RAM1845) TrustRAM Offset */
#define TRAM_RAM1846_REG_OFST          _UINT32_(0x2CD8)    /* (TRAM_RAM1846) TrustRAM Offset */
#define TRAM_RAM1847_REG_OFST          _UINT32_(0x2CDC)    /* (TRAM_RAM1847) TrustRAM Offset */
#define TRAM_RAM1848_REG_OFST          _UINT32_(0x2CE0)    /* (TRAM_RAM1848) TrustRAM Offset */
#define TRAM_RAM1849_REG_OFST          _UINT32_(0x2CE4)    /* (TRAM_RAM1849) TrustRAM Offset */
#define TRAM_RAM1850_REG_OFST          _UINT32_(0x2CE8)    /* (TRAM_RAM1850) TrustRAM Offset */
#define TRAM_RAM1851_REG_OFST          _UINT32_(0x2CEC)    /* (TRAM_RAM1851) TrustRAM Offset */
#define TRAM_RAM1852_REG_OFST          _UINT32_(0x2CF0)    /* (TRAM_RAM1852) TrustRAM Offset */
#define TRAM_RAM1853_REG_OFST          _UINT32_(0x2CF4)    /* (TRAM_RAM1853) TrustRAM Offset */
#define TRAM_RAM1854_REG_OFST          _UINT32_(0x2CF8)    /* (TRAM_RAM1854) TrustRAM Offset */
#define TRAM_RAM1855_REG_OFST          _UINT32_(0x2CFC)    /* (TRAM_RAM1855) TrustRAM Offset */
#define TRAM_RAM1856_REG_OFST          _UINT32_(0x2D00)    /* (TRAM_RAM1856) TrustRAM Offset */
#define TRAM_RAM1857_REG_OFST          _UINT32_(0x2D04)    /* (TRAM_RAM1857) TrustRAM Offset */
#define TRAM_RAM1858_REG_OFST          _UINT32_(0x2D08)    /* (TRAM_RAM1858) TrustRAM Offset */
#define TRAM_RAM1859_REG_OFST          _UINT32_(0x2D0C)    /* (TRAM_RAM1859) TrustRAM Offset */
#define TRAM_RAM1860_REG_OFST          _UINT32_(0x2D10)    /* (TRAM_RAM1860) TrustRAM Offset */
#define TRAM_RAM1861_REG_OFST          _UINT32_(0x2D14)    /* (TRAM_RAM1861) TrustRAM Offset */
#define TRAM_RAM1862_REG_OFST          _UINT32_(0x2D18)    /* (TRAM_RAM1862) TrustRAM Offset */
#define TRAM_RAM1863_REG_OFST          _UINT32_(0x2D1C)    /* (TRAM_RAM1863) TrustRAM Offset */
#define TRAM_RAM1864_REG_OFST          _UINT32_(0x2D20)    /* (TRAM_RAM1864) TrustRAM Offset */
#define TRAM_RAM1865_REG_OFST          _UINT32_(0x2D24)    /* (TRAM_RAM1865) TrustRAM Offset */
#define TRAM_RAM1866_REG_OFST          _UINT32_(0x2D28)    /* (TRAM_RAM1866) TrustRAM Offset */
#define TRAM_RAM1867_REG_OFST          _UINT32_(0x2D2C)    /* (TRAM_RAM1867) TrustRAM Offset */
#define TRAM_RAM1868_REG_OFST          _UINT32_(0x2D30)    /* (TRAM_RAM1868) TrustRAM Offset */
#define TRAM_RAM1869_REG_OFST          _UINT32_(0x2D34)    /* (TRAM_RAM1869) TrustRAM Offset */
#define TRAM_RAM1870_REG_OFST          _UINT32_(0x2D38)    /* (TRAM_RAM1870) TrustRAM Offset */
#define TRAM_RAM1871_REG_OFST          _UINT32_(0x2D3C)    /* (TRAM_RAM1871) TrustRAM Offset */
#define TRAM_RAM1872_REG_OFST          _UINT32_(0x2D40)    /* (TRAM_RAM1872) TrustRAM Offset */
#define TRAM_RAM1873_REG_OFST          _UINT32_(0x2D44)    /* (TRAM_RAM1873) TrustRAM Offset */
#define TRAM_RAM1874_REG_OFST          _UINT32_(0x2D48)    /* (TRAM_RAM1874) TrustRAM Offset */
#define TRAM_RAM1875_REG_OFST          _UINT32_(0x2D4C)    /* (TRAM_RAM1875) TrustRAM Offset */
#define TRAM_RAM1876_REG_OFST          _UINT32_(0x2D50)    /* (TRAM_RAM1876) TrustRAM Offset */
#define TRAM_RAM1877_REG_OFST          _UINT32_(0x2D54)    /* (TRAM_RAM1877) TrustRAM Offset */
#define TRAM_RAM1878_REG_OFST          _UINT32_(0x2D58)    /* (TRAM_RAM1878) TrustRAM Offset */
#define TRAM_RAM1879_REG_OFST          _UINT32_(0x2D5C)    /* (TRAM_RAM1879) TrustRAM Offset */
#define TRAM_RAM1880_REG_OFST          _UINT32_(0x2D60)    /* (TRAM_RAM1880) TrustRAM Offset */
#define TRAM_RAM1881_REG_OFST          _UINT32_(0x2D64)    /* (TRAM_RAM1881) TrustRAM Offset */
#define TRAM_RAM1882_REG_OFST          _UINT32_(0x2D68)    /* (TRAM_RAM1882) TrustRAM Offset */
#define TRAM_RAM1883_REG_OFST          _UINT32_(0x2D6C)    /* (TRAM_RAM1883) TrustRAM Offset */
#define TRAM_RAM1884_REG_OFST          _UINT32_(0x2D70)    /* (TRAM_RAM1884) TrustRAM Offset */
#define TRAM_RAM1885_REG_OFST          _UINT32_(0x2D74)    /* (TRAM_RAM1885) TrustRAM Offset */
#define TRAM_RAM1886_REG_OFST          _UINT32_(0x2D78)    /* (TRAM_RAM1886) TrustRAM Offset */
#define TRAM_RAM1887_REG_OFST          _UINT32_(0x2D7C)    /* (TRAM_RAM1887) TrustRAM Offset */
#define TRAM_RAM1888_REG_OFST          _UINT32_(0x2D80)    /* (TRAM_RAM1888) TrustRAM Offset */
#define TRAM_RAM1889_REG_OFST          _UINT32_(0x2D84)    /* (TRAM_RAM1889) TrustRAM Offset */
#define TRAM_RAM1890_REG_OFST          _UINT32_(0x2D88)    /* (TRAM_RAM1890) TrustRAM Offset */
#define TRAM_RAM1891_REG_OFST          _UINT32_(0x2D8C)    /* (TRAM_RAM1891) TrustRAM Offset */
#define TRAM_RAM1892_REG_OFST          _UINT32_(0x2D90)    /* (TRAM_RAM1892) TrustRAM Offset */
#define TRAM_RAM1893_REG_OFST          _UINT32_(0x2D94)    /* (TRAM_RAM1893) TrustRAM Offset */
#define TRAM_RAM1894_REG_OFST          _UINT32_(0x2D98)    /* (TRAM_RAM1894) TrustRAM Offset */
#define TRAM_RAM1895_REG_OFST          _UINT32_(0x2D9C)    /* (TRAM_RAM1895) TrustRAM Offset */
#define TRAM_RAM1896_REG_OFST          _UINT32_(0x2DA0)    /* (TRAM_RAM1896) TrustRAM Offset */
#define TRAM_RAM1897_REG_OFST          _UINT32_(0x2DA4)    /* (TRAM_RAM1897) TrustRAM Offset */
#define TRAM_RAM1898_REG_OFST          _UINT32_(0x2DA8)    /* (TRAM_RAM1898) TrustRAM Offset */
#define TRAM_RAM1899_REG_OFST          _UINT32_(0x2DAC)    /* (TRAM_RAM1899) TrustRAM Offset */
#define TRAM_RAM1900_REG_OFST          _UINT32_(0x2DB0)    /* (TRAM_RAM1900) TrustRAM Offset */
#define TRAM_RAM1901_REG_OFST          _UINT32_(0x2DB4)    /* (TRAM_RAM1901) TrustRAM Offset */
#define TRAM_RAM1902_REG_OFST          _UINT32_(0x2DB8)    /* (TRAM_RAM1902) TrustRAM Offset */
#define TRAM_RAM1903_REG_OFST          _UINT32_(0x2DBC)    /* (TRAM_RAM1903) TrustRAM Offset */
#define TRAM_RAM1904_REG_OFST          _UINT32_(0x2DC0)    /* (TRAM_RAM1904) TrustRAM Offset */
#define TRAM_RAM1905_REG_OFST          _UINT32_(0x2DC4)    /* (TRAM_RAM1905) TrustRAM Offset */
#define TRAM_RAM1906_REG_OFST          _UINT32_(0x2DC8)    /* (TRAM_RAM1906) TrustRAM Offset */
#define TRAM_RAM1907_REG_OFST          _UINT32_(0x2DCC)    /* (TRAM_RAM1907) TrustRAM Offset */
#define TRAM_RAM1908_REG_OFST          _UINT32_(0x2DD0)    /* (TRAM_RAM1908) TrustRAM Offset */
#define TRAM_RAM1909_REG_OFST          _UINT32_(0x2DD4)    /* (TRAM_RAM1909) TrustRAM Offset */
#define TRAM_RAM1910_REG_OFST          _UINT32_(0x2DD8)    /* (TRAM_RAM1910) TrustRAM Offset */
#define TRAM_RAM1911_REG_OFST          _UINT32_(0x2DDC)    /* (TRAM_RAM1911) TrustRAM Offset */
#define TRAM_RAM1912_REG_OFST          _UINT32_(0x2DE0)    /* (TRAM_RAM1912) TrustRAM Offset */
#define TRAM_RAM1913_REG_OFST          _UINT32_(0x2DE4)    /* (TRAM_RAM1913) TrustRAM Offset */
#define TRAM_RAM1914_REG_OFST          _UINT32_(0x2DE8)    /* (TRAM_RAM1914) TrustRAM Offset */
#define TRAM_RAM1915_REG_OFST          _UINT32_(0x2DEC)    /* (TRAM_RAM1915) TrustRAM Offset */
#define TRAM_RAM1916_REG_OFST          _UINT32_(0x2DF0)    /* (TRAM_RAM1916) TrustRAM Offset */
#define TRAM_RAM1917_REG_OFST          _UINT32_(0x2DF4)    /* (TRAM_RAM1917) TrustRAM Offset */
#define TRAM_RAM1918_REG_OFST          _UINT32_(0x2DF8)    /* (TRAM_RAM1918) TrustRAM Offset */
#define TRAM_RAM1919_REG_OFST          _UINT32_(0x2DFC)    /* (TRAM_RAM1919) TrustRAM Offset */
#define TRAM_RAM1920_REG_OFST          _UINT32_(0x2E00)    /* (TRAM_RAM1920) TrustRAM Offset */
#define TRAM_RAM1921_REG_OFST          _UINT32_(0x2E04)    /* (TRAM_RAM1921) TrustRAM Offset */
#define TRAM_RAM1922_REG_OFST          _UINT32_(0x2E08)    /* (TRAM_RAM1922) TrustRAM Offset */
#define TRAM_RAM1923_REG_OFST          _UINT32_(0x2E0C)    /* (TRAM_RAM1923) TrustRAM Offset */
#define TRAM_RAM1924_REG_OFST          _UINT32_(0x2E10)    /* (TRAM_RAM1924) TrustRAM Offset */
#define TRAM_RAM1925_REG_OFST          _UINT32_(0x2E14)    /* (TRAM_RAM1925) TrustRAM Offset */
#define TRAM_RAM1926_REG_OFST          _UINT32_(0x2E18)    /* (TRAM_RAM1926) TrustRAM Offset */
#define TRAM_RAM1927_REG_OFST          _UINT32_(0x2E1C)    /* (TRAM_RAM1927) TrustRAM Offset */
#define TRAM_RAM1928_REG_OFST          _UINT32_(0x2E20)    /* (TRAM_RAM1928) TrustRAM Offset */
#define TRAM_RAM1929_REG_OFST          _UINT32_(0x2E24)    /* (TRAM_RAM1929) TrustRAM Offset */
#define TRAM_RAM1930_REG_OFST          _UINT32_(0x2E28)    /* (TRAM_RAM1930) TrustRAM Offset */
#define TRAM_RAM1931_REG_OFST          _UINT32_(0x2E2C)    /* (TRAM_RAM1931) TrustRAM Offset */
#define TRAM_RAM1932_REG_OFST          _UINT32_(0x2E30)    /* (TRAM_RAM1932) TrustRAM Offset */
#define TRAM_RAM1933_REG_OFST          _UINT32_(0x2E34)    /* (TRAM_RAM1933) TrustRAM Offset */
#define TRAM_RAM1934_REG_OFST          _UINT32_(0x2E38)    /* (TRAM_RAM1934) TrustRAM Offset */
#define TRAM_RAM1935_REG_OFST          _UINT32_(0x2E3C)    /* (TRAM_RAM1935) TrustRAM Offset */
#define TRAM_RAM1936_REG_OFST          _UINT32_(0x2E40)    /* (TRAM_RAM1936) TrustRAM Offset */
#define TRAM_RAM1937_REG_OFST          _UINT32_(0x2E44)    /* (TRAM_RAM1937) TrustRAM Offset */
#define TRAM_RAM1938_REG_OFST          _UINT32_(0x2E48)    /* (TRAM_RAM1938) TrustRAM Offset */
#define TRAM_RAM1939_REG_OFST          _UINT32_(0x2E4C)    /* (TRAM_RAM1939) TrustRAM Offset */
#define TRAM_RAM1940_REG_OFST          _UINT32_(0x2E50)    /* (TRAM_RAM1940) TrustRAM Offset */
#define TRAM_RAM1941_REG_OFST          _UINT32_(0x2E54)    /* (TRAM_RAM1941) TrustRAM Offset */
#define TRAM_RAM1942_REG_OFST          _UINT32_(0x2E58)    /* (TRAM_RAM1942) TrustRAM Offset */
#define TRAM_RAM1943_REG_OFST          _UINT32_(0x2E5C)    /* (TRAM_RAM1943) TrustRAM Offset */
#define TRAM_RAM1944_REG_OFST          _UINT32_(0x2E60)    /* (TRAM_RAM1944) TrustRAM Offset */
#define TRAM_RAM1945_REG_OFST          _UINT32_(0x2E64)    /* (TRAM_RAM1945) TrustRAM Offset */
#define TRAM_RAM1946_REG_OFST          _UINT32_(0x2E68)    /* (TRAM_RAM1946) TrustRAM Offset */
#define TRAM_RAM1947_REG_OFST          _UINT32_(0x2E6C)    /* (TRAM_RAM1947) TrustRAM Offset */
#define TRAM_RAM1948_REG_OFST          _UINT32_(0x2E70)    /* (TRAM_RAM1948) TrustRAM Offset */
#define TRAM_RAM1949_REG_OFST          _UINT32_(0x2E74)    /* (TRAM_RAM1949) TrustRAM Offset */
#define TRAM_RAM1950_REG_OFST          _UINT32_(0x2E78)    /* (TRAM_RAM1950) TrustRAM Offset */
#define TRAM_RAM1951_REG_OFST          _UINT32_(0x2E7C)    /* (TRAM_RAM1951) TrustRAM Offset */
#define TRAM_RAM1952_REG_OFST          _UINT32_(0x2E80)    /* (TRAM_RAM1952) TrustRAM Offset */
#define TRAM_RAM1953_REG_OFST          _UINT32_(0x2E84)    /* (TRAM_RAM1953) TrustRAM Offset */
#define TRAM_RAM1954_REG_OFST          _UINT32_(0x2E88)    /* (TRAM_RAM1954) TrustRAM Offset */
#define TRAM_RAM1955_REG_OFST          _UINT32_(0x2E8C)    /* (TRAM_RAM1955) TrustRAM Offset */
#define TRAM_RAM1956_REG_OFST          _UINT32_(0x2E90)    /* (TRAM_RAM1956) TrustRAM Offset */
#define TRAM_RAM1957_REG_OFST          _UINT32_(0x2E94)    /* (TRAM_RAM1957) TrustRAM Offset */
#define TRAM_RAM1958_REG_OFST          _UINT32_(0x2E98)    /* (TRAM_RAM1958) TrustRAM Offset */
#define TRAM_RAM1959_REG_OFST          _UINT32_(0x2E9C)    /* (TRAM_RAM1959) TrustRAM Offset */
#define TRAM_RAM1960_REG_OFST          _UINT32_(0x2EA0)    /* (TRAM_RAM1960) TrustRAM Offset */
#define TRAM_RAM1961_REG_OFST          _UINT32_(0x2EA4)    /* (TRAM_RAM1961) TrustRAM Offset */
#define TRAM_RAM1962_REG_OFST          _UINT32_(0x2EA8)    /* (TRAM_RAM1962) TrustRAM Offset */
#define TRAM_RAM1963_REG_OFST          _UINT32_(0x2EAC)    /* (TRAM_RAM1963) TrustRAM Offset */
#define TRAM_RAM1964_REG_OFST          _UINT32_(0x2EB0)    /* (TRAM_RAM1964) TrustRAM Offset */
#define TRAM_RAM1965_REG_OFST          _UINT32_(0x2EB4)    /* (TRAM_RAM1965) TrustRAM Offset */
#define TRAM_RAM1966_REG_OFST          _UINT32_(0x2EB8)    /* (TRAM_RAM1966) TrustRAM Offset */
#define TRAM_RAM1967_REG_OFST          _UINT32_(0x2EBC)    /* (TRAM_RAM1967) TrustRAM Offset */
#define TRAM_RAM1968_REG_OFST          _UINT32_(0x2EC0)    /* (TRAM_RAM1968) TrustRAM Offset */
#define TRAM_RAM1969_REG_OFST          _UINT32_(0x2EC4)    /* (TRAM_RAM1969) TrustRAM Offset */
#define TRAM_RAM1970_REG_OFST          _UINT32_(0x2EC8)    /* (TRAM_RAM1970) TrustRAM Offset */
#define TRAM_RAM1971_REG_OFST          _UINT32_(0x2ECC)    /* (TRAM_RAM1971) TrustRAM Offset */
#define TRAM_RAM1972_REG_OFST          _UINT32_(0x2ED0)    /* (TRAM_RAM1972) TrustRAM Offset */
#define TRAM_RAM1973_REG_OFST          _UINT32_(0x2ED4)    /* (TRAM_RAM1973) TrustRAM Offset */
#define TRAM_RAM1974_REG_OFST          _UINT32_(0x2ED8)    /* (TRAM_RAM1974) TrustRAM Offset */
#define TRAM_RAM1975_REG_OFST          _UINT32_(0x2EDC)    /* (TRAM_RAM1975) TrustRAM Offset */
#define TRAM_RAM1976_REG_OFST          _UINT32_(0x2EE0)    /* (TRAM_RAM1976) TrustRAM Offset */
#define TRAM_RAM1977_REG_OFST          _UINT32_(0x2EE4)    /* (TRAM_RAM1977) TrustRAM Offset */
#define TRAM_RAM1978_REG_OFST          _UINT32_(0x2EE8)    /* (TRAM_RAM1978) TrustRAM Offset */
#define TRAM_RAM1979_REG_OFST          _UINT32_(0x2EEC)    /* (TRAM_RAM1979) TrustRAM Offset */
#define TRAM_RAM1980_REG_OFST          _UINT32_(0x2EF0)    /* (TRAM_RAM1980) TrustRAM Offset */
#define TRAM_RAM1981_REG_OFST          _UINT32_(0x2EF4)    /* (TRAM_RAM1981) TrustRAM Offset */
#define TRAM_RAM1982_REG_OFST          _UINT32_(0x2EF8)    /* (TRAM_RAM1982) TrustRAM Offset */
#define TRAM_RAM1983_REG_OFST          _UINT32_(0x2EFC)    /* (TRAM_RAM1983) TrustRAM Offset */
#define TRAM_RAM1984_REG_OFST          _UINT32_(0x2F00)    /* (TRAM_RAM1984) TrustRAM Offset */
#define TRAM_RAM1985_REG_OFST          _UINT32_(0x2F04)    /* (TRAM_RAM1985) TrustRAM Offset */
#define TRAM_RAM1986_REG_OFST          _UINT32_(0x2F08)    /* (TRAM_RAM1986) TrustRAM Offset */
#define TRAM_RAM1987_REG_OFST          _UINT32_(0x2F0C)    /* (TRAM_RAM1987) TrustRAM Offset */
#define TRAM_RAM1988_REG_OFST          _UINT32_(0x2F10)    /* (TRAM_RAM1988) TrustRAM Offset */
#define TRAM_RAM1989_REG_OFST          _UINT32_(0x2F14)    /* (TRAM_RAM1989) TrustRAM Offset */
#define TRAM_RAM1990_REG_OFST          _UINT32_(0x2F18)    /* (TRAM_RAM1990) TrustRAM Offset */
#define TRAM_RAM1991_REG_OFST          _UINT32_(0x2F1C)    /* (TRAM_RAM1991) TrustRAM Offset */
#define TRAM_RAM1992_REG_OFST          _UINT32_(0x2F20)    /* (TRAM_RAM1992) TrustRAM Offset */
#define TRAM_RAM1993_REG_OFST          _UINT32_(0x2F24)    /* (TRAM_RAM1993) TrustRAM Offset */
#define TRAM_RAM1994_REG_OFST          _UINT32_(0x2F28)    /* (TRAM_RAM1994) TrustRAM Offset */
#define TRAM_RAM1995_REG_OFST          _UINT32_(0x2F2C)    /* (TRAM_RAM1995) TrustRAM Offset */
#define TRAM_RAM1996_REG_OFST          _UINT32_(0x2F30)    /* (TRAM_RAM1996) TrustRAM Offset */
#define TRAM_RAM1997_REG_OFST          _UINT32_(0x2F34)    /* (TRAM_RAM1997) TrustRAM Offset */
#define TRAM_RAM1998_REG_OFST          _UINT32_(0x2F38)    /* (TRAM_RAM1998) TrustRAM Offset */
#define TRAM_RAM1999_REG_OFST          _UINT32_(0x2F3C)    /* (TRAM_RAM1999) TrustRAM Offset */
#define TRAM_RAM2000_REG_OFST          _UINT32_(0x2F40)    /* (TRAM_RAM2000) TrustRAM Offset */
#define TRAM_RAM2001_REG_OFST          _UINT32_(0x2F44)    /* (TRAM_RAM2001) TrustRAM Offset */
#define TRAM_RAM2002_REG_OFST          _UINT32_(0x2F48)    /* (TRAM_RAM2002) TrustRAM Offset */
#define TRAM_RAM2003_REG_OFST          _UINT32_(0x2F4C)    /* (TRAM_RAM2003) TrustRAM Offset */
#define TRAM_RAM2004_REG_OFST          _UINT32_(0x2F50)    /* (TRAM_RAM2004) TrustRAM Offset */
#define TRAM_RAM2005_REG_OFST          _UINT32_(0x2F54)    /* (TRAM_RAM2005) TrustRAM Offset */
#define TRAM_RAM2006_REG_OFST          _UINT32_(0x2F58)    /* (TRAM_RAM2006) TrustRAM Offset */
#define TRAM_RAM2007_REG_OFST          _UINT32_(0x2F5C)    /* (TRAM_RAM2007) TrustRAM Offset */
#define TRAM_RAM2008_REG_OFST          _UINT32_(0x2F60)    /* (TRAM_RAM2008) TrustRAM Offset */
#define TRAM_RAM2009_REG_OFST          _UINT32_(0x2F64)    /* (TRAM_RAM2009) TrustRAM Offset */
#define TRAM_RAM2010_REG_OFST          _UINT32_(0x2F68)    /* (TRAM_RAM2010) TrustRAM Offset */
#define TRAM_RAM2011_REG_OFST          _UINT32_(0x2F6C)    /* (TRAM_RAM2011) TrustRAM Offset */
#define TRAM_RAM2012_REG_OFST          _UINT32_(0x2F70)    /* (TRAM_RAM2012) TrustRAM Offset */
#define TRAM_RAM2013_REG_OFST          _UINT32_(0x2F74)    /* (TRAM_RAM2013) TrustRAM Offset */
#define TRAM_RAM2014_REG_OFST          _UINT32_(0x2F78)    /* (TRAM_RAM2014) TrustRAM Offset */
#define TRAM_RAM2015_REG_OFST          _UINT32_(0x2F7C)    /* (TRAM_RAM2015) TrustRAM Offset */
#define TRAM_RAM2016_REG_OFST          _UINT32_(0x2F80)    /* (TRAM_RAM2016) TrustRAM Offset */
#define TRAM_RAM2017_REG_OFST          _UINT32_(0x2F84)    /* (TRAM_RAM2017) TrustRAM Offset */
#define TRAM_RAM2018_REG_OFST          _UINT32_(0x2F88)    /* (TRAM_RAM2018) TrustRAM Offset */
#define TRAM_RAM2019_REG_OFST          _UINT32_(0x2F8C)    /* (TRAM_RAM2019) TrustRAM Offset */
#define TRAM_RAM2020_REG_OFST          _UINT32_(0x2F90)    /* (TRAM_RAM2020) TrustRAM Offset */
#define TRAM_RAM2021_REG_OFST          _UINT32_(0x2F94)    /* (TRAM_RAM2021) TrustRAM Offset */
#define TRAM_RAM2022_REG_OFST          _UINT32_(0x2F98)    /* (TRAM_RAM2022) TrustRAM Offset */
#define TRAM_RAM2023_REG_OFST          _UINT32_(0x2F9C)    /* (TRAM_RAM2023) TrustRAM Offset */
#define TRAM_RAM2024_REG_OFST          _UINT32_(0x2FA0)    /* (TRAM_RAM2024) TrustRAM Offset */
#define TRAM_RAM2025_REG_OFST          _UINT32_(0x2FA4)    /* (TRAM_RAM2025) TrustRAM Offset */
#define TRAM_RAM2026_REG_OFST          _UINT32_(0x2FA8)    /* (TRAM_RAM2026) TrustRAM Offset */
#define TRAM_RAM2027_REG_OFST          _UINT32_(0x2FAC)    /* (TRAM_RAM2027) TrustRAM Offset */
#define TRAM_RAM2028_REG_OFST          _UINT32_(0x2FB0)    /* (TRAM_RAM2028) TrustRAM Offset */
#define TRAM_RAM2029_REG_OFST          _UINT32_(0x2FB4)    /* (TRAM_RAM2029) TrustRAM Offset */
#define TRAM_RAM2030_REG_OFST          _UINT32_(0x2FB8)    /* (TRAM_RAM2030) TrustRAM Offset */
#define TRAM_RAM2031_REG_OFST          _UINT32_(0x2FBC)    /* (TRAM_RAM2031) TrustRAM Offset */
#define TRAM_RAM2032_REG_OFST          _UINT32_(0x2FC0)    /* (TRAM_RAM2032) TrustRAM Offset */
#define TRAM_RAM2033_REG_OFST          _UINT32_(0x2FC4)    /* (TRAM_RAM2033) TrustRAM Offset */
#define TRAM_RAM2034_REG_OFST          _UINT32_(0x2FC8)    /* (TRAM_RAM2034) TrustRAM Offset */
#define TRAM_RAM2035_REG_OFST          _UINT32_(0x2FCC)    /* (TRAM_RAM2035) TrustRAM Offset */
#define TRAM_RAM2036_REG_OFST          _UINT32_(0x2FD0)    /* (TRAM_RAM2036) TrustRAM Offset */
#define TRAM_RAM2037_REG_OFST          _UINT32_(0x2FD4)    /* (TRAM_RAM2037) TrustRAM Offset */
#define TRAM_RAM2038_REG_OFST          _UINT32_(0x2FD8)    /* (TRAM_RAM2038) TrustRAM Offset */
#define TRAM_RAM2039_REG_OFST          _UINT32_(0x2FDC)    /* (TRAM_RAM2039) TrustRAM Offset */
#define TRAM_RAM2040_REG_OFST          _UINT32_(0x2FE0)    /* (TRAM_RAM2040) TrustRAM Offset */
#define TRAM_RAM2041_REG_OFST          _UINT32_(0x2FE4)    /* (TRAM_RAM2041) TrustRAM Offset */
#define TRAM_RAM2042_REG_OFST          _UINT32_(0x2FE8)    /* (TRAM_RAM2042) TrustRAM Offset */
#define TRAM_RAM2043_REG_OFST          _UINT32_(0x2FEC)    /* (TRAM_RAM2043) TrustRAM Offset */
#define TRAM_RAM2044_REG_OFST          _UINT32_(0x2FF0)    /* (TRAM_RAM2044) TrustRAM Offset */
#define TRAM_RAM2045_REG_OFST          _UINT32_(0x2FF4)    /* (TRAM_RAM2045) TrustRAM Offset */
#define TRAM_RAM2046_REG_OFST          _UINT32_(0x2FF8)    /* (TRAM_RAM2046) TrustRAM Offset */
#define TRAM_RAM2047_REG_OFST          _UINT32_(0x2FFC)    /* (TRAM_RAM2047) TrustRAM Offset */

#if !(defined(__ASSEMBLER__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief TRAM register API structure */
typedef struct
{  /* TrustRAM */
  __IO  uint32_t                       TRAM_CTRLA;         /**< Offset: 0x00 (R/W  32) Control */
  __IO  uint32_t                       TRAM_INTENCLR;      /**< Offset: 0x04 (R/W  32) Interrupt Enable Clear */
  __IO  uint32_t                       TRAM_INTENSET;      /**< Offset: 0x08 (R/W  32) Interrupt Enable Set */
  __IO  uint32_t                       TRAM_INTFLAG;       /**< Offset: 0x0C (R/W  32) Interrupt Flag Status and Clear */
  __I   uint32_t                       TRAM_STATUS;        /**< Offset: 0x10 (R/   32) Status */
  __I   uint32_t                       TRAM_SYNCBUSY;      /**< Offset: 0x14 (R/   32) Synchronization Busy Status */
  __O   uint32_t                       TRAM_DSCC;          /**< Offset: 0x18 ( /W  32) Data Scramble Control */
  __O   uint32_t                       TRAM_PERMW;         /**< Offset: 0x1C ( /W  32) Permutation Write */
  __I   uint32_t                       TRAM_PERMR;         /**< Offset: 0x20 (R/   32) Permutation Read */
  __I   uint8_t                        Reserved1[0xFDC];
  __IO  uint32_t                       TRAM_RAM[2048];     /**< Offset: 0x1000 (R/W  32) TrustRAM */
} tram_registers_t;


#endif /* !(defined(__ASSEMBLER__) || defined(__IAR_SYSTEMS_ASM__)) */
#endif /* _PIC32CKSG01_TRAM_COMPONENT_H_ */
