/**
 ******************************************************************************
 * @file    Cloud/AWS/Src/stm32l4xx_hal_msp.c
 * @author  MCD Application Team
 * @version V1.0.1
 * @date    12-April-2017
 * @brief   MSP Initialization and de-Initialization.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2017 STMicroelectronics International N.V.
 * All rights reserved.</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted, provided that the following conditions are met:
 *
 * 1. Redistribution of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of STMicroelectronics nor the names of other
 *    contributors to this software may be used to endorse or promote products
 *    derived from this software without specific written permission.
 * 4. This software, including modifications and/or derivative works of this
 *    software, must execute solely and exclusively on microcontroller or
 *    microprocessor devices manufactured by or for STMicroelectronics.
 * 5. Redistribution and use of this software other than as permitted under
 *    this license is void and will automatically terminate your rights under
 *    this license.
 *
 * THIS SOFTWARE IS PROVIDED BY STMICROELECTRONICS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS, IMPLIED OR STATUTORY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NON-INFRINGEMENT OF THIRD PARTY INTELLECTUAL PROPERTY
 * RIGHTS ARE DISCLAIMED TO THE FULLEST EXTENT PERMITTED BY LAW. IN NO EVENT
 * SHALL STMICROELECTRONICS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#define ARD_D13_Pin          GPIO_PIN_5
#define ARD_D13_GPIO_Port    GPIOA
#define ARD_D12_Pin          GPIO_PIN_6
#define ARD_D12_GPIO_Port    GPIOA
#define ARD_D11_Pin          GPIO_PIN_7
#define ARD_D11_GPIO_Port    GPIOA

/**
 * Initializes the Global MSP.
 */

void HAL_RNG_MspInit( RNG_HandleTypeDef * hrng )
{
    if( hrng->Instance == RNG )
    {
        /* Peripheral clock enable */
        __HAL_RCC_RNG_CLK_ENABLE();
    }
}

void HAL_RNG_MspDeInit( RNG_HandleTypeDef * hrng )
{
    if( hrng->Instance == RNG )
    {
        /* Peripheral clock disable */
        __HAL_RCC_RNG_CLK_DISABLE();
    }
}

void HAL_RTC_MspInit( RTC_HandleTypeDef * hrtc )
{
    if( hrtc->Instance == RTC )
    {
        __HAL_RCC_RTC_ENABLE();
    }
}

void HAL_RTC_MspDeInit( RTC_HandleTypeDef * hrtc )
{
    if( hrtc->Instance == RTC )
    {
        /* Peripheral clock disable */
        __HAL_RCC_RTC_DISABLE();
    }
}

/* Generated by STM32CubeMX with modification on PA15 and PB7. */
void HAL_UART_MspInit( UART_HandleTypeDef * uartHandle )
{
    GPIO_InitTypeDef GPIO_InitStruct = { 0 };

    if( uartHandle->Instance == UART4 )
    {
        /* USER CODE BEGIN UART4_MspInit 0 */

        /* USER CODE END UART4_MspInit 0 */
        /* UART4 clock enable */
        __HAL_RCC_UART4_CLK_ENABLE();

        __HAL_RCC_GPIOA_CLK_ENABLE();
        __HAL_RCC_GPIOB_CLK_ENABLE();

        /* PA0 is mapped to UART4_TX and PA1 is mapped to UART4_RX. */
        GPIO_InitStruct.Pin = GPIO_PIN_0 | GPIO_PIN_1;
        GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull = GPIO_NOPULL;
        GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_VERY_HIGH;
        GPIO_InitStruct.Alternate = GPIO_AF8_UART4;
        HAL_GPIO_Init( GPIOA, &GPIO_InitStruct );

        /* PA15 (JTDI) is mapped to UART4_RTS and PB7 is mapped to UART4_CTS. They are not initialized on purpose. */
        /* GPIO 7 is also used as UART1 RX. */

        /* UART4 interrupt Init */
        HAL_NVIC_SetPriority( UART4_IRQn, 0, 0 );
        HAL_NVIC_EnableIRQ( UART4_IRQn );
        /* USER CODE BEGIN UART4_MspInit 1 */

        /* USER CODE END UART4_MspInit 1 */
    }
}

/* Generated by STM32CubeMX with modification on PA15 and PB7. */
void HAL_UART_MspDeInit( UART_HandleTypeDef * uartHandle )
{
    if( uartHandle->Instance == UART4 )
    {
        /* USER CODE BEGIN UART4_MspDeInit 0 */

        /* USER CODE END UART4_MspDeInit 0 */
        /* Peripheral clock disable */
        __HAL_RCC_UART4_CLK_DISABLE();

        HAL_GPIO_DeInit( GPIOA, GPIO_PIN_0 | GPIO_PIN_1 );

        /* UART4 interrupt Deinit */
        HAL_NVIC_DisableIRQ( UART4_IRQn );
        /* USER CODE BEGIN UART4_MspDeInit 1 */

        /* USER CODE END UART4_MspDeInit 1 */
    }
}

void HAL_SPI_MspInit( SPI_HandleTypeDef * hspi )
{
    GPIO_InitTypeDef GPIO_InitStruct = { 0 };

    if( hspi->Instance == SPI1 )
    {
        /* Peripheral clock enable */
        __HAL_RCC_SPI1_CLK_ENABLE();

        __HAL_RCC_GPIOA_CLK_ENABLE();

        /**SPI1 GPIO Configuration
         * PA4     ------> SPI1_NSS
         * PA5     ------> SPI1_SCK
         * PA6     ------> SPI1_MISO
         * PA7     ------> SPI1_MOSI
         */
        GPIO_InitStruct.Pin = GPIO_PIN_4 | ARD_D13_Pin | ARD_D12_Pin | ARD_D11_Pin;
        GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull = GPIO_NOPULL;
        GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_VERY_HIGH;
        GPIO_InitStruct.Alternate = GPIO_AF5_SPI1;
        HAL_GPIO_Init( GPIOA, &GPIO_InitStruct );
    }
}

void HAL_SPI_MspDeInit( SPI_HandleTypeDef * hspi )
{
    if( hspi->Instance == SPI1 )
    {
        __HAL_RCC_SPI1_CLK_ENABLE();
        HAL_GPIO_DeInit( GPIOA, GPIO_PIN_4 | ARD_D13_Pin | ARD_D12_Pin | ARD_D11_Pin );
        /* SPI1 interrupt Deinit */
        HAL_NVIC_DisableIRQ( SPI1_IRQn );
    }
}

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
