@echo off

rem This is normally called by the dispatcher tool.
rem Arg 1: ${file} - The path to the core dump payload file of the selected alert.
rem Arg 2: ${revision} - The revision field from the metadata of the selected alert.
rem Arg 3: ${product} - The product name, based on the ProductID in the alert metadata.

call set "ELF_PATH=%%ELF_PATH:${revision}=%~2%%%"
call set "ELF_PATH=%%ELF_PATH:${product}=%~3%%%"
echo Expanded ELF_PATH: %ELF_PATH%

if defined SRC_PATH (    
	call set "SRC_PATH=%%SRC_PATH:${revision}=%~2%%%"
    call set "SRC_PATH=%%SRC_PATH:${product}=%~3%%%"    	
)
echo Expanded SRC_PATH: %SRC_PATH%

if defined SUBST_PATH_TO (
    call set "SUBST_PATH_TO=%%SUBST_PATH_TO:${revision}=%~2%%%"
    call set "SUBST_PATH_TO=%%SUBST_PATH_TO:${product}=%~3%%%"    
)
echo Expanded SUBST_PATH_TO: %SUBST_PATH_TO%

rem Avoids double quotes
set ELF_PATH_WITHOUT_QUOTES=%ELF_PATH:"=%

rem %~1 provides first argument without quotes.
set CORE_DUMP_PATH_WITHOUT_QUOTES=%~1

rem Avoids an annoying warning.
set "XDG_CACHE_HOME=%TEMP%"

rem The --gdb option show output in a gdb window, with some colors.
rem If omitted, a text file is created and opened instead.
coredumpviewer/crash_debug.bat "%ELF_PATH_WITHOUT_QUOTES%" "%CORE_DUMP_PATH_WITHOUT_QUOTES%" --gdb

pause



