rem @echo off
SETLOCAL

rem This script will work if gdb and CrashDebug executables
rem are located in the same directory as the script

rem NOTE: SRC_PATH, SUBST_PATH_FROM and SUBST_PATH_TO are provided as env vars.

set CURRENT_DIR=%~dp0
set GDB=%CURRENT_DIR%arm-none-eabi-gdb.exe
rem CrashDebug path must use forward slash
set CRASHDEBUG=%CURRENT_DIR:\=/%CrashDebug.exe

if "%~1" == "" if [%1] == [] call :Usage & goto :ExitScript
if "%~2" == "" if [%2] == [] call :Usage & goto :ExitScript
if not [%3] == [] if not "%~3" == "--gdb" call :Usage & goto :ExitScript

if not exist %1% (
    echo.
    echo Elf file does not exist
    goto UsageAndExit
)
if not exist %2% (
    echo.
    echo Dump file does not exist
    goto UsageAndExit
)

if defined SUBST_PATH_FROM (
   rem The command is only applied if the parameter is defined in project-settings.bat.
   set SUBST_CMD=-ex "set substitute-path %SUBST_PATH_FROM% %SUBST_PATH_TO%"
)

if defined SRC_PATH (
   rem The command is only applied if the parameter is defined in project-settings.bat.
   set DIRECTORY_CMD=-ex "set directories %SRC_PATH%"
)

set ELF=%1
set ELF=%ELF:\=\\%
set DUMP=%2
set DUMP=%DUMP:\=\\%

rem Make sure there are no trailing whitespace after ^ (used for multiline commands)
rem To debug errors in the gdb commands below, add -ex "set trace-commands on" ^ 
	
%GDB% -q -ex "set target-charset ASCII" ^
	            %DIRECTORY_CMD% ^
				%SUBST_CMD% ^
				-ex "set pagination off" ^
			-ex "set filename-display basename" ^
			-ex "set target-charset ASCII" ^
			-ex "set architecture armv7e-m" ^
			-ex "set arm fpu vfp" ^
			-ex "file %ELF%" ^
				-ex "target remote | %CRASHDEBUG% --elf %ELF% --dump %DUMP%" ^
				-ex "echo \n\n=== Registers ================\n" -ex "info registers" ^
			-ex "echo \n\n=== Fault Status Registers ===\n" ^
			-ex "printf \"Configurable Fault Status Register (CFSR): 0x%%08x\n\", *(unsigned int*)0xE000ED28" ^
			-ex "printf \"HardFault Status Register (HFSR):          0x%%08x\n\", *(unsigned int*)0xE000ED2C" ^
			-ex "printf \"Debug Fault Status Register (DFSR):        0x%%08x\n\", *(unsigned int*)0xE000ED30" ^
			-ex "printf \"MemManage Fault Address Register (MMFAR):  0x%%08x\n\", *(unsigned int*)0xE000ED34" ^
			-ex "printf \"BusFault Address Register (BFAR):          0x%%08x\n\", *(unsigned int*)0xE000ED38" ^
			-ex "echo \n\n=== Disassembly ==============\n" -ex "disassemble $pc-24, $pc+8" ^
				-ex "echo \n\n=== Call Stack ===============\n" -ex "bt -full" ^
			-ex "echo \n\n=== Source Code ==============\n" ^
			-ex "list *$pc"
	
goto ExitScript


:UsageAndExit
call :Usage
goto :ExitScript

:Usage
echo.
echo Usage:
echo 	crash_debug.bat ^<elf-file^> ^<crash-dump-file^> [--gdb]
echo.
echo 	Options:
echo 	--gdb		: Keep the gdb session active
echo.
exit /b 0

:ExitScript

pause
				