#!/bin/bash


# TODO: Specify path to CrashDebug and a texteditor
CRASH_DEBUG=$HOME/devel/CrashDebug/bins/lin64/CrashDebug
EDITOR=nano

ELF=$1
DUMP=$2
GDB=$3

function usageAndExit {
    echo
    echo "      Usage:"
    echo "          $0  <elf-file> <crash-dump-file> [--gdb]"
    echo
    echo "      --gdb      : Do not exit gdb session"
    echo
    exit 1
}
[[ -z $ELF ]] && echo "No elf-file speicfied" && usageAndExit
[[ -z $DUMP ]] && echo "No crash dump specified" && usageAndExit
[[ ! -f $ELF ]] && echo "Elf file \"$ELF\" does not exist" && exit 1
[[ ! -f $DUMP ]] && echo "Dump file \"$DUMP\" does not exist" && exit 1

if [ -z $GDB ]; then
    gdb-multiarch $ELF -ex "set target-charset ASCII" -ex "target remote | $CRASH_DEBUG --elf $ELF --dump $DUMP" -quiet -ex "bt" -ex "echo Fault status registers\n" -ex "x/5xw 0xE000ED28" -ex "info registers" -ex "kill inferiors 1" -ex quit > crash_dump.txt
    $EDITOR crash_dump.txt
else
    gdb-multiarch $ELF -ex "set target-charset ASCII" -ex "target remote | $CRASH_DEBUG --elf $ELF --dump $DUMP" -quiet -ex "bt" -ex "echo Fault status registers\n" -ex "x/5xw 0xE000ED28" -ex "info registers"
fi
