@echo off
SETLOCAL

set CURRENT_DIR=%~dp0

REM check input
if "%~1" == "" if [%1] == [] call :Usage & goto :ExitScript
if "%~2" == "" if [%2] == [] call :Usage & goto :ExitScript

set PRODUCT=%1
set REVISION=%2

REM check if already fetched
set OUTPUT=%CURRENT_DIR%\$PRODUCT\$REVISION\file.elf
if exist %OUTPUT% (
    echo Already fetched %OUTPUT before
    goto ExitScript
)

REM split input
for /f "tokens=1 delims=-" %%a in ("%PRODUCT%") do (
  if "%MODULE%" == "" (
    set MODULE=%%a
  )
)
if "%MODULE%" == "" call :Usage & goto :ExitScript
for /f "tokens=1 delims=-" %%a in ("%REVISION%") do (
  if "%RELEASE%" == "" (
    set RELEASE=%%a
  )
)
if "%RELEASE%" == "" call :Usage & goto :ExitScript

REM fetch from repo
echo curl http://source.url:1234/root/repo/%MODULE%/%PRODUCT%/%RELEASE%/%REVISION%/%PRODUCT%-%REVISION%.zip

REM add code if needed to unpack and write to correct location
goto :ExitScript

:UsageAndExit
call :Usage
goto :ExitScript

:Usage
echo.
echo Usage:
echo 	pre_script.bat ^<product-module^> ^<revision-release^>
echo.
exit /b 0

:ExitScript
