#!/bin/bash

PRODUCT=$1
REVISION=$2

function usageAndExit {
    echo
    echo "      Usage:"
    echo "          $0  <product-module> <revision-release>"
    echo
    exit 1
}

# check input
[[ -z $PRODUCT ]] && echo "No product speicfied" && usageAndExit
[[ -z $REVISION ]] && echo "No revision specified" && usageAndExit

# check if already fetched
OUTPUT=/home/user/cache/$PRODUCT/$REVISION/file.elf
[[ -f $OUTPUT ]] && echo "Already fetched \"$OUTPUT\" before" && exit 1

# split input
MODULE=`echo $PRODUCT | cut -d "-" -f 1`
[[ -z $PRODUCT ]] && echo "Could not extract module from product" && usageAndExit

RELEASE=`echo $REVISION | cut -d "-" -f 1`
[[ -z $RELEASE ]] && echo "Could not extract release from revision" && usageAndExit

# fetch from repo
echo curl http://source.url:1234/root/repo/$MODULE/$PRODUCT/$RELEASE/$REVISION/$PRODUCT-$REVISION.zip

# add code if needed to unpack and write to correct location
