rem Ensures the Detect files are not blocked by Windows.

@echo off
setlocal
pushd "%~dp0"

rem === configure: one probe file relative to this .bat ===
set "PROBE_FILE=tracealyzer\Tracealyzer.Application.dll"

rem Require Windows PowerShell
where powershell.exe >nul 2>&1
if errorlevel 1 goto :no_ps

rem Normalize probe to an absolute path (handles quotes/spaces)
set "PF=%PROBE_FILE%"
set "PF=%PF:"=%"
for %%I in ("%CD%\%PF%") do set "PROBE_ABS=%%~fI"

powershell.exe -NoProfile -ExecutionPolicy Bypass -Command ^
  "$ErrorActionPreference='Stop';" ^
  "$root = (Resolve-Path '.');" ^
  "$probe = $env:PROBE_ABS;" ^
  "$needs = $true;" ^
  "if ($probe -and (Test-Path -LiteralPath $probe)) {" ^
  "  $needs = [bool](Get-Item -LiteralPath $probe -Stream 'Zone.Identifier' -ErrorAction SilentlyContinue)" ^
  "} else { $needs = $true };" ^
  "if (-not $needs) { Write-Host 'Directory check: OK'; exit 0 }" ^
  "$files = Get-ChildItem -LiteralPath $root -Recurse -Force -File;" ^
  "foreach($f in $files){" ^
  "  if (Get-Item -LiteralPath $f.FullName -Stream 'Zone.Identifier' -ErrorAction SilentlyContinue) {" ^
  "    Remove-Item -LiteralPath $f.FullName -Stream 'Zone.Identifier' -ErrorAction SilentlyContinue" ^
  "  }" ^
  "};" ^
  "$still=0; foreach($f in $files){ if (Get-Item -LiteralPath $f.FullName -Stream 'Zone.Identifier' -ErrorAction SilentlyContinue){ $still++ } };" ^
  "if ($still -gt 0) { exit 2 } else { exit 0 }"

set "RC=%ERRORLEVEL%"
if "%RC%"=="0" goto :done
if "%RC%"=="2" goto :still_blocked
goto :ps_fail

:no_ps
echo Warning, unblock.bat failed - could not ensure the Detect client folder is unblocked. 
echo Make sure to unblock the Detect zip archive manually before extracting it (right-click, properties).
popd
endlocal & exit /b 1

:ps_fail
echo Warning, unblock.bat failed - could not ensure the Detect client folder is unblocked. 
echo Make sure to unblock the Detect zip archive manually before extracting it (right-click, properties).
popd
endlocal & exit /b 1

:still_blocked
echo Warning, unblock.bat failed - could not ensure the Detect client folder is unblocked. 
echo Make sure to unblock the Detect zip archive manually before extracting it (right-click, properties).
popd
endlocal & exit /b 2

:done
popd
endlocal & exit /b 0
