import os, getpass, platform

# If your alert files or ELF files are not available in the file system (locally
# or in mounted network/cloud folders), use these hooks to download them from a
# remote storage service.

# Hooks are only called if the corresponding enable flag is True.
enable_start_hook = False
enable_download_alert_hook = False
enable_download_elf_hook = False
enable_download_src_hook = False

# For the example in once_on_start 
user = None
token = None

# once_on_start - Called once when the client is started.
# Can be used for custom initialization or getting credentials for the download hook.
def once_on_start():

    # Example: Read credentials for the download hook
    global user, token
    if not token:
        print("(start hook) Enter credentials for the Client download hook")
    if not user:        
        user = input("  Username: ")
    if not token:
        token = getpass.getpass("  Token/password: ")
    
# download_alert_file - Called for every requested alert file
# 
# Arguments:
#
#  - filename: the filename that should be downloaded (filename only, not full path)
#  - remote_relative_path: the path to the alert folder, relative to the remote base directory. Needs to be combinded with filename.
#  - local_destination_dir: the path to the local directory where the file should be stored (excluding the filename)
def download_alert_file(filename, remote_relative_path, local_destination_dir):
    
    # Example on how to download alert files from remote storage.
        
    # Update to match your storage API
    url = "https://server:port/storage/detect" + remote_relative_path + "/" + filename
        
    print("userhooks.download_payload_file:"
          "\n    Remote source path: " + url + 
          "\n    Local destination path: " + local_destination_dir + "/" + filename)
    
    # os.system("Use curl or wget on the url to download the requested file");
    
    #   For authentication, enable the start hook to enter credentials on startup.    
    #   See once_on_start for details.
   
    # Return False on any download errors to abort processing the request further.
    return True

# download_elf_file - Hook for downloading elf image files.
# To show payloads such as core dumps and certain traces, the client needs to ELF file from the
# build, the exact same version as programmed on the device. For traces, this is only needed is
# using if using the xTracePrintCompact... functions and/or xTraceDependencyRegister().
# Use the arguments to construct the remote path, matching the right ELF file, and to save it to
# the expected location.
#
# Arguments:
#
#  - product_id: The numeric product ID defined in the target-side DFM library.
#    This is defined by DFM_CFG_PRODUCTID in dfmConfig.h and is here provided as a string.
#
#  - revision: The revision attribute from the target-side DFM library, i.e. the device software version.
#    This is defined by DFM_CFG_FIRMWARE_VERSION in dfmConfig.h.
#
#  - elf_destination_path: Where to save the ELF file after the download, including the filename.

def download_elf_file(product_id, revision, elf_destination_path):
    print("userhooks.download_elf_file")
    print("  Product ID: " + product_id)
    print("  Revision: " + revision)
    print("  Local ELF path: " + elf_destination_path)
    
    # This example simulates the download by copying the demo elf file to elf_destination_path.
    # This assumes using the demo data in the ../test-data folder, where the Revision attribute
    # of the alerts equals the elf filename minus the .elf suffix.

    # Integrators who need this hook are expected to modify this code to generate the right path
    # for the remote server, based on product_id and revision, and download it using curl or wget.
    # The docker-based Linux client comes with these tools pre-installed.


    if (platform.system() == 'Windows'):
        os.system("copy ..\\test-data\\" + revision + ".elf \"" + elf_destination_path + "\"")
    elif (platform.system() == 'Linux'):
        # "Linux" here assumes the Docker packaging
        os.system("cp /host-mounts/device_elf/" + revision + ".elf \"" + elf_destination_path + "\"")
    
    # Return False on any download errors to abort processing the request further.
    return True

# download_src_files - Hook for downloading source files.
# This is optional. The core dump viewer will attempt to show a source code snippet at the fault
# location. This assumes the right version of the source code is available to the client. 
# If not already in the local file system, you may use this hook to download it (e.g. with a git
# checkout). You may however view the core dumps also without the source code. Most information
# like function call stack only requires the ELF file.
#
# Arguments:
#
#  - product_id: The numeric product ID defined in the target-side DFM library.
#    This is defined by DFM_CFG_PRODUCTID in dfmConfig.h and is here provided as a string.
#
#  - revision: The revision attribute from the target-side DFM library, i.e. the device software version.
#    This is defined by DFM_CFG_FIRMWARE_VERSION in dfmConfig.h.
#
#  - src_dir: The path where the source files should be saved. The Client has already created the
#    parent directory when this hook is called. The folder is persistent also in the Linux/Docker version.

def download_src_files(product_id, revision, src_dir):
    print("userhooks.download_src_files")
    print("  Product ID: " + product_id)
    print("  Revision: " + revision)
    print("  Local source path: " + src_dir)

    # This example simulates the source code download by copying the demo source files to src_dir.
    # This assumes using the demo data in the ../test-data folder, where the Revision attribute
    # of the alerts equals the elf filename minus the .elf suffix.

    # Integrators who need this hook are expected to modify this code to generate the right path
    # for the remote server, based on product_id and revision, and fetch it using e.g. git or wget.
    # The docker-based Linux client comes with git, wget and curl pre-installed.

    if (platform.system() == 'Windows'):        
        os.system("xcopy \"../device-integration/demo-projects/" + revision + "\" \"" + src_dir + "\" /E /Y /Q")
    elif (platform.system() == 'Linux'):
        os.system("cp -r /host-mounts/device_src/" + revision + "/. " + src_dir)

    # Return False on any download errors to abort processing the request further.
    return True
