@echo off
setlocal enabledelayedexpansion

rem Set default values
set ACTION=%1
set ALERTS_DIR=%cd%\..\test-data\alert-files

rem Specify your Detect Server license key below, e.g. $LICENSE="ABCD-ABCD-ABCD-ABCD"
set LICENSE=""

rem When used on a shared server, change this to the server IP address (as seen from the clients).
set BACKEND_IP=127.0.0.1

rem MySQL variables
set MYSQL_ROOT_PASSWORD=DevalertMysql
set MYSQL_DATABASE=devalert

rem Docker variables
set NETWORK_NAME=percepio-network
set VOLUME_NAME=percepio_database
set TAG=2025.2

rem Image names
set FRONTEND_IMAGE=percepio/detect-frontend:%TAG%
set BACKEND_IMAGE=percepio/detect-backend:%TAG%
set ALERT_SENDER_IMAGE=percepio/detect-alertsender:%TAG%
set DATABASE_IMAGE=percepio/detect-database:%TAG%

rem Container names
set DATABASE_CONTAINER=detect-database
set ALERT_SENDER_CONTAINER=detect-alert-sender
set FRONTEND_CONTAINER=detect-frontend
set BACKEND_CONTAINER=detect-backend

rem Ports
set HTTP_FRONTEND_PORT=8080
set HTTPS_FRONTEND_PORT=8081
set HTTP_BACKEND_PORT=7074
set HTTPS_BACKEND_PORT=7073
set BACKEND_REST_API=http://%BACKEND_IP%:%HTTP_BACKEND_PORT%/api
set BACKEND_ALERTS_REST_ENDPOINT=http://%BACKEND_CONTAINER%:%HTTP_BACKEND_PORT%/api/alert

rem Check arguments
if "%ACTION%"=="" (
    echo Usage: percepio-server.bat [start, stop, logs, cleanup]
    exit /b 1
)

rem Start Containers
if /i "%ACTION%"=="start" (
    echo Starting Docker containers...

    rem Create Docker network if not exists
    docker network ls --filter name=%NETWORK_NAME% | findstr %NETWORK_NAME% >nul
    if not errorlevel 1 (
        echo Network %NETWORK_NAME% exists, skipping creation.
    ) else (
        echo Network %NETWORK_NAME% not found, creating network...
        docker network create %NETWORK_NAME%
    )

    rem Ensure the Docker volume exists
    docker volume ls --filter name=%VOLUME_NAME% | findstr %VOLUME_NAME% >nul
    if not errorlevel 1 (
        echo Volume %VOLUME_NAME% exists, skipping creation.
    ) else (
        echo Volume %VOLUME_NAME% not found, creating volume...
        docker volume create %VOLUME_NAME%
    )

    rem Start MySQL container
    docker run -d --name %DATABASE_CONTAINER% --network %NETWORK_NAME% ^
        -e MYSQL_ROOT_PASSWORD=%MYSQL_ROOT_PASSWORD% ^
        -e MYSQL_DATABASE=%MYSQL_DATABASE% ^
        -v %VOLUME_NAME%:/var/lib/mysql ^
        %DATABASE_IMAGE%

    rem Start Backend container
    docker run -d --name %BACKEND_CONTAINER% --network %NETWORK_NAME% ^
        --link %DATABASE_CONTAINER%:mysql ^
        -p %HTTP_BACKEND_PORT%:7074 ^
        -p %HTTPS_BACKEND_PORT%:7073 ^
        -e LICENSE_KEY=%LICENSE% ^
        -e RDS_ENDPOINT=mysql ^
        -e RDS_PORT=3306 ^
        -e RDS_DATABASE=%MYSQL_DATABASE% ^
        -e RDS_USER=root ^
        -e RDS_PASSWORD=%MYSQL_ROOT_PASSWORD% ^
        %BACKEND_IMAGE%

    rem Start Frontend container
    docker run -d --name %FRONTEND_CONTAINER% --network %NETWORK_NAME% ^
        -p %HTTP_FRONTEND_PORT%:80 ^
        -p %HTTPS_FRONTEND_PORT%:443 ^
        -v .\cert:/etc/nginx/ssl ^
        -e VUE_APP_API_ENDPOINT=%BACKEND_REST_API% ^
        %FRONTEND_IMAGE%

    rem Start Alert Sender container
    docker run -d --name %ALERT_SENDER_CONTAINER% --network %NETWORK_NAME% ^
        -e SEND_ALERTS_URL=%BACKEND_ALERTS_REST_ENDPOINT% ^
        -e TRACE_DIR=/app/data/ ^
        -e CHECK_INTERVAL_MS=5000 ^
        -v %ALERTS_DIR%:/app/data ^
        --tty ^
        --restart on-failure ^
        %ALERT_SENDER_IMAGE%

    echo Detect Server containers started.
)

rem Stop Containers
if /i "%ACTION%"=="stop" (
    echo Stopping and removing Detect Server containers...

    docker stop %ALERT_SENDER_CONTAINER% %FRONTEND_CONTAINER% %BACKEND_CONTAINER% %DATABASE_CONTAINER%
    docker rm %ALERT_SENDER_CONTAINER% %FRONTEND_CONTAINER% %BACKEND_CONTAINER% %DATABASE_CONTAINER%

    echo Removing custom network...
    docker network rm %NETWORK_NAME%

    echo All containers stopped and removed, network '%NETWORK_NAME%' deleted.
)

rem Follow Logs
if /i "%ACTION%"=="logs" (
    echo Following logs for all containers...

    start cmd /k "docker logs -f %DATABASE_CONTAINER%"
    start cmd /k "docker logs -f %BACKEND_CONTAINER%"
    start cmd /k "docker logs -f %FRONTEND_CONTAINER%"
    start cmd /k "docker logs -f %ALERT_SENDER_CONTAINER%"
)

rem Cleanup Docker Resources
if /i "%ACTION%"=="cleanup" (
    echo WARNING: This will delete the database, remove Docker containers, network, and volume. The alert files remain.

    set /p ans=Enter yes to confirm:
   
    if /i "!ans!"=="yes" (
        echo Starting full Docker cleanup...

        rem Reuse Stop-Containers to stop and remove all containers
        call %0 stop

        rem Remove Docker network if it exists
        docker network ls --filter name=%NETWORK_NAME% | findstr %NETWORK_NAME% >nul
        if not errorlevel 1 (
            echo Removing Docker network...
            docker network rm %NETWORK_NAME%
        )

        rem Remove Docker volume if it exists
        docker volume ls --filter name=%VOLUME_NAME% | findstr %VOLUME_NAME% >nul
        if not errorlevel 1 (
            echo Removing Docker volume...
            docker volume rm %VOLUME_NAME%
        )
		
		echo Deleting lasttrace.txt, success.txt and failure.txt
        del /f /q "%ALERTS_DIR%\lasttrace.txt" >nul 2>&1
		del /f /q "%ALERTS_DIR%\success.txt" >nul 2>&1
		del /f /q "%ALERTS_DIR%\failure.txt" >nul 2>&1

        echo Cleanup finished.
    ) else (
        echo Cleanup aborted by user.
    )
)

endlocal
